DROP TRIGGER ADR.ACTIVATION_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ACTIVATION_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.ACTIVATION
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into ACTIVATION_H
        (
        ACTIVATION_H_ID,
        ACTIVATION_ID,
        PERSON_ID,
        STD_MHDATASOURCE_ID,
        STD_NAMEDCONTINGENCY_ID,
        STD_TERMINATIONREASON_ID,
        STD_SPECIALOPERATION_ID,
        ACTIVATION_BEGIN_DATE,
        ACTIVATION_END_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE,
        PROJECT_CODE
        )
        values
        (
        ACTIVATION_H_S.nextval,
        :old.ACTIVATION_ID,
        :old.PERSON_ID,
        :old.STD_MHDATASOURCE_ID,
        :old.STD_NAMEDCONTINGENCY_ID,
        :old.STD_TERMINATIONREASON_ID,
        :old.STD_SPECIALOPERATION_ID,
        :old.ACTIVATION_BEGIN_DATE,
        :old.ACTIVATION_END_DATE,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D',
        :old.PROJECT_CODE
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into ACTIVATION_H
        (
        ACTIVATION_H_ID,
        ACTIVATION_ID,
        PERSON_ID,
        STD_MHDATASOURCE_ID,
        STD_NAMEDCONTINGENCY_ID,
        STD_TERMINATIONREASON_ID,
        STD_SPECIALOPERATION_ID,
        ACTIVATION_BEGIN_DATE,
        ACTIVATION_END_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE,
        PROJECT_CODE
        )
        values
        (
        ACTIVATION_H_S.nextval,
        :new.ACTIVATION_ID,
        :new.PERSON_ID,
        :new.STD_MHDATASOURCE_ID,
        :new.STD_NAMEDCONTINGENCY_ID,
        :new.STD_TERMINATIONREASON_ID,
        :new.STD_SPECIALOPERATION_ID,
        :new.ACTIVATION_BEGIN_DATE,
        :new.ACTIVATION_END_DATE,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML,
        :new.PROJECT_CODE
        );
    end if;

end ACTIVATION_audir_trgr;
/
DROP TRIGGER ADR.ACTIVEAGG_TRACKER_BUR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ACTIVEAGG_TRACKER_BUR_TRGR
   BEFORE UPDATE
   ON ADR.ACTIVEAGG_TRACKER
   REFERENCING NEW AS New OLD AS Old
   FOR EACH ROW
DECLARE
BEGIN

   :new.RECORD_MODIFIED_TS := SYSDATE;
EXCEPTION
   WHEN OTHERS
   THEN
      DBMS_OUTPUT.put_line (SUBSTR (   DBMS_UTILITY.FORMAT_CALL_STACK
                                    || DBMS_UTILITY.format_error_stack
                                    || DBMS_UTILITY.format_error_backtrace,
                                    1,
                                    2000));
END ACTIVEAGG_TRACKER_BUR_TRGR;
/
DROP TRIGGER ADR.ADDRESS_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ADDRESS_AUDIR_TRGR
    AFTER UPDATE OR INSERT OR DELETE
    ON ADR.ADDRESS
    FOR EACH ROW
DECLARE
    mDML   CHAR (1);
BEGIN
    IF DELETING
    THEN
        INSERT INTO ADDRESS_H (ADDRESS_H_ID,
                               ADDRESS_ID,
                               PERSON_ID,
                               INSURANCE_ID,
                               STD_ADDRESSTYPE_ID,
                               ADDRESS_CHANGE_SRC_TYPE_ID,
                               STD_INSTITUTION_ID,
                               ADDRESS_INVALID_TYPE_ID,
                               NCOA_STATUS_TYPE_ID,
                               NCOA_DELIVERY_TYPE_ID,
                               NCOA_ZIP_MATCH_TYPE_ID,
                               ADDRESS_LINE1,
                               ADDRESS_LINE2,
                               ADDRESS_LINE3,
                               CITY,
                               STATE_CODE,
                               COUNTY_CODE,
                               PROVINCE_CODE,
                               POSTAL_CODE,
                               ZIP_PLUS_4,
                               COUNTRY_CODE,
                               ADDRESS_CHANGE_EFFECTIVE_DATE,
                               ADDRESS_INVALIDATED_DATE,
                               NCOA_ADDRESS_CHECK_DATE,
                               ADDRESS_START_DATE_TXT,
                               ADDRESS_END_DATE_TXT,
                               RECORD_CREATED_BY,
                               RECORD_CREATED_DATE,
                               RECORD_MODIFIED_BY,
                               RECORD_MODIFIED_DATE,
                               RECORD_MODIFIED_COUNT,
                               ADDRESS_PHONE_NUMBER,
                               ZIP_CODE,
                               NCOA_ZIP_NO_MATCH_TYPE_ID,
                               RECORD_MODIFIED_SRC_NAME,
                               PERSON_RELATION_ID,
                               CASSCERTIFIEDTYPE_ID,
                               CASS_CERTIFIED_DATE,
                               purpose_of_use_type_id,
                               TRANSACTION_TYPE_CODE,
                               SITE_OF_CHANGE_ID,
                               GEOCODING_REQUIRED_IND)
             VALUES (ADDRESS_h_s.NEXTVAL,
                     :old.ADDRESS_ID,
                     :old.PERSON_ID,
                     :old.INSURANCE_ID,
                     :old.STD_ADDRESSTYPE_ID,
                     :old.ADDRESS_CHANGE_SRC_TYPE_ID,
                     :old.STD_INSTITUTION_ID,
                     :old.ADDRESS_INVALID_TYPE_ID,
                     :old.NCOA_STATUS_TYPE_ID,
                     :old.NCOA_DELIVERY_TYPE_ID,
                     :old.NCOA_ZIP_MATCH_TYPE_ID,
                     :old.ADDRESS_LINE1,
                     :old.ADDRESS_LINE2,
                     :old.ADDRESS_LINE3,
                     :old.CITY,
                     :old.STATE_CODE,
                     :old.COUNTY_CODE,
                     :old.PROVINCE_CODE,
                     :old.POSTAL_CODE,
                     :old.ZIP_PLUS_4,
                     :old.COUNTRY_CODE,
                     :old.ADDRESS_CHANGE_EFFECTIVE_DATE,
                     :old.ADDRESS_INVALIDATED_DATE,
                     :old.NCOA_ADDRESS_CHECK_DATE,
                     :old.ADDRESS_START_DATE_TXT,
                     :old.ADDRESS_END_DATE_TXT,
                     :old.RECORD_CREATED_BY,
                     :old.RECORD_CREATED_DATE,
                     :old.RECORD_MODIFIED_BY,
                     :old.RECORD_MODIFIED_DATE,
                     :old.RECORD_MODIFIED_COUNT,
                     :old.ADDRESS_PHONE_NUMBER,
                     :old.ZIP_CODE,
                     :old.NCOA_ZIP_NO_MATCH_TYPE_ID,
                     :old.RECORD_MODIFIED_SRC_NAME,
                     :old.PERSON_RELATION_ID,
                     :old.CASSCERTIFIEDTYPE_ID,
                     :old.CASS_CERTIFIED_DATE,
                     :old.purpose_of_use_type_id,
                     'D',
                     :old.SITE_OF_CHANGE_ID,
                     :old.GEOCODING_REQUIRED_IND);
    ELSE
        IF UPDATING
        THEN
            -- this if logic is added to avoid unnecessary inserts to ADDRESS_H table for geocode
            --
            -- only change of GEOCODING_REQUIRED_IND tracked by this trigger is when GEOCODING_REQUIRED_IND changes from N/Null to Y
            -- because Y and update of address (street, zipcode ....) will happen in the same transaction
            -- when an address (content) is changed, ES application code will make GEOCODING_REQUIRED_IND to Y
            --
            -- Y: geocoding is required
            -- I: geocoding is inprogress
            -- N: geocoding is NOT required
            -- P: forced logging
            --  (for a case when permanent address is updated and we want to remove 'Y' -- setting to P so logged, because residential address also exists)
            --    when only permanent address available for a person, permanent address will be used for geocoding
            --    when this case happens and then later residential addresses is added. it is required to use residential address for geocoding so it is needed
            --    to make permanent address GEOCODING_REQUIRED_IND to 'P' so it won't be used for geocoding and also logged into address_h
            --
            IF     NVL (:old.GEOCODING_REQUIRED_IND, 'N') <>
                   NVL (:new.GEOCODING_REQUIRED_IND, 'N')
               AND :new.GEOCODING_REQUIRED_IND IN ('I', 'N') -- Inprogress or Not Required for geocoding
            THEN
                mDML := 'X';
            ELSE
                mDML := 'U';
            END IF;
        ELSE
            mDML := 'I';
        END IF;

        IF mDML <> 'X'
        THEN
            INSERT INTO ADDRESS_H (ADDRESS_H_ID,
                                   ADDRESS_ID,
                                   PERSON_ID,
                                   INSURANCE_ID,
                                   STD_ADDRESSTYPE_ID,
                                   ADDRESS_CHANGE_SRC_TYPE_ID,
                                   STD_INSTITUTION_ID,
                                   ADDRESS_INVALID_TYPE_ID,
                                   NCOA_STATUS_TYPE_ID,
                                   NCOA_DELIVERY_TYPE_ID,
                                   NCOA_ZIP_MATCH_TYPE_ID,
                                   ADDRESS_LINE1,
                                   ADDRESS_LINE2,
                                   ADDRESS_LINE3,
                                   CITY,
                                   STATE_CODE,
                                   COUNTY_CODE,
                                   PROVINCE_CODE,
                                   POSTAL_CODE,
                                   ZIP_PLUS_4,
                                   COUNTRY_CODE,
                                   ADDRESS_CHANGE_EFFECTIVE_DATE,
                                   ADDRESS_INVALIDATED_DATE,
                                   NCOA_ADDRESS_CHECK_DATE,
                                   ADDRESS_START_DATE_TXT,
                                   ADDRESS_END_DATE_TXT,
                                   RECORD_CREATED_BY,
                                   RECORD_CREATED_DATE,
                                   RECORD_MODIFIED_BY,
                                   RECORD_MODIFIED_DATE,
                                   RECORD_MODIFIED_COUNT,
                                   ADDRESS_PHONE_NUMBER,
                                   ZIP_CODE,
                                   NCOA_ZIP_NO_MATCH_TYPE_ID,
                                   RECORD_MODIFIED_SRC_NAME,
                                   PERSON_RELATION_ID,
                                   CASSCERTIFIEDTYPE_ID,
                                   CASS_CERTIFIED_DATE,
                                   purpose_of_use_type_id,
                                   TRANSACTION_TYPE_CODE,
                                   SITE_OF_CHANGE_ID,
                                   GEOCODING_REQUIRED_IND)
                 VALUES (ADDRESS_h_s.NEXTVAL,
                         :new.ADDRESS_ID,
                         :new.PERSON_ID,
                         :new.INSURANCE_ID,
                         :new.STD_ADDRESSTYPE_ID,
                         :new.ADDRESS_CHANGE_SRC_TYPE_ID,
                         :new.STD_INSTITUTION_ID,
                         :new.ADDRESS_INVALID_TYPE_ID,
                         :new.NCOA_STATUS_TYPE_ID,
                         :new.NCOA_DELIVERY_TYPE_ID,
                         :new.NCOA_ZIP_MATCH_TYPE_ID,
                         :new.ADDRESS_LINE1,
                         :new.ADDRESS_LINE2,
                         :new.ADDRESS_LINE3,
                         :new.CITY,
                         :new.STATE_CODE,
                         :new.COUNTY_CODE,
                         :new.PROVINCE_CODE,
                         :new.POSTAL_CODE,
                         :new.ZIP_PLUS_4,
                         :new.COUNTRY_CODE,
                         :new.ADDRESS_CHANGE_EFFECTIVE_DATE,
                         :new.ADDRESS_INVALIDATED_DATE,
                         :new.NCOA_ADDRESS_CHECK_DATE,
                         :new.ADDRESS_START_DATE_TXT,
                         :new.ADDRESS_END_DATE_TXT,
                         :new.RECORD_CREATED_BY,
                         :new.RECORD_CREATED_DATE,
                         :new.RECORD_MODIFIED_BY,
                         :new.RECORD_MODIFIED_DATE,
                         :new.RECORD_MODIFIED_COUNT,
                         :new.ADDRESS_PHONE_NUMBER,
                         :new.ZIP_CODE,
                         :new.NCOA_ZIP_NO_MATCH_TYPE_ID,
                         :new.RECORD_MODIFIED_SRC_NAME,
                         :new.PERSON_RELATION_ID,
                         :new.CASSCERTIFIEDTYPE_ID,
                         :new.CASS_CERTIFIED_DATE,
                         :new.purpose_of_use_type_id,
                         mDML,
                         :new.SITE_OF_CHANGE_ID,
                         :new.GEOCODING_REQUIRED_IND);
        END IF;
    END IF;
END ADDRESS_audir_trgr;
/
DROP TRIGGER ADR.ADDR_CONF_DTL_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ADDR_CONF_DTL_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.ADDR_CONFIDENTIAL_DTL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ADDR_CONFIDENTIAL_DTL_H
		(
                ADDR_CONFIDENTIAL_DTL_H_ID,
 		ADDR_CONFIDENTIAL_DTL_ID,
 		ADDRESS_ID,
 		STD_CONFIDENTIALADDRESSCAT_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
      		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ADDR_CONFIDENTIAL_DTL_H_s.nextval,
		:old.ADDR_CONFIDENTIAL_DTL_ID,
		:old.ADDRESS_ID,
		:old.STD_CONFIDENTIALADDRESSCAT_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY ,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;
		insert into ADDR_CONFIDENTIAL_DTL_H
		(
                ADDR_CONFIDENTIAL_DTL_H_ID,
 		ADDR_CONFIDENTIAL_DTL_ID,
 		ADDRESS_ID,
 		STD_CONFIDENTIALADDRESSCAT_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
      		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ADDR_CONFIDENTIAL_DTL_H_s.nextval,
		:new.ADDR_CONFIDENTIAL_DTL_ID,
		:new.ADDRESS_ID,
		:new.STD_CONFIDENTIALADDRESSCAT_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY ,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end ADDR_CONF_DTL_audir_trgr;
/
DROP TRIGGER ADR.APPOINTMENT_REQUEST_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.APPOINTMENT_REQUEST_AUDIR_TRGR
    AFTER UPDATE OR INSERT OR DELETE
    ON ADR.APPOINTMENT_REQUEST
    FOR EACH ROW
DECLARE
    mDML   CHAR (1);
BEGIN
    IF DELETING
    THEN
        INSERT INTO ADR.APPOINTMENT_REQUEST_H (APPOINTMENT_REQUEST_H_ID,
                                           APPOINTMENT_REQUEST_ID,
                                           PERSON_ID,
                                           RESPONSE,
                                           RESPONSE_DATE,
                                           RESPONSE_CHG_DATE,
                                           ORIG_RESPONSE,
                                           ORIG_RESPONSE_DATE,
                                           ORIG_RESPONSE_CHG_DATE,
                                           RECORD_CREATED_BY,
                                           RECORD_CREATED_DATE,
                                           RECORD_MODIFIED_BY,
                                           RECORD_MODIFIED_DATE,
                                           RECORD_MODIFIED_COUNT,
                                           TRANSACTION_TYPE_CODE)
             VALUES (APPOINTMENT_REQUEST_H_S.NEXTVAL,
                     :old.APPOINTMENT_REQUEST_ID,
                     :old.PERSON_ID,
                     :old.RESPONSE,
                     :old.RESPONSE_DATE,
                     :old.RESPONSE_CHG_DATE,
                     :old.ORIG_RESPONSE,
                     :old.ORIG_RESPONSE_DATE,
                     :old.ORIG_RESPONSE_CHG_DATE,
                     :old.RECORD_CREATED_BY,
                     :old.RECORD_CREATED_DATE,
                     :old.RECORD_MODIFIED_BY,
                     :old.RECORD_MODIFIED_DATE,
                     :old.RECORD_MODIFIED_COUNT,
                     'D');
    ELSE
        IF UPDATING
        THEN
            mDML := 'U';
        ELSE
            mDML := 'I';
        END IF;

        INSERT INTO ADR.APPOINTMENT_REQUEST_H (APPOINTMENT_REQUEST_H_ID,
                                           APPOINTMENT_REQUEST_ID,
                                           PERSON_ID,
                                           RESPONSE,
                                           RESPONSE_DATE,
                                           RESPONSE_CHG_DATE,
                                           ORIG_RESPONSE,
                                           ORIG_RESPONSE_DATE,
                                           ORIG_RESPONSE_CHG_DATE,
                                           RECORD_CREATED_BY,
                                           RECORD_CREATED_DATE,
                                           RECORD_MODIFIED_BY,
                                           RECORD_MODIFIED_DATE,
                                           RECORD_MODIFIED_COUNT,
                                           TRANSACTION_TYPE_CODE)
             VALUES (APPOINTMENT_REQUEST_H_S.NEXTVAL,
                     :new.APPOINTMENT_REQUEST_ID,
                     :new.PERSON_ID,
                     :new.RESPONSE,
                     :new.RESPONSE_DATE,
                     :new.RESPONSE_CHG_DATE,
                     :new.ORIG_RESPONSE,
                     :new.ORIG_RESPONSE_DATE,
                     :new.ORIG_RESPONSE_CHG_DATE,
                     :new.RECORD_CREATED_BY,
                     :new.RECORD_CREATED_DATE,
                     :new.RECORD_MODIFIED_BY,
                     :new.RECORD_MODIFIED_DATE,
                     :new.RECORD_MODIFIED_COUNT,
                     mDML);
    END IF;
END APPOINTMENT_REQUEST_AUDIR_TRGR;
/
DROP TRIGGER ADR.APP_PARAMETER_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.APP_PARAMETER_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.APP_PARAMETER
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO ADR.APP_PARAMETER_H (APP_PARAMETER_H_ID,
                                       APP_PARAMETER_ID,
                                       APP_PARAMETER_TYPE_ID,
                                       APP_PARAMETER_UNIT_ID,
                                       APPLICATION_NAME,
                                       PARAMETER_NAME,
                                       PARAMETER_DESCRIPTION,
                                       PARAMETER_VALUE,
                                       PARAMETER_DATA_LENGTH,
                                       PARAMETER_EFFECTIVE_DATE,
                                       INACTIVE_FLAG,
                                       INACTIVE_DATE,
                                       RECORD_CREATED_BY,
                                       RECORD_CREATED_DATE,
                                       RECORD_MODIFIED_BY,
                                       RECORD_MODIFIED_DATE,
                                       TRANSACTION_TYPE_CODE,
                                       PARAMETER_FUTURE_VALUE)
           VALUES (APP_PARAMETER_H_S.NEXTVAL,
                   :old.APP_PARAMETER_ID,
                   :old.APP_PARAMETER_TYPE_ID,
                   :old.APP_PARAMETER_UNIT_ID,
                   :old.APPLICATION_NAME,
                   :old.PARAMETER_NAME,
                   :old.PARAMETER_DESCRIPTION,
                   :old.PARAMETER_VALUE,
                   :old.PARAMETER_DATA_LENGTH,
                   :old.PARAMETER_EFFECTIVE_DATE,
                   :old.INACTIVE_FLAG,
                   :old.INACTIVE_DATE,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   mDML,
                   :old.PARAMETER_FUTURE_VALUE);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO APP_PARAMETER_H (APP_PARAMETER_H_ID,
                                   APP_PARAMETER_ID,
                                   APP_PARAMETER_TYPE_ID,
                                   APP_PARAMETER_UNIT_ID,
                                   APPLICATION_NAME,
                                   PARAMETER_NAME,
                                   PARAMETER_DESCRIPTION,
                                   PARAMETER_VALUE,
                                   PARAMETER_DATA_LENGTH,
                                   PARAMETER_EFFECTIVE_DATE,
                                   INACTIVE_FLAG,
                                   INACTIVE_DATE,
                                   RECORD_CREATED_BY,
                                   RECORD_CREATED_DATE,
                                   RECORD_MODIFIED_BY,
                                   RECORD_MODIFIED_DATE,
                                   TRANSACTION_TYPE_CODE,
                                   PARAMETER_FUTURE_VALUE)
           VALUES (APP_PARAMETER_H_S.NEXTVAL,
                   :new.APP_PARAMETER_ID,
                   :new.APP_PARAMETER_TYPE_ID,
                   :new.APP_PARAMETER_UNIT_ID,
                   :new.APPLICATION_NAME,
                   :new.PARAMETER_NAME,
                   :new.PARAMETER_DESCRIPTION,
                   :new.PARAMETER_VALUE,
                   :new.PARAMETER_DATA_LENGTH,
                   :new.PARAMETER_EFFECTIVE_DATE,
                   :new.INACTIVE_FLAG,
                   :new.INACTIVE_DATE,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   mDML,
                   :new.PARAMETER_FUTURE_VALUE);
   END IF;
END APP_PARAMETER_AUDIR_TRGR;
/
DROP TRIGGER ADR.BATCH_REQUEST_FAC_AUD_TRGR;

CREATE OR REPLACE TRIGGER ADR.BATCH_REQUEST_FAC_AUD_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.BATCH_REQUEST_FACILITY  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into BATCH_REQUEST_FACILITY_H
        (
        BATCH_REQUEST_FACILITY_H_ID,
        BATCH_REQUEST_FACILITY_ID,
        HANDBOOK_BATCH_REQUEST_ID,
        STD_INSTITUTION_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE,
        PARENT_STD_INSTITUTION_ID
        )
        values
        (
        BATCH_REQUEST_FACILITY_H_S.nextval,
        :old.BATCH_REQUEST_FACILITY_ID,
        :old.HANDBOOK_BATCH_REQUEST_ID,
       :old.STD_INSTITUTION_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D',
        :old.PARENT_STD_INSTITUTION_ID
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into BATCH_REQUEST_FACILITY_H
        (
        BATCH_REQUEST_FACILITY_H_ID,
        BATCH_REQUEST_FACILITY_ID,
    HANDBOOK_BATCH_REQUEST_ID,
    STD_INSTITUTION_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE,
        PARENT_STD_INSTITUTION_ID
        )
        values
        (
        BATCH_REQUEST_FACILITY_H_S.nextval,
        :new.BATCH_REQUEST_FACILITY_ID,
    :new.HANDBOOK_BATCH_REQUEST_ID,
    :new.STD_INSTITUTION_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML,
        :new.PARENT_STD_INSTITUTION_ID
        );
    end if;

end BATCH_REQUEST_FAC_AUD_TRGR;
/
DROP TRIGGER ADR.BATCH_REQ_PRI_GRP_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.BATCH_REQ_PRI_GRP_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.BATCH_REQUEST_PRIORITY_GROUP  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into BATCH_REQUEST_PRIORITY_GROUP_H
        (
        BATCH_REQUEST_PRI_GRP_H_ID,
        BATCH_REQUEST_PRIORITY_GRP_ID,
    STD_ENROLLMENTPRIORSGRP_ID,
    STD_ENROLLMENTPRIORGRP_ID,
    HANDBOOK_BATCH_REQUEST_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        BATCH_REQUEST_PRI_GRP_H_ID_S.nextval,
        :old.BATCH_REQUEST_PRIORITY_GRP_ID,
    :old.STD_ENROLLMENTPRIORSGRP_ID,
    :old.STD_ENROLLMENTPRIORGRP_ID,
    :old.HANDBOOK_BATCH_REQUEST_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into BATCH_REQUEST_PRIORITY_GROUP_H
        (
        BATCH_REQUEST_PRI_GRP_H_ID,
        BATCH_REQUEST_PRIORITY_GRP_ID,
    STD_ENROLLMENTPRIORSGRP_ID,
    STD_ENROLLMENTPRIORGRP_ID,
    HANDBOOK_BATCH_REQUEST_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        BATCH_REQUEST_PRI_GRP_H_ID_S.nextval,
        :new.BATCH_REQUEST_PRIORITY_GRP_ID,
    :new.STD_ENROLLMENTPRIORSGRP_ID,
    :new.STD_ENROLLMENTPRIORGRP_ID,
    :new.HANDBOOK_BATCH_REQUEST_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end BATCH_REQ_PRI_GRP_AUDIR_TRGR;
/
DROP TRIGGER ADR.BENEFICIARY_MST_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.BENEFICIARY_MST_AUDIR_TRGR
after Update or Delete or Insert
on ADR.BENEFICIARY_MST
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin
	if DELETING then
		insert into BENEFICIARY_MST_H
		(
		BENEFICIARY_MST_H_ID,
		BENEFICIARY_MST_ID  ,
		PERSON_ID           ,
		MST_STATUS_TYPE_ID ,
		STD_INSTITUTION_ID  ,
		MST_EVALUATION_DATE,
		RECORD_CREATED_BY   ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY  ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_mst_h_s.nextval,
		:old.BENEFICIARY_MST_ID,
		:old.PERSON_ID        ,
		:old.MST_STATUS_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.MST_EVALUATION_DATE,
		:old.RECORD_CREATED_BY ,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY ,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else

		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into BENEFICIARY_MST_H
		(
		BENEFICIARY_MST_H_ID,
		BENEFICIARY_MST_ID  ,
		PERSON_ID           ,
		MST_STATUS_TYPE_ID ,
		STD_INSTITUTION_ID ,
		MST_EVALUATION_DATE,
		RECORD_CREATED_BY  ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_mst_h_s.nextval,
		:new.BENEFICIARY_MST_ID,
		:new.PERSON_ID         ,
		:new.MST_STATUS_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.MST_EVALUATION_DATE,
		:new.RECORD_CREATED_BY  ,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end beneficiary_mst_audir_trgr;
/
DROP TRIGGER ADR.BENEFICIARY_NTR_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.BENEFICIARY_NTR_AUDIR_TRGR
after Update or Delete or Insert
on ADR.BENEFICIARY_NTR
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into BENEFICIARY_NTR_H
		(
		BENEFICIARY_NTR_H_ID ,
		BENEFICIARY_NTR_ID       ,
		PERSON_ID                      ,
		NTR_DIAGNOSIS_SITE_ID ,
		NTR_VERIFICATION_SITE_ID ,
		NTR_VERIFY_METHOD_TYPE_ID,
		VERIFICATION_DATE            ,
		AVIATOR_PRE1955_IND        ,
		NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		RECEIVED_NTR_TREATMENT_IND     ,
		DIAGNOSED_HEAD_NECK_CANCER_IND,
		HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		RECORD_CREATED_BY              ,
		RECORD_CREATED_DATE         ,
		RECORD_MODIFIED_BY             ,
		RECORD_MODIFIED_DATE        ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_ntr_h_s.nextval,
		:old.BENEFICIARY_NTR_ID       ,
		:old.PERSON_ID                      ,
		:old.NTR_DIAGNOSIS_SITE_ID ,
		:old.NTR_VERIFICATION_SITE_ID ,
		:old.NTR_VERIFY_METHOD_TYPE_ID,
		:old.VERIFICATION_DATE            ,
		:old.AVIATOR_PRE1955_IND        ,
		:old.NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		:old.RECEIVED_NTR_TREATMENT_IND     ,
		:old.DIAGNOSED_HEAD_NECK_CANCER_IND,
		:old.HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		:old.RECORD_CREATED_BY              ,
		:old.RECORD_CREATED_DATE         ,
		:old.RECORD_MODIFIED_BY             ,
		:old.RECORD_MODIFIED_DATE        ,
		:old.RECORD_MODIFIED_COUNT     ,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into BENEFICIARY_NTR_H
		(
		BENEFICIARY_NTR_H_ID ,
		BENEFICIARY_NTR_ID       ,
		PERSON_ID                      ,
		NTR_DIAGNOSIS_SITE_ID ,
		NTR_VERIFICATION_SITE_ID ,
		NTR_VERIFY_METHOD_TYPE_ID,
		VERIFICATION_DATE            ,
		AVIATOR_PRE1955_IND        ,
		NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		RECEIVED_NTR_TREATMENT_IND     ,
		DIAGNOSED_HEAD_NECK_CANCER_IND,
		HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		RECORD_CREATED_BY              ,
		RECORD_CREATED_DATE         ,
		RECORD_MODIFIED_BY             ,
		RECORD_MODIFIED_DATE        ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_ntr_h_s.nextval,
		:new.BENEFICIARY_NTR_ID       ,
		:new.PERSON_ID                      ,
		:new.NTR_DIAGNOSIS_SITE_ID ,
		:new.NTR_VERIFICATION_SITE_ID ,
		:new.NTR_VERIFY_METHOD_TYPE_ID,
		:new.VERIFICATION_DATE            ,
		:new.AVIATOR_PRE1955_IND        ,
		:new.NAVY_SUB_TRAINEE_PRE_1965_IND  ,
		:new.RECEIVED_NTR_TREATMENT_IND     ,
		:new.DIAGNOSED_HEAD_NECK_CANCER_IND,
		:new.HEAD_NECK_CANCER_DIAGNOSIS_DT ,
		:new.RECORD_CREATED_BY              ,
		:new.RECORD_CREATED_DATE         ,
		:new.RECORD_MODIFIED_BY             ,
		:new.RECORD_MODIFIED_DATE        ,
		:new.RECORD_MODIFIED_COUNT     ,
		mDML
		);

	end if;
end BENEFICIARY_NTR_audir_trgr;
/
DROP TRIGGER ADR.BENEFICIARY_TRVL_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.BENEFICIARY_TRVL_audir_trgr
after Update or Delete or Insert
ON ADR.BENEFICIARY_TRAVEL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into BENEFICIARY_TRAVEL_H
		(
		BENEFICIARY_TRAVEL_H_ID,
		BENEFICIARY_TRAVEL_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		INCOME_YEAR,
		TRAVEL_CERTIFIED_AMOUNT,
		TRAVEL_CERTIFIED_DATE,
		TRAVEL_CLAIM_DATE,
		TRAVEL_ELIGIBILITY_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		BENEFICIARY_TRAVEL_H_S.nextval,
		:old.BENEFICIARY_TRAVEL_ID,
		:old.PERSON_ID,
		:old.STD_INSTITUTION_ID,
		:old.INCOME_YEAR,
		:old.TRAVEL_CERTIFIED_AMOUNT,
		:old.TRAVEL_CERTIFIED_DATE,
		:old.TRAVEL_CLAIM_DATE,
		:old.TRAVEL_ELIGIBILITY_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into BENEFICIARY_TRAVEL_H
		(
		BENEFICIARY_TRAVEL_H_ID,
		BENEFICIARY_TRAVEL_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		INCOME_YEAR,
		TRAVEL_CERTIFIED_AMOUNT,
		TRAVEL_CERTIFIED_DATE,
		TRAVEL_CLAIM_DATE,
		TRAVEL_ELIGIBILITY_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		beneficiary_travel_h_s.nextval,
		:new.BENEFICIARY_TRAVEL_ID,
		:new.PERSON_ID,
		:new.STD_INSTITUTION_ID,
		:new.INCOME_YEAR,
		:new.TRAVEL_CERTIFIED_AMOUNT,
		:new.TRAVEL_CERTIFIED_DATE,
		:new.TRAVEL_CLAIM_DATE,
		:new.TRAVEL_ELIGIBILITY_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;
end BENEFICIARY_TRVL_audir_trgr;
/
DROP TRIGGER ADR.BENEF_SCI_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.BENEF_SCI_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.BENEFICIARY_SCI
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into BENEFICIARY_SCI_H
		(
		BENEFICIARY_SCI_H_ID,
		BENEFICIARY_SCI_ID,
		PERSON_ID,
		STD_SPINALINJURYCODE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
      		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		BENEFICIARY_SCI_H_s.nextval,
		:old.BENEFICIARY_SCI_ID,
		:old.PERSON_ID,
		:old.STD_SPINALINJURYCODE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY ,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;
		insert into BENEFICIARY_SCI_H
		(
		BENEFICIARY_SCI_H_ID,
		BENEFICIARY_SCI_ID,
		PERSON_ID,
		STD_SPINALINJURYCODE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
      		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		BENEFICIARY_SCI_H_s.nextval,
		:new.BENEFICIARY_SCI_ID,
		:new.PERSON_ID,
		:new.STD_SPINALINJURYCODE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY ,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end BENEF_SCI_audir_trgr;
/
DROP TRIGGER ADR.BENEF_VISIT_SUMM_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.BENEF_VISIT_SUMM_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."BENEFICIARY_VISIT_SUMMARY" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into BENEFICIARY_VISIT_SUMMARY_H
		(
		BENEFICIARY_VISIT_SUMMARY_H_ID,
		BENEFICIARY_VISIT_SUMMARY_ID   ,
		PERSON_ID                      ,
		STD_INSTITUTION_ID  ,
		INCOME_YEAR                  ,
		INPATIENT_DAYS             ,
		OUTPATIENT_VISITS_NUMBER ,
		LAST_VISIT_DATE               ,
		RECORD_CREATED_BY    ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE   ,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		BENEFICIARY_VISIT_SUMMARY_H_S.nextval,
		:old.BENEFICIARY_VISIT_SUMMARY_ID   ,
		:old.PERSON_ID                      ,
		:old.STD_INSTITUTION_ID  ,
		:old.INCOME_YEAR                  ,
		:old.INPATIENT_DAYS             ,
		:old.OUTPATIENT_VISITS_NUMBER ,
		:old.LAST_VISIT_DATE               ,
		:old.RECORD_CREATED_BY    ,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY        ,
		:old.RECORD_MODIFIED_DATE   ,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into BENEFICIARY_VISIT_SUMMARY_H
		(
		BENEFICIARY_VISIT_SUMMARY_H_ID,
		BENEFICIARY_VISIT_SUMMARY_ID   ,
		PERSON_ID                      ,
		STD_INSTITUTION_ID  ,
		INCOME_YEAR                  ,
		INPATIENT_DAYS             ,
		OUTPATIENT_VISITS_NUMBER ,
		LAST_VISIT_DATE               ,
		RECORD_CREATED_BY    ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE   ,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		BENEFICIARY_VISIT_SUMMARY_H_S.nextval,
		:new.BENEFICIARY_VISIT_SUMMARY_ID   ,
		:new.PERSON_ID                      ,
		:new.STD_INSTITUTION_ID  ,
		:new.INCOME_YEAR                  ,
		:new.INPATIENT_DAYS             ,
		:new.OUTPATIENT_VISITS_NUMBER ,
		:new.LAST_VISIT_DATE               ,
		:new.RECORD_CREATED_BY    ,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY        ,
		:new.RECORD_MODIFIED_DATE   ,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end BENEF_VISIT_SUMM_audir_trgr;
/
DROP TRIGGER ADR.CANCEL_DECLINE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CANCEL_DECLINE_AUDIR_TRGR
after Update or Delete or Insert
on ADR.CANCEL_DECLINE
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CANCEL_DECLINE_H
		(
		CANCEL_DECLINE_H_ID,
		CANCEL_DECLINE_ID,
		PERSON_ID,
		CANCEL_DECLINE_STATUS_TYPE_ID,
		CANCEL_DECLINE_REASON_TYPE_ID,
		CANCEL_DECLINE_IND,
		CANCEL_DECLINE_EFFECTIVE_DATE,
		REMARKS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CANCEL_DECLINE_H_S.nextval,
		:old.CANCEL_DECLINE_ID,
		:old.PERSON_ID,
		:old.CANCEL_DECLINE_STATUS_TYPE_ID,
		:old.CANCEL_DECLINE_REASON_TYPE_ID,
		:old.CANCEL_DECLINE_IND,
		:old.CANCEL_DECLINE_EFFECTIVE_DATE,
		:old.REMARKS,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CANCEL_DECLINE_H
		(
		CANCEL_DECLINE_H_ID,
		CANCEL_DECLINE_ID,
		PERSON_ID,
		CANCEL_DECLINE_STATUS_TYPE_ID,
		CANCEL_DECLINE_REASON_TYPE_ID,
		CANCEL_DECLINE_IND,
		CANCEL_DECLINE_EFFECTIVE_DATE,
		REMARKS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CANCEL_DECLINE_H_S.nextval,
		:new.CANCEL_DECLINE_ID,
		:new.PERSON_ID,
		:new.CANCEL_DECLINE_STATUS_TYPE_ID,
		:new.CANCEL_DECLINE_REASON_TYPE_ID,
		:new.CANCEL_DECLINE_IND,
		:new.CANCEL_DECLINE_EFFECTIVE_DATE,
		:new.REMARKS,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  CANCEL_DECLINE_audir_trgr;
/
DROP TRIGGER ADR.CAT_DISABILITY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CAT_DISABILITY_AUDIR_TRGR
  AFTER UPDATE OR DELETE OR INSERT
  ON ADR.CATASTROPHIC_DISABILITY   FOR EACH ROW
DECLARE

    Mdml                               CHAR(1);

BEGIN

  IF DELETING THEN

    INSERT
    INTO      Catastrophic_Disability_H
              (Catastrophic_disability_h_id,
               Catastrophic_disability_id,
               Person_id,
               Cat_dsblty_eval_mthd_type_id,
               Std_institution_id,
               Clinical_approver_name,
               Catastrophically_disabled_ind,
               Cat_dsblty_evaluation_date,
               Decision_date,
               Record_created_by,
               Record_created_date,
               Record_modified_by,
               Record_modified_date,
               Record_modified_count,
               Cat_dsblty_review_requested_dt,
               Cat_dsblty_review_initiated_dt,
               Cat_dsblty_review_notified_dt,
               Transaction_type_code)
    VALUES    (ADR.Catastrophic_disability_h_s.NEXTVAL,
               :OLD.Catastrophic_disability_id     ,
               :OLD.Person_id                      ,
               :OLD.Cat_dsblty_eval_mthd_type_id   ,
               :OLD.Std_institution_id             ,
               :OLD.Clinical_approver_name,
               :OLD.Catastrophically_disabled_ind  ,
               :OLD.Cat_dsblty_evaluation_date     ,
               :OLD.Decision_date                  ,
               :OLD.Record_created_by   ,
               :OLD.Record_created_date            ,
               :OLD.Record_modified_by             ,
               :OLD.Record_modified_date        ,
               :OLD.Record_modified_count     ,
               :OLD.Cat_dsblty_review_requested_dt,
               :OLD.Cat_dsblty_review_initiated_dt,
               :OLD.Cat_dsblty_review_notified_dt  ,
               'D');

  ELSE

    IF UPDATING THEN

      Mdml := 'U';

    ELSE

      Mdml := 'I';

    END IF;

    INSERT
    INTO      ADR.Catastrophic_Disability_H
              (Catastrophic_disability_h_id,
               Catastrophic_disability_id,
               Person_id,
               Cat_dsblty_eval_mthd_type_id,
               Std_institution_id,
               Clinical_approver_name,
               Catastrophically_disabled_ind,
               Cat_dsblty_evaluation_date,
               Decision_date,
               Record_created_by,
               Record_created_date,
               Record_modified_by,
               Record_modified_date,
               Record_modified_count,
               Cat_dsblty_review_requested_dt,
               Cat_dsblty_review_initiated_dt,
               Cat_dsblty_review_notified_dt,
               Transaction_type_code)
    VALUES     (ADR.Catastrophic_disability_h_s.NEXTVAL,
                :NEW.Catastrophic_disability_id,
                :NEW.Person_id,
                :NEW.Cat_dsblty_eval_mthd_type_id,
                :NEW.Std_institution_id,
                :NEW.Clinical_approver_name,
                :NEW.Catastrophically_disabled_ind,
                :NEW.Cat_dsblty_evaluation_date,
                :NEW.Decision_date,
                :NEW.Record_created_by,
                :NEW.Record_created_date,
                :NEW.Record_modified_by,
                :NEW.Record_modified_date,
                :NEW.Record_modified_count,
                :NEW.Cat_dsblty_review_requested_dt,
                :NEW.Cat_dsblty_review_initiated_dt,
                :NEW.Cat_dsblty_review_notified_dt,
                Mdml);

  END IF;

END  Cat_Disability_Audir_Trgr;
/
DROP TRIGGER ADR.CAT_DSBLTY_COND_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_COND_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.CAT_DSBLTY_CONDITION
for each row
declare
       mDML char(1);
begin

    if DELETING then
        insert into CAT_DSBLTY_CONDITION_H
        (
        CAT_DSBLTY_CONDITION_H_ID,
        CAT_DSBLTY_CONDITION_ID,
        CATASTROPHIC_DISABILITY_ID,
        CONDITION_TYPE_ID         ,
        RECORD_CREATED_BY         ,
        RECORD_CREATED_DATE       ,
        RECORD_MODIFIED_BY        ,
        RECORD_MODIFIED_DATE      ,
        RECORD_MODIFIED_COUNT     ,
        PRMNT_DSBLTY_STDYESNO_ID  ,
        DISABILITY_SCORE          ,
        TRANSACTION_TYPE_CODE     ,
        PRMNT_DSBLTY_STDPERM_ID
        )
        values
        (
        CAT_DSBLTY_CONDITION_H_s.nextval,
        :old.CAT_DSBLTY_CONDITION_ID,
        :old.CATASTROPHIC_DISABILITY_ID,
        :old.CONDITION_TYPE_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        :old.PRMNT_DSBLTY_STDYESNO_ID,
        :old.DISABILITY_SCORE,
        'D',
        :old.PRMNT_DSBLTY_STDPERM_ID
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into CAT_DSBLTY_CONDITION_H
        (
        CAT_DSBLTY_CONDITION_H_ID,
        CAT_DSBLTY_CONDITION_ID,
        CATASTROPHIC_DISABILITY_ID,
        CONDITION_TYPE_ID         ,
        RECORD_CREATED_BY         ,
        RECORD_CREATED_DATE       ,
        RECORD_MODIFIED_BY        ,
        RECORD_MODIFIED_DATE      ,
        RECORD_MODIFIED_COUNT     ,
        PRMNT_DSBLTY_STDYESNO_ID  ,
        DISABILITY_SCORE          ,
        TRANSACTION_TYPE_CODE     ,
        PRMNT_DSBLTY_STDPERM_ID
        )
        values
        (
        CAT_DSBLTY_CONDITION_H_s.nextval,
        :new.CAT_DSBLTY_CONDITION_ID,
        :new.CATASTROPHIC_DISABILITY_ID,
        :new.CONDITION_TYPE_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.PRMNT_DSBLTY_STDYESNO_ID,
        :new.DISABILITY_SCORE,
        mDML,
        :new.PRMNT_DSBLTY_STDPERM_ID
        );
    end if;

end  CAT_DSBLTY_COND_audir_trgr;
/
DROP TRIGGER ADR.CAT_DSBLTY_DESC_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_DESC_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.CAT_DSBLTY_DESCRIPTOR
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO ADR.CAT_DSBLTY_DESCRIPTOR_H
        (CAT_DSBLTY_DESCRIPTOR_ID_H,
         CAT_DSBLTY_DESCRIPTOR_ID,
         CATASTROPHIC_DISABILITY_ID,
         DESCRIPTOR_TYPE_ID,
         DETERMINATION_DATE,
         STD_INSTITUTION_ID,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_COUNT,
         RECORD_MODIFIED_DATE,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (CAT_DSBLTY_DESCRIPTOR_H_S.NEXTVAL,
         :OLD.CAT_DSBLTY_DESCRIPTOR_ID,
         :OLD.CATASTROPHIC_DISABILITY_ID,
         :OLD.DESCRIPTOR_TYPE_ID,
         :OLD.DETERMINATION_DATE,
         :OLD.STD_INSTITUTION_ID,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_count,
         :OLD.Record_modified_date,
         SYSDATE,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      INSERT INTO ADR.CAT_DSBLTY_DESCRIPTOR_H
        (CAT_DSBLTY_DESCRIPTOR_ID_H,
         CAT_DSBLTY_DESCRIPTOR_ID,
         CATASTROPHIC_DISABILITY_ID,
         DESCRIPTOR_TYPE_ID,
         DETERMINATION_DATE,
         STD_INSTITUTION_ID,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_COUNT,
         RECORD_MODIFIED_DATE,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (CAT_DSBLTY_DESCRIPTOR_H_S.NEXTVAL,
         :NEW.CAT_DSBLTY_DESCRIPTOR_ID,
         :NEW.CATASTROPHIC_DISABILITY_ID,
         :NEW.DESCRIPTOR_TYPE_ID,
         :NEW.DETERMINATION_DATE,
         :NEW.STD_INSTITUTION_ID,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_count,
         :NEW.Record_modified_date,
         SYSDATE,
         mDML
        );

    END IF;

  END CAT_DSBLTY_DESC_AUDIR_TRGR;
/
DROP TRIGGER ADR.CAT_DSBLTY_DIAG_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_DIAG_audir_trgr
after Update or Delete or Insert
ON ADR.CAT_DSBLTY_DIAGNOSIS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CAT_DSBLTY_DIAGNOSIS_H
		(
		CAT_DSBLTY_DIAGNOSIS_H_ID,
		CAT_DSBLTY_DIAGNOSIS_ID,
		CATASTROPHIC_DISABILITY_ID,
		DIAGNOSIS_TYPE_ID         ,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CAT_DSBLTY_DIAGNOSIS_H_S.nextval,
		:old.CAT_DSBLTY_DIAGNOSIS_ID,
		:old.CATASTROPHIC_DISABILITY_ID,
		:old.DIAGNOSIS_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CAT_DSBLTY_DIAGNOSIS_H
		(
		CAT_DSBLTY_DIAGNOSIS_H_ID,
		CAT_DSBLTY_DIAGNOSIS_ID,
		CATASTROPHIC_DISABILITY_ID,
		DIAGNOSIS_TYPE_ID         ,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CAT_DSBLTY_DIAGNOSIS_H_S.nextval,
		:new.CAT_DSBLTY_DIAGNOSIS_ID,
		:new.CATASTROPHIC_DISABILITY_ID,
		:new.DIAGNOSIS_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;


end  CAT_DSBLTY_DIAG_audir_trgr;
/
DROP TRIGGER ADR.CAT_DSBLTY_PROC_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CAT_DSBLTY_PROC_audir_trgr
after Update or Delete or Insert
ON ADR.CAT_DSBLTY_PROCEDURE
for each row
declare
   	mDML char(1);
begin
	if DELETING then
		insert into CAT_DSBLTY_PROCEDURE_H
		(
		CAT_DSBLTY_PROCEDURE_H_ID,
		CAT_DSBLTY_PROCEDURE_ID  ,
		CATASTROPHIC_DISABILITY_ID,
		PROCEDURE_TYPE_ID        ,
		AFFECTED_EXTREMITY_TYPE_ID,
		RECORD_CREATED_BY        ,
		RECORD_CREATED_DATE      ,
		RECORD_MODIFIED_BY       ,
		RECORD_MODIFIED_DATE     ,
		RECORD_MODIFIED_COUNT    ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CAT_DSBLTY_PROCEDURE_H_s.nextval,
		:old.CAT_DSBLTY_PROCEDURE_ID,
		:old.CATASTROPHIC_DISABILITY_ID,
		:old.PROCEDURE_TYPE_ID,
		:old.AFFECTED_EXTREMITY_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else

		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CAT_DSBLTY_PROCEDURE_H
		(
		CAT_DSBLTY_PROCEDURE_H_ID,
		CAT_DSBLTY_PROCEDURE_ID  ,
		CATASTROPHIC_DISABILITY_ID,
		PROCEDURE_TYPE_ID        ,
		AFFECTED_EXTREMITY_TYPE_ID,
		RECORD_CREATED_BY        ,
		RECORD_CREATED_DATE      ,
		RECORD_MODIFIED_BY       ,
		RECORD_MODIFIED_DATE     ,
		RECORD_MODIFIED_COUNT    ,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CAT_DSBLTY_PROCEDURE_H_s.nextval,
		:new.CAT_DSBLTY_PROCEDURE_ID,
		:new.CATASTROPHIC_DISABILITY_ID,
		:new.PROCEDURE_TYPE_ID,
		:new.AFFECTED_EXTREMITY_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  CAT_DSBLTY_PROC_audir_trgr;
/
DROP TRIGGER ADR.CCNFILETRANS_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CCNFILETRANS_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.CCN_FILETRANSFER
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO CCN_FILETRANSFER_H (CCN_FILETRANSFER_H_ID,
                                      CCN_FILETRANSFER_ID,
                                      TRANSMISSION_TYPE_ID,
                                      VCADMISTATUS_TYPE_ID,
                                      DOC_REF,
                                      FILE_NAME,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      HISTORY_CREATED_DATE,
                                      TRANSACTION_TYPE_CODE)
           VALUES (CCN_FILETRANSFER_H_S.NEXTVAL,
                   :old.CCN_FILETRANSFER_ID,
                   :old.TRANSMISSION_TYPE_ID,
                   :old.VCADMISTATUS_TYPE_ID,
                   :old.DOC_REF,
                   :old.FILE_NAME,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO CCN_FILETRANSFER_H (CCN_FILETRANSFER_H_ID,
                                      CCN_FILETRANSFER_ID,
                                      TRANSMISSION_TYPE_ID,
                                      VCADMISTATUS_TYPE_ID,
                                      DOC_REF,
                                      FILE_NAME,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      HISTORY_CREATED_DATE,
                                      TRANSACTION_TYPE_CODE)
           VALUES (CCN_FILETRANSFER_H_S.NEXTVAL,
                   :new.CCN_FILETRANSFER_ID,
                   :new.TRANSMISSION_TYPE_ID,
                   :new.VCADMISTATUS_TYPE_ID,
                   :new.DOC_REF,
                   :new.FILE_NAME,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   END IF;
END CCNFILETRANS_AUDIR_TRGR;
/
DROP TRIGGER ADR.CCN_CONTRACTOR_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CCN_CONTRACTOR_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.CCN_CONTRACTOR
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO CCN_CONTRACTOR_H (CCN_CONTRACTOR_H_ID,
                                    CCN_CONTRACTOR_ID,
                                    CONTRACTOR_NAME,
                                    ISACTIVE,
                                    START_DATE,
                                    END_DATE,
                                    CCN_CODE,
                                    RECORD_CREATED_BY,
                                    RECORD_CREATED_DATE,
                                    RECORD_MODIFIED_BY,
                                    RECORD_MODIFIED_DATE,
                                    RECORD_MODIFIED_COUNT,
                                    HISTORY_CREATED_DATE,
                                    TRANSACTION_TYPE_CODE)
           VALUES (CCN_CONTRACTOR_H_S.NEXTVAL,
                   :old.CCN_CONTRACTOR_ID,
                   :old.CONTRACTOR_NAME,
                   :old.ISACTIVE,
                   :old.START_DATE,
                   :old.END_DATE,
                   :old.CCN_CODE,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO CCN_CONTRACTOR_H (CCN_CONTRACTOR_H_ID,
                                    CCN_CONTRACTOR_ID,
                                    CONTRACTOR_NAME,
                                    ISACTIVE,
                                    START_DATE,
                                    END_DATE,
                                    CCN_CODE,
                                    RECORD_CREATED_BY,
                                    RECORD_CREATED_DATE,
                                    RECORD_MODIFIED_BY,
                                    RECORD_MODIFIED_DATE,
                                    RECORD_MODIFIED_COUNT,
                                    HISTORY_CREATED_DATE,
                                    TRANSACTION_TYPE_CODE)
           VALUES (CCN_CONTRACTOR_H_S.NEXTVAL,
                   :new.CCN_CONTRACTOR_ID,
                   :new.CONTRACTOR_NAME,
                   :new.ISACTIVE,
                   :new.START_DATE,
                   :new.END_DATE,
                   :new.CCN_CODE,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   END IF;
END CCN_CONTRACTOR_AUDIR_TRGR;
/
DROP TRIGGER ADR.CCN_CONTRA_REGION_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CCN_CONTRA_REGION_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.CCN_CONTRACTOR_REGION
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO CCN_CONTRACTOR_REGION_H (CCN_CONTRACTOR_REGION_H_ID,
                                           CCN_CONTRACTOR_REGION_ID,
                                           CCN_CONTRACTOR_ID,
                                           CCN_REGION_ID,
                                           RECORD_CREATED_BY,
                                           RECORD_CREATED_DATE,
                                           RECORD_MODIFIED_BY,
                                           RECORD_MODIFIED_DATE,
                                           RECORD_MODIFIED_COUNT,
                                           HISTORY_CREATED_DATE,
                                           TRANSACTION_TYPE_CODE)
           VALUES (CCN_CONTRACTOR_REGION_H_S.NEXTVAL,
                   :old.CCN_CONTRACTOR_REGION_ID,
                   :old.CCN_CONTRACTOR_ID,
                   :old.CCN_REGION_ID,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO CCN_CONTRACTOR_REGION_H (CCN_CONTRACTOR_REGION_H_ID,
                                           CCN_CONTRACTOR_REGION_ID,
                                           CCN_CONTRACTOR_ID,
                                           CCN_REGION_ID,
                                           RECORD_CREATED_BY,
                                           RECORD_CREATED_DATE,
                                           RECORD_MODIFIED_BY,
                                           RECORD_MODIFIED_DATE,
                                           RECORD_MODIFIED_COUNT,
                                           HISTORY_CREATED_DATE,
                                           TRANSACTION_TYPE_CODE)
           VALUES (CCN_CONTRACTOR_REGION_H_S.NEXTVAL,
                   :new.CCN_CONTRACTOR_REGION_ID,
                   :new.CCN_CONTRACTOR_ID,
                   :new.CCN_REGION_ID,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   SYSDATE,
                   mDML);
   END IF;
END CCN_CONTRA_REGION_AUDIR_TRGR;
/
DROP TRIGGER ADR.CCN_REGION_STATE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CCN_REGION_STATE_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.CCN_REGION_STATE
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO CCN_REGION_STATE_H (CCN_REGION_STATE_H_ID,
                                      CCN_REGION_STATE_ID,
                                      STATE_NAME,
                                      CCN_REGION_ID,
                                      ISACTIVE,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      HISTORY_CREATED_DATE,
                                      TRANSACTION_TYPE_CODE)
           VALUES (CCN_REGION_STATE_H_S.NEXTVAL,
                   :old.CCN_REGION_STATE_ID,
                   :old.STATE_NAME,
                   :old.CCN_REGION_ID,
                   :old.ISACTIVE,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,

                   SYSDATE,
                   mDML);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO CCN_REGION_STATE_H (CCN_REGION_STATE_H_ID,
                                      CCN_REGION_STATE_ID,
                                      STATE_NAME,
                                      CCN_REGION_ID,
                                      ISACTIVE,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      HISTORY_CREATED_DATE,
                                      TRANSACTION_TYPE_CODE)
           VALUES (CCN_REGION_STATE_H_S.NEXTVAL,
                   :new.CCN_REGION_STATE_ID,
                   :new.STATE_NAME,
                   :new.CCN_REGION_ID,
                   :new.ISACTIVE,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,

                   SYSDATE,
                   mDML);
   END IF;
END CCN_REGION_STATE_AUDIR_TRGR;
/
DROP TRIGGER ADR.CCN_SERVICE_LOG_TRGR;

CREATE OR REPLACE TRIGGER ADR.CCN_SERVICE_LOG_TRGR
   BEFORE UPDATE OR INSERT
   ON ADR.CCN_SERVICE_LOG
   FOR EACH ROW
WHEN (
new.DATE_OF_BIRTH IS NOT NULL and new.DATE_OF_BIRTH_TXT IS NULL
      )
BEGIN
   :new.DATE_OF_BIRTH_TXT := TO_CHAR (:new.DATE_OF_BIRTH, 'YYYYMMDD');
END CCN_SERVICE_LOG_TRGR;
/
DROP TRIGGER ADR.CL_VERIF_METHOD_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CL_VERIF_METHOD_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.CL_VERIFICATION_METHOD
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into CL_VERIFICATION_METHOD_H
        (
         CL_VERIFICATION_METHOD_H_ID,
         CL_VERIFICATION_METHOD_ID,
         SPECIAL_FACTOR_ID,
         CL_VERIFICATION_METHOD_CODE,
         RECORD_CREATED_BY ,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        values
        (
        CL_VERIFICATION_METHOD_H_S.nextval,
         :old.CL_VERIFICATION_METHOD_ID,
         :old.SPECIAL_FACTOR_ID,
         :old.CL_VERIFICATION_METHOD_CODE,
         :old.RECORD_CREATED_BY,
         :old.RECORD_CREATED_DATE,
         :old.RECORD_MODIFIED_BY,
         :old.RECORD_MODIFIED_DATE,
         :old.RECORD_MODIFIED_COUNT,
         sysdate,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;
        insert into CL_VERIFICATION_METHOD_H
        (
         CL_VERIFICATION_METHOD_H_ID,
         CL_VERIFICATION_METHOD_ID,
         SPECIAL_FACTOR_ID,
         CL_VERIFICATION_METHOD_CODE,
         RECORD_CREATED_BY ,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        values
        (
        CL_VERIFICATION_METHOD_H_S.nextval,
         :new.CL_VERIFICATION_METHOD_ID,
         :new.SPECIAL_FACTOR_ID,
         :new.CL_VERIFICATION_METHOD_CODE,
         :new.RECORD_CREATED_BY,
         :new.RECORD_CREATED_DATE,
         :new.RECORD_MODIFIED_BY,
         :new.RECORD_MODIFIED_DATE,
         :new.RECORD_MODIFIED_COUNT,
         sysdate,
        mDML
        );
    end if;

end CL_VERIF_METHOD_AUDIR_TRGR;
/
DROP TRIGGER ADR.COMBAT_EPISODE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.COMBAT_EPISODE_audir_trgr
after Update or Delete or Insert
ON ADR.COMBAT_EPISODE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into COMBAT_EPISODE_H
		(
  		COMBAT_EPISODE_H_ID,
 		COMBAT_EPISODE_ID,
 		PERSON_ID,
 		OEFOIFSOURCE_ID,
 		COMBATPAYTYPE_ID,
 		COMBATLOCATIONTYPE_ID,
 		STD_INSTITUTION_ID,
 		COMBAT_FROM_DATE_TXT,
 		COMBAT_TO_DATE_TXT,
 		RECORD_CREATED_BY,
 		RECORD_CREATED_DATE,
 		RECORD_MODIFIED_BY,
 		RECORD_MODIFIED_DATE,
 		RECORD_MODIFIED_COUNT,
 		TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_EPISODE_H_S.nextval,
 		:OLD.COMBAT_EPISODE_ID,
 		:OLD.PERSON_ID,
 		:OLD.OEFOIFSOURCE_ID,
 		:OLD.COMBATPAYTYPE_ID,
 		:OLD.COMBATLOCATIONTYPE_ID,
 		:OLD.STD_INSTITUTION_ID,
 		:OLD.COMBAT_FROM_DATE_TXT,
 		:OLD.COMBAT_TO_DATE_TXT,
 		:OLD.RECORD_CREATED_BY,
 		:OLD.RECORD_CREATED_DATE,
 		:OLD.RECORD_MODIFIED_BY,
 		:OLD.RECORD_MODIFIED_DATE,
 		:OLD.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into COMBAT_EPISODE_H
		(
  		COMBAT_EPISODE_H_ID,
 		COMBAT_EPISODE_ID,
 		PERSON_ID,
 		OEFOIFSOURCE_ID,
 		COMBATPAYTYPE_ID,
 		COMBATLOCATIONTYPE_ID,
 		STD_INSTITUTION_ID,
 		COMBAT_FROM_DATE_TXT,
 		COMBAT_TO_DATE_TXT,
 		RECORD_CREATED_BY,
 		RECORD_CREATED_DATE,
 		RECORD_MODIFIED_BY,
 		RECORD_MODIFIED_DATE,
 		RECORD_MODIFIED_COUNT,
 		TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_EPISODE_H_S.nextval,
 		:NEW.COMBAT_EPISODE_ID,
 		:NEW.PERSON_ID,
 		:NEW.OEFOIFSOURCE_ID,
 		:NEW.COMBATPAYTYPE_ID,
 		:NEW.COMBATLOCATIONTYPE_ID,
		:NEW.STD_INSTITUTION_ID,
 		:NEW.COMBAT_FROM_DATE_TXT,
 		:NEW.COMBAT_TO_DATE_TXT,
 		:NEW.RECORD_CREATED_BY,
 		:NEW.RECORD_CREATED_DATE,
 		:NEW.RECORD_MODIFIED_BY,
 		:NEW.RECORD_MODIFIED_DATE,
 		:NEW.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end COMBAT_EPISODE_audir_trgr;
/
DROP TRIGGER ADR.COMBAT_PAY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.COMBAT_PAY_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.COMBAT_PAY
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into COMBAT_PAY_H
		(
		 COMBAT_PAY_H_ID
 		,COMBAT_PAY_ID
 		,PERSON_ID
 		,COMBATSERVICESOURCE_ID
 		,COMBATSERVICELOCATION_ID
        ,STD_COMBATPAYTYPE_ID
 		,COMBAT_PAY_START_DATE_TXT
 		,COMBAT_PAY_END_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_PAY_H_S.nextval,
		:old.COMBAT_PAY_ID,
		:old.PERSON_ID ,
 		:old.COMBATSERVICESOURCE_ID,
 		:old.COMBATSERVICELOCATION_ID,
        :old.STD_COMBATPAYTYPE_ID,
 		:old.COMBAT_PAY_START_DATE_TXT,
 		:old.COMBAT_PAY_END_DATE_TXT,
 		:old.RECORD_CREATED_BY,
 		:old.RECORD_CREATED_DATE,
 		:old.RECORD_MODIFIED_BY,
 		:old.RECORD_MODIFIED_DATE,
 		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;
		insert into COMBAT_PAY_H
		(
		 COMBAT_PAY_H_ID
 		,COMBAT_PAY_ID
 		,PERSON_ID
 		,COMBATSERVICESOURCE_ID
 		,COMBATSERVICELOCATION_ID
        ,STD_COMBATPAYTYPE_ID
 		,COMBAT_PAY_START_DATE_TXT
 		,COMBAT_PAY_END_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		COMBAT_PAY_H_S.nextval,
		:new.COMBAT_PAY_ID,
		:new.PERSON_ID ,
 		:new.COMBATSERVICESOURCE_ID,
 		:new.COMBATSERVICELOCATION_ID,
        :new.STD_COMBATPAYTYPE_ID,
 		:new.COMBAT_PAY_START_DATE_TXT,
 		:new.COMBAT_PAY_END_DATE_TXT,
 		:new.RECORD_CREATED_BY,
 		:new.RECORD_CREATED_DATE,
 		:new.RECORD_MODIFIED_BY,
 		:new.RECORD_MODIFIED_DATE,
 		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end COMBAT_PAY_audir_trgr;
/
DROP TRIGGER ADR.COM_LETTER_TEMPLATE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.COM_LETTER_TEMPLATE_AUDIR_TRGR
   AFTER DELETE OR INSERT OR UPDATE
   ON ADR.COM_LETTER_TEMPLATE
   REFERENCING OLD AS OLD NEW AS NEW
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      INSERT INTO COM_LETTER_TEMPLATE_H (COM_LETTER_TEMPLATE_H_ID,
                                         COM_LETTER_TEMPLATE_ID,
                                         COM_LETTER_TYPE_ID,
                                         COM_LETTER_GENERATED_TYPE_ID,
                                         LETTER_TEMPLATE_NAME,
                                         LETTER_TEMPLATE_DESCRIPTION,
                                         LETTER_TEMPLATE_TEXT,
                                         LETTER_TEMPLATE_FORM_NUMBER,
                                         LETTER_TEMPLATE_START_DATE,
                                         LETTER_TEMPLATE_END_DATE,
                                         RECORD_CREATED_BY,
                                         RECORD_CREATED_DATE,
                                         RECORD_MODIFIED_BY,
                                         RECORD_MODIFIED_DATE,
                                         RECORD_MODIFIED_COUNT,
                                         LETTER_UI_CONFIGURABLE_FLAG,
                                         LETTER_EFFECTIVE_DATE,
                                         HISTORY_CREATED_DATE,
                                         TRANSACTION_TYPE_CODE)
           VALUES (COM_LETTER_TEMPLATE_H_S.NEXTVAL,
                   :old.COM_LETTER_TEMPLATE_ID,
                   :old.COM_LETTER_TYPE_ID,
                   :old.COM_LETTER_GENERATED_TYPE_ID,
                   :old.LETTER_TEMPLATE_NAME,
                   :old.LETTER_TEMPLATE_DESCRIPTION,
                   :old.LETTER_TEMPLATE_TEXT,
                   :old.LETTER_TEMPLATE_FORM_NUMBER,
                   :old.LETTER_TEMPLATE_START_DATE,
                   :old.LETTER_TEMPLATE_END_DATE,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   :old.LETTER_UI_CONFIGURABLE_FLAG,
                   :old.LETTER_EFFECTIVE_DATE,
                   SYSDATE,
                   'D');
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO COM_LETTER_TEMPLATE_H (COM_LETTER_TEMPLATE_H_ID,
                                         COM_LETTER_TEMPLATE_ID,
                                         COM_LETTER_TYPE_ID,
                                         COM_LETTER_GENERATED_TYPE_ID,
                                         LETTER_TEMPLATE_NAME,
                                         LETTER_TEMPLATE_DESCRIPTION,
                                         LETTER_TEMPLATE_TEXT,
                                         LETTER_TEMPLATE_FORM_NUMBER,
                                         LETTER_TEMPLATE_START_DATE,
                                         LETTER_TEMPLATE_END_DATE,
                                         RECORD_CREATED_BY,
                                         RECORD_CREATED_DATE,
                                         RECORD_MODIFIED_BY,
                                         RECORD_MODIFIED_DATE,
                                         RECORD_MODIFIED_COUNT,
                                         LETTER_UI_CONFIGURABLE_FLAG,
                                         LETTER_EFFECTIVE_DATE,
                                         HISTORY_CREATED_DATE,
                                         TRANSACTION_TYPE_CODE)
           VALUES (COM_LETTER_TEMPLATE_H_S.NEXTVAL,
                   :new.COM_LETTER_TEMPLATE_ID,
                   :new.COM_LETTER_TYPE_ID,
                   :new.COM_LETTER_GENERATED_TYPE_ID,
                   :new.LETTER_TEMPLATE_NAME,
                   :new.LETTER_TEMPLATE_DESCRIPTION,
                   :new.LETTER_TEMPLATE_TEXT,
                   :new.LETTER_TEMPLATE_FORM_NUMBER,
                   :new.LETTER_TEMPLATE_START_DATE,
                   :new.LETTER_TEMPLATE_END_DATE,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   :new.LETTER_UI_CONFIGURABLE_FLAG,
                   :new.LETTER_EFFECTIVE_DATE,
                   SYSDATE,
                   mDML);
   END IF;
END COM_LETTER_TEMPLATE_AUDIR_TRGR;
/
DROP TRIGGER ADR.CONFLICT_DETAIL_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CONFLICT_DETAIL_audir_trgr
after Update or Delete or Insert
ON ADR.CONFLICT_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CONFLICT_DETAIL_H
		(
		CONFLICT_DETAIL_H_ID ,
		CONFLICT_DETAIL_ID   ,
		MILITARY_SERVICE_ID  ,
		STD_COMBATLOCATION_ID,
		CONFLICT_FROM_DATE_TXT  ,
		CONFLICT_TO_DATE_TXT    ,
		RECORD_CREATED_BY        ,
		RECORD_CREATED_DATE      ,
		RECORD_MODIFIED_BY       ,
		RECORD_MODIFIED_DATE     ,
		RECORD_MODIFIED_COUNT    ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		CONFLICT_DETAIL_H_S.nextval,
		:old.CONFLICT_DETAIL_ID,
		:old.MILITARY_SERVICE_ID,
		:old.STD_COMBATLOCATION_ID,
		:old.CONFLICT_FROM_DATE_TXT,
		:old.CONFLICT_TO_DATE_TXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CONFLICT_DETAIL_H
		(
		CONFLICT_DETAIL_H_ID ,
		CONFLICT_DETAIL_ID   ,
		MILITARY_SERVICE_ID  ,
		STD_COMBATLOCATION_ID,
		CONFLICT_FROM_DATE_TXT  ,
		CONFLICT_TO_DATE_TXT    ,
		RECORD_CREATED_BY        ,
		RECORD_CREATED_DATE      ,
		RECORD_MODIFIED_BY       ,
		RECORD_MODIFIED_DATE     ,
		RECORD_MODIFIED_COUNT    ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		CONFLICT_DETAIL_H_S.nextval,
		:new.CONFLICT_DETAIL_ID,
		:new.MILITARY_SERVICE_ID,
		:new.STD_COMBATLOCATION_ID,
		:new.CONFLICT_FROM_DATE_TXT,
		:new.CONFLICT_TO_DATE_TXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  CONFLICT_DETAIL_audir_trgr;
/
DROP TRIGGER ADR.CONF_ADDR_CATGRY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CONF_ADDR_CATGRY_audir_trgr
after Update or Delete or Insert
ON ADR.CONFIDENTIAL_ADDR_CATGRY
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into CONFIDENTIAL_ADDR_CATGRY_H
		(
		CONFIDENTIAL_ADDR_CATGRY_H_ID,
		CONFIDENTIAL_ADDR_CATGRY_ID  ,
		PERSON_ID                   ,
		CONFIDENTIAL_ADDR_TYPE_ID    ,
		INACTIVE_FLAG                ,
		INACTIVE_DATE                ,
		RECORD_CREATED_BY            ,
		RECORD_CREATED_DATE          ,
		RECORD_MODIFIED_BY           ,
		RECORD_MODIFIED_DATE         ,
		RECORD_MODIFIED_COUNT        ,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CONFIDENTIAL_ADDR_CATGRY_H_S.nextval,
		:old.CONFIDENTIAL_ADDR_CATGRY_ID  ,
		:old.PERSON_ID                   ,
		:old.CONFIDENTIAL_ADDR_TYPE_ID    ,
		:old.INACTIVE_FLAG                ,
		:old.INACTIVE_DATE                ,
		:old.RECORD_CREATED_BY            ,
		:old.RECORD_CREATED_DATE          ,
		:old.RECORD_MODIFIED_BY           ,
		:old.RECORD_MODIFIED_DATE         ,
		:old.RECORD_MODIFIED_COUNT        ,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D'
		);
	else

		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into CONFIDENTIAL_ADDR_CATGRY_H
		(
		CONFIDENTIAL_ADDR_CATGRY_H_ID,
		CONFIDENTIAL_ADDR_CATGRY_ID  ,
		PERSON_ID                   ,
		CONFIDENTIAL_ADDR_TYPE_ID    ,
		INACTIVE_FLAG                ,
		INACTIVE_DATE                ,
		RECORD_CREATED_BY            ,
		RECORD_CREATED_DATE          ,
		RECORD_MODIFIED_BY           ,
		RECORD_MODIFIED_DATE         ,
		RECORD_MODIFIED_COUNT        ,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		CONFIDENTIAL_ADDR_CATGRY_H_S.nextval,
		:new.CONFIDENTIAL_ADDR_CATGRY_ID  ,
		:new.PERSON_ID                   ,
		:new.CONFIDENTIAL_ADDR_TYPE_ID    ,
		:new.INACTIVE_FLAG                ,
		:new.INACTIVE_DATE                ,
		:new.RECORD_CREATED_BY            ,
		:new.RECORD_CREATED_DATE          ,
		:new.RECORD_MODIFIED_BY           ,
		:new.RECORD_MODIFIED_DATE         ,
		:new.RECORD_MODIFIED_COUNT        ,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML
		);
	end if;
end CONF_ADDR_CATGRY_audir_trgr;
/
DROP TRIGGER ADR.CORRESPONDENCE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.CORRESPONDENCE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.CORRESPONDENCE
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO CORRESPONDENCE_H
        (CORRESPONDENCE_H_ID,
         CORRESPONDENCE_ID,
         CORRESPONDENCE_TYPE_ID,
         CORRESPONDENCE_STATUS_ID,
         PERSON_ID ,
         CORRESPONDENCE_STATUS_DATE,
         CORRESPONDENCE_EFFECTIVE_DATE,
         CORRESPONDENCE_DOCUMENT_ID ,
         COM_LETTER_TEMPLATE_ID,
         EMAIL_TEMPLATE_ID ,
         EMAIL_H_ID  ,
         ADDRESS_H_ID,
         ERROR_DESCRIPTION ,
         RECORD_CREATED_BY ,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY ,
         RECORD_MODIFIED_COUNT,
         RECORD_MODIFIED_DATE,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (CORRESPONDENCE_H_S.NEXTVAL,
         :OLD.CORRESPONDENCE_ID,
         :OLD.CORRESPONDENCE_TYPE_ID,
         :OLD.CORRESPONDENCE_STATUS_ID,
         :OLD.PERSON_ID ,
         :OLD.CORRESPONDENCE_STATUS_DATE,
         :OLD.CORRESPONDENCE_EFFECTIVE_DATE,
         :OLD.CORRESPONDENCE_DOCUMENT_ID ,
         :OLD.COM_LETTER_TEMPLATE_ID,
         :OLD.EMAIL_TEMPLATE_ID ,
         :OLD.EMAIL_H_ID  ,
         :OLD.ADDRESS_H_ID,
         :OLD.ERROR_DESCRIPTION ,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_count,
         :OLD.Record_modified_date,
         SYSDATE,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      INSERT INTO CORRESPONDENCE_H
        (CORRESPONDENCE_H_ID,
         CORRESPONDENCE_ID,
         CORRESPONDENCE_TYPE_ID,
         CORRESPONDENCE_STATUS_ID,
         PERSON_ID ,
         CORRESPONDENCE_STATUS_DATE,
         CORRESPONDENCE_EFFECTIVE_DATE,
         CORRESPONDENCE_DOCUMENT_ID ,
         COM_LETTER_TEMPLATE_ID,
         EMAIL_TEMPLATE_ID ,
         EMAIL_H_ID  ,
         ADDRESS_H_ID,
         ERROR_DESCRIPTION ,
         RECORD_CREATED_BY ,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY ,
         RECORD_MODIFIED_COUNT,
         RECORD_MODIFIED_DATE,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (CORRESPONDENCE_H_S.NEXTVAL,
         :NEW.CORRESPONDENCE_ID,
         :NEW.CORRESPONDENCE_TYPE_ID,
         :NEW.CORRESPONDENCE_STATUS_ID,
         :NEW.PERSON_ID ,
         :NEW.CORRESPONDENCE_STATUS_DATE,
         :NEW.CORRESPONDENCE_EFFECTIVE_DATE,
         :NEW.CORRESPONDENCE_DOCUMENT_ID ,
         :NEW.COM_LETTER_TEMPLATE_ID,
         :NEW.EMAIL_TEMPLATE_ID ,
         :NEW.EMAIL_H_ID  ,
         :NEW.ADDRESS_H_ID,
         :NEW.ERROR_DESCRIPTION ,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_count,
         :NEW.Record_modified_date,
         SYSDATE,
         mDML
        );

    END IF;

  END CORRESPONDENCE_AUDIR_TRGR;
/
DROP TRIGGER ADR.DEPLOYMENT_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.DEPLOYMENT_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.DEPLOYMENT
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into DEPLOYMENT_H
        (
        DEPLOYMENT_H_ID,
        DEPLOYMENT_ID,
        ACTIVATION_ID,
        STD_TERMINATIONREASON_ID,
        STD_MHDATASOURCE_ID,
        STD_COUNTRY_ID,
        STD_SPECIALOPERATION_ID,
        DEPLOYMENT_BEGIN_DATE,
        DEPLOYMENT_END_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DEPLOYMENT_H_S.nextval,
        :old.DEPLOYMENT_ID,
        :old.ACTIVATION_ID,
        :old.STD_TERMINATIONREASON_ID,
        :old.STD_MHDATASOURCE_ID,
        :old.STD_COUNTRY_ID,
        :old.STD_SPECIALOPERATION_ID,
        :old.DEPLOYMENT_BEGIN_DATE,
        :old.DEPLOYMENT_END_DATE,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into DEPLOYMENT_H
        (
        DEPLOYMENT_H_ID,
        DEPLOYMENT_ID,
        ACTIVATION_ID,
        STD_TERMINATIONREASON_ID,
        STD_MHDATASOURCE_ID,
        STD_COUNTRY_ID,
        STD_SPECIALOPERATION_ID,
        DEPLOYMENT_BEGIN_DATE,
        DEPLOYMENT_END_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DEPLOYMENT_H_S.nextval,
        :new.DEPLOYMENT_ID,
        :new.ACTIVATION_ID,
        :new.STD_TERMINATIONREASON_ID,
        :new.STD_MHDATASOURCE_ID,
        :new.STD_COUNTRY_ID,
        :new.STD_SPECIALOPERATION_ID,
        :new.DEPLOYMENT_BEGIN_DATE,
        :new.DEPLOYMENT_END_DATE,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end DEPLOYMENT_audir_trgr;
/
DROP TRIGGER ADR.DLVPRFEM_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.DLVPRFEM_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.DELIVERY_PREFERENCE_EMAIL
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into DELIVERY_PREFERENCE_EMAIL_H
        (
        DELIVERY_PREFERENCE_EMAIL_H_ID,
        DELIVERY_PREFERENCE_EMAIL_ID,
DELIVERY_PREFERENCE_ID,
STD_EMAILADDRESSTYPE_ID,
EMAIL_ADDRESS,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DELIVERY_PREFERENCE_EMAIL_H_S.nextval,
        :old.DELIVERY_PREFERENCE_EMAIL_ID,
        :old.DELIVERY_PREFERENCE_ID,
        :old.STD_EMAILADDRESSTYPE_ID,
        :old.EMAIL_ADDRESS,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into DELIVERY_PREFERENCE_EMAIL_H
        (
        DELIVERY_PREFERENCE_EMAIL_H_ID,
        DELIVERY_PREFERENCE_EMAIL_ID,
 	DELIVERY_PREFERENCE_ID,
	STD_EMAILADDRESSTYPE_ID,
EMAIL_ADDRESS,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DELIVERY_PREFERENCE_EMAIL_H_S.nextval,
        :new.DELIVERY_PREFERENCE_EMAIL_ID,
        :new.DELIVERY_PREFERENCE_ID,
        :new.STD_EMAILADDRESSTYPE_ID,
        :new.EMAIL_ADDRESS,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end DLVPRFEM_AUDIR_TRGR;
/
DROP TRIGGER ADR.DLVPRF_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.DLVPRF_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.DELIVERY_PREFERENCE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into DELIVERY_PREFERENCE_H
        (
        DELIVERY_PREFERENCE_H_ID,
        DELIVERY_PREFERENCE_ID,
        PERSON_ID,
        STD_DELIVERYPREFERENCETYPE_ID,
STD_DELIVERYPREFSRCTYPE_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DELIVERY_PREFERENCE_H_S.nextval,
        :old.DELIVERY_PREFERENCE_ID,
        :old.PERSON_ID,
        :old.STD_DELIVERYPREFERENCETYPE_ID,
:old.STD_DELIVERYPREFSRCTYPE_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into DELIVERY_PREFERENCE_H
        (
        DELIVERY_PREFERENCE_H_ID,
        DELIVERY_PREFERENCE_ID,
        PERSON_ID,
        STD_DELIVERYPREFERENCETYPE_ID,
STD_DELIVERYPREFSRCTYPE_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        DELIVERY_PREFERENCE_H_S.nextval,
        :new.DELIVERY_PREFERENCE_ID,
        :new.PERSON_ID,
        :new.STD_DELIVERYPREFERENCETYPE_ID,
:new.STD_DELIVERYPREFSRCTYPE_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end DELIVERY_PREFERENCE_audir_trgr;
/
DROP TRIGGER ADR.EGT_SETTING_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.EGT_SETTING_audir_trgr
after Update or Delete or Insert
ON ADR.EGT_SETTING
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EGT_SETTING_H
		(
		EGT_SETTING_H_ID,
		EGT_SETTING_ID  ,
		EGT_TYPE_ID     ,
		PRIORITY_GROUP_TYPE_ID,
		PRIORITY_SUB_GROUP_TYPE_ID,
		EGT_EFFECTIVE_DATE        ,
		FEDERAL_REGISTRY_DATE     ,
		REMARKS                   ,
		DISABLED_EGT_FLAG         ,
		CURRENT_EGT_FLAG,
		REFERENCE_EGT_SETTING_ID,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
      		)
		values
		(
		EGT_SETTING_H_s.nextval,
		:old.EGT_SETTING_ID,
		:old.EGT_TYPE_ID,
		:old.PRIORITY_GROUP_TYPE_ID,
		:old.PRIORITY_SUB_GROUP_TYPE_ID,
		:old.EGT_EFFECTIVE_DATE,
		:old.FEDERAL_REGISTRY_DATE,
		:old.REMARKS,
		:old.DISABLED_EGT_FLAG,
		:old.CURRENT_EGT_FLAG,
		:old.REFERENCE_EGT_SETTING_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EGT_SETTING_H
		(
		EGT_SETTING_H_ID,
		EGT_SETTING_ID  ,
		EGT_TYPE_ID     ,
		PRIORITY_GROUP_TYPE_ID,
		PRIORITY_SUB_GROUP_TYPE_ID,
		EGT_EFFECTIVE_DATE        ,
		FEDERAL_REGISTRY_DATE     ,
		REMARKS                   ,
		DISABLED_EGT_FLAG         ,
		CURRENT_EGT_FLAG,
		REFERENCE_EGT_SETTING_ID,
		RECORD_CREATED_BY         ,
		RECORD_CREATED_DATE       ,
		RECORD_MODIFIED_BY        ,
		RECORD_MODIFIED_DATE      ,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		EGT_SETTING_H_s.nextval,
		:new.EGT_SETTING_ID,
		:new.EGT_TYPE_ID,
		:new.PRIORITY_GROUP_TYPE_ID,
		:new.PRIORITY_SUB_GROUP_TYPE_ID,
		:new.EGT_EFFECTIVE_DATE,
		:new.FEDERAL_REGISTRY_DATE,
		:new.REMARKS,
		:new.DISABLED_EGT_FLAG,
		:new.CURRENT_EGT_FLAG,
		:new.REFERENCE_EGT_SETTING_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  EGT_SETTING_audir_trgr;
/
DROP TRIGGER ADR.EGT_SITE_STATISTICS_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.EGT_SITE_STATISTICS_audir_trgr
after Update or Delete or Insert
ON ADR.EGT_SITE_STATISTICS
for each row
declare
   	mDML char(1);
begin
	if DELETING then
		insert into EGT_SITE_STATISTICS_H
		(
		EGT_SITE_STATISTICS_H_ID,
		EGT_SITE_STATISTICS_ID,
		EGT_STATISTICS_ID,
		STD_INSTITUTION_ID,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		BENEFICIARY_PROCESSED_COUNT,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      		)
		values
		(
		EGT_SITE_STATISTICS_H_s.nextval,
		:old.EGT_SITE_STATISTICS_ID,
		:old.EGT_STATISTICS_ID,
		:old.STD_INSTITUTION_ID,
		:old.BENEFICIARY_NOT_ENROLLED_COUNT,
		:old.IN_PROCESS_CATGRY_COUNT,
		:old.ENROLLED_CATGRY_COUNT,
		:old.BENEFICIARY_PROCESSED_COUNT,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EGT_SITE_STATISTICS_H
		(
		EGT_SITE_STATISTICS_H_ID,
		EGT_SITE_STATISTICS_ID,
		EGT_STATISTICS_ID,
		STD_INSTITUTION_ID,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		BENEFICIARY_PROCESSED_COUNT,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      		)
		values
		(
		EGT_SITE_STATISTICS_H_s.nextval,
		:new.EGT_SITE_STATISTICS_ID,
		:new.EGT_STATISTICS_ID,
		:new.STD_INSTITUTION_ID,
		:new.BENEFICIARY_NOT_ENROLLED_COUNT,
		:new.IN_PROCESS_CATGRY_COUNT,
		:new.ENROLLED_CATGRY_COUNT,
		:new.BENEFICIARY_PROCESSED_COUNT,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  EGT_SITE_STATISTICS_audir_trgr;
/
DROP TRIGGER ADR.EGT_STATISTICS_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.EGT_STATISTICS_audir_trgr
after Update or Delete or Insert
ON ADR.EGT_STATISTICS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EGT_STATISTICS_H
		(
		EGT_STATISTICS_H_ID,
		EGT_STATISTICS_ID,
		EGT_SETTING_ID,
		PROCESS_START_DATE,
		PROCESS_END_DATE,
		BENEFICIARY_PROCESSED_COUNT,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		PROCESS_NUMBER,
		PROCESS_MESSAGE_DESCRIPTION,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EGT_STATISTICS_H_S.nextval,
		:old.EGT_STATISTICS_ID,
		:old.EGT_SETTING_ID,
		:old.PROCESS_START_DATE,
		:old.PROCESS_END_DATE,
		:old.BENEFICIARY_PROCESSED_COUNT,
		:old.BENEFICIARY_NOT_ENROLLED_COUNT,
		:old.PROCESS_NUMBER,
		:old.PROCESS_MESSAGE_DESCRIPTION,
		:old.IN_PROCESS_CATGRY_COUNT,
		:old.ENROLLED_CATGRY_COUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EGT_STATISTICS_H
		(
		EGT_STATISTICS_H_ID,
		EGT_STATISTICS_ID,
		EGT_SETTING_ID,
		PROCESS_START_DATE,
		PROCESS_END_DATE,
		BENEFICIARY_PROCESSED_COUNT,
		BENEFICIARY_NOT_ENROLLED_COUNT,
		PROCESS_NUMBER,
		PROCESS_MESSAGE_DESCRIPTION,
		IN_PROCESS_CATGRY_COUNT,
		ENROLLED_CATGRY_COUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EGT_STATISTICS_H_S.nextval,
		:new.EGT_STATISTICS_ID,
		:new.EGT_SETTING_ID,
		:new.PROCESS_START_DATE,
		:new.PROCESS_END_DATE,
		:new.BENEFICIARY_PROCESSED_COUNT,
		:new.BENEFICIARY_NOT_ENROLLED_COUNT,
		:new.PROCESS_NUMBER,
		:new.PROCESS_MESSAGE_DESCRIPTION,
		:new.IN_PROCESS_CATGRY_COUNT,
		:new.ENROLLED_CATGRY_COUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end EGT_STATISTICS_audir_trgr;
/
DROP TRIGGER ADR.ELIGIBILITY_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ELIGIBILITY_DET_audir_trgr
after Update or Delete or Insert
ON ADR.ELIGIBILITY_DETERMINATION
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ELIGIBILITY_DETERMINATION_H
		(
		ELIGIBILITY_DETERMINATION_H_ID,
		ELIGIBILITY_DETERMINATION_ID  ,
		ENROLLMENT_DETERMINATION_ID   ,
		ELIGIBILITY_TYPE_ID           ,
		PRIMARY_SECONDARY_OR_OTHER    ,
		STD_ELIGIBILITYFACTOR_ID	  ,
		RECORD_CREATED_BY             ,
		RECORD_CREATED_DATE           ,
		RECORD_MODIFIED_BY            ,
		RECORD_MODIFIED_DATE          ,
		RECORD_MODIFIED_COUNT         ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		ELIGIBILITY_DETERMINATION_H_s.nextval,
		:old.ELIGIBILITY_DETERMINATION_ID,
		:old.ENROLLMENT_DETERMINATION_ID,
		:old.ELIGIBILITY_TYPE_ID,
		:old.PRIMARY_SECONDARY_OR_OTHER,
		:old.STD_ELIGIBILITYFACTOR_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ELIGIBILITY_DETERMINATION_H
		(
		ELIGIBILITY_DETERMINATION_H_ID,
		ELIGIBILITY_DETERMINATION_ID  ,
		ENROLLMENT_DETERMINATION_ID   ,
		ELIGIBILITY_TYPE_ID           ,
		PRIMARY_SECONDARY_OR_OTHER    ,
		STD_ELIGIBILITYFACTOR_ID,
		RECORD_CREATED_BY             ,
		RECORD_CREATED_DATE           ,
		RECORD_MODIFIED_BY            ,
		RECORD_MODIFIED_DATE          ,
		RECORD_MODIFIED_COUNT         ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		ELIGIBILITY_DETERMINATION_H_s.nextval,
		:new.ELIGIBILITY_DETERMINATION_ID,
		:new.ENROLLMENT_DETERMINATION_ID,
		:new.ELIGIBILITY_TYPE_ID,
		:new.PRIMARY_SECONDARY_OR_OTHER,
		:new.STD_ELIGIBILITYFACTOR_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  ELIGIBILITY_DET_audir_trgr;
/
DROP TRIGGER ADR.ELIGIBILITY_VER_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ELIGIBILITY_VER_AUDIR_TRGR
   AFTER UPDATE OR DELETE OR INSERT
   ON ADR.ELIGIBILITY_VERIFICATION
   REFERENCING NEW AS NEW OLD AS OLD
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      INSERT INTO ELIGIBILITY_VERIFICATION_H (ELIGIBILITY_VERIFICATION_H_ID,
                                              ELIGIBILITY_VERIFICATION_ID,
                                              PERSON_ID,
                                              ELGBTY_STATUS_TYPE_ID,
                                              ELGBTY_VRFN_SOURCE_TYPE_ID,
                                              VBA_QUERY_STATUS_TYPE_ID,
                                              STD_INSTITUTION_ID,
                                              VERIFICATION_METHOD_CODE,
                                              ELIGIBILITY_STATUS_DATE_TXT,
                                              VBA_QUERY_STATUS_DATE,
                                              VBA_QUERY_SENT_DATE,
                                              elgbty_Status_reason_id,
                                              elgbty_reason_explanation,
                                              RECORD_CREATED_BY,
                                              RECORD_CREATED_DATE,
                                              RECORD_MODIFIED_BY,
                                              RECORD_MODIFIED_DATE,
                                              RECORD_MODIFIED_COUNT,
                                              TRANSACTION_TYPE_CODE)
           VALUES (ELIGIBILITY_VERIFICATION_H_s.NEXTVAL,
                   :old.ELIGIBILITY_VERIFICATION_ID,
                   :old.PERSON_ID,
                   :old.ELGBTY_STATUS_TYPE_ID,
                   :old.ELGBTY_VRFN_SOURCE_TYPE_ID,
                   :old.VBA_QUERY_STATUS_TYPE_ID,
                   :old.STD_INSTITUTION_ID,
                   :old.VERIFICATION_METHOD_CODE,
                   :old.ELIGIBILITY_STATUS_DATE_TXT,
                   :old.VBA_QUERY_STATUS_DATE,
                   :old.VBA_QUERY_SENT_DATE,
                   :old.elgbty_Status_reason_id,
                   :old.elgbty_reason_explanation,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   'D');
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO ELIGIBILITY_VERIFICATION_H (ELIGIBILITY_VERIFICATION_H_ID,
                                              ELIGIBILITY_VERIFICATION_ID,
                                              PERSON_ID,
                                              ELGBTY_STATUS_TYPE_ID,
                                              ELGBTY_VRFN_SOURCE_TYPE_ID,
                                              VBA_QUERY_STATUS_TYPE_ID,
                                              STD_INSTITUTION_ID,
                                              VERIFICATION_METHOD_CODE,
                                              ELIGIBILITY_STATUS_DATE_TXT,
                                              VBA_QUERY_STATUS_DATE,
                                              VBA_QUERY_SENT_DATE,
                                              elgbty_Status_reason_id,
                                              elgbty_reason_explanation,
                                              RECORD_CREATED_BY,
                                              RECORD_CREATED_DATE,
                                              RECORD_MODIFIED_BY,
                                              RECORD_MODIFIED_DATE,
                                              RECORD_MODIFIED_COUNT,
                                              TRANSACTION_TYPE_CODE)
           VALUES (ELIGIBILITY_VERIFICATION_H_s.NEXTVAL,
                   :new.ELIGIBILITY_VERIFICATION_ID,
                   :new.PERSON_ID,
                   :new.ELGBTY_STATUS_TYPE_ID,
                   :new.ELGBTY_VRFN_SOURCE_TYPE_ID,
                   :new.VBA_QUERY_STATUS_TYPE_ID,
                   :new.STD_INSTITUTION_ID,
                   :new.VERIFICATION_METHOD_CODE,
                   :new.ELIGIBILITY_STATUS_DATE_TXT,
                   :new.VBA_QUERY_STATUS_DATE,
                   :new.VBA_QUERY_SENT_DATE,
                   :new.elgbty_Status_reason_id,
                   :new.elgbty_reason_explanation,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   mDML);
   END IF;
END ELIGIBILITY_VER_audir_trgr;
/
DROP TRIGGER ADR.EMAIL_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.EMAIL_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.EMAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EMAIL_H
		(
		EMAIL_H_ID,
		EMAIL_ID,
		PERSON_ID,
		INSURANCE_ID,
		EMAIL_TYPE_ID,
		EMAIL_ADDRESS,
		CHANGE_EFFECTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		STD_INSTITUTION_ID,
		EMAIL_CHANGE_SOURCE_TYPE_ID,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE,
		SITE_OF_CHANGE_ID
		)
		values
		(
		EMAIL_H_S.nextval,
		:old.EMAIL_ID,
		:old.PERSON_ID,
		:old.INSURANCE_ID,
		:old.EMAIL_TYPE_ID,
		:old.EMAIL_ADDRESS,
		:old.CHANGE_EFFECTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		:old.STD_INSTITUTION_ID,
		:old.EMAIL_CHANGE_SOURCE_TYPE_ID,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D',
		:old.SITE_OF_CHANGE_ID
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EMAIL_H
		(
		EMAIL_H_ID,
		EMAIL_ID,
		PERSON_ID,
		INSURANCE_ID,
		EMAIL_TYPE_ID,
		EMAIL_ADDRESS,
		CHANGE_EFFECTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		STD_INSTITUTION_ID,
		EMAIL_CHANGE_SOURCE_TYPE_ID,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE,
		SITE_OF_CHANGE_ID
		)
		values
		(
		EMAIL_H_S.nextval,
		:new.EMAIL_ID,
		:new.PERSON_ID,
		:new.INSURANCE_ID,
		:new.EMAIL_TYPE_ID,
		:new.EMAIL_ADDRESS,
		:new.CHANGE_EFFECTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		:new.STD_INSTITUTION_ID,
		:new.EMAIL_CHANGE_SOURCE_TYPE_ID,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML,
		:new.SITE_OF_CHANGE_ID
		);
	end if;

end EMAIL_audir_trgr;
/
DROP TRIGGER ADR.EMERG_RESPONSE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.EMERG_RESPONSE_AUDIR_TRGR
after Update or Delete or Insert
on ADR.EMERGENCY_RESPONSE
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into EMERGENCY_RESPONSE_H
		(
		EMERGENCY_RESPONSE_H_ID,
 		EMERGENCY_RESPONSE_ID,
		PERSON_ID,
		STD_EMERGENCYRESPONSE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EMERGENCY_RESPONSE_H_S.nextval,
 		:old.EMERGENCY_RESPONSE_ID,
		:old.PERSON_ID,
		:old.STD_EMERGENCYRESPONSE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into EMERGENCY_RESPONSE_H
		(
		EMERGENCY_RESPONSE_H_ID,
 		EMERGENCY_RESPONSE_ID,
		PERSON_ID,
		STD_EMERGENCYRESPONSE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		EMERGENCY_RESPONSE_H_S.nextval,
 		:new.EMERGENCY_RESPONSE_ID,
		:new.PERSON_ID,
		:new.STD_EMERGENCYRESPONSE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end emerg_response_audir_trgr;
/
DROP TRIGGER ADR.EMPLOYMENT_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.EMPLOYMENT_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."EMPLOYMENT" FOR EACH ROW
declare
    mDML char(1);
begin

  if DELETING then
    insert into EMPLOYMENT_H
    (
    EMPLOYMENT_H_ID,
    EMPLOYMENT_ID,
    PERSON_ID,
    PERSON_RELATION_ID,
    STD_EMPLOYMENTSTATUS_ID,
    EMPLOYEE_OCCUPATION,
    EMPLOYER_FULL_NAME,
    PHONE_NUMBER,
    ADDRESS_LINE1,
    ADDRESS_LINE2,
    ADDRESS_LINE3,
    CITY,
    STATE_CODE,
    COUNTY_CODE,
    PROVINCE_CODE,
    ZIP_CODE,
    ZIP_PLUS_4,
    POSTAL_CODE,
    COUNTRY_CODE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    EMPLOYEE_RETIREMENT_DATE_TXT,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    EMPLOYMENT_h_s.nextval,
    :old.EMPLOYMENT_ID ,
    :old.PERSON_ID,
    :old.PERSON_RELATION_ID,
    :old.STD_EMPLOYMENTSTATUS_ID,
    :old.EMPLOYEE_OCCUPATION,
    :old.EMPLOYER_FULL_NAME,
    :old.PHONE_NUMBER,
    :old.ADDRESS_LINE1,
    :old.ADDRESS_LINE2,
    :old.ADDRESS_LINE3,
    :old.CITY,
    :old.STATE_CODE,
    :old.COUNTY_CODE,
    :old.PROVINCE_CODE,
    :old.ZIP_CODE,
    :old.ZIP_PLUS_4,
    :old.POSTAL_CODE,
    :old.COUNTRY_CODE,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY ,
    :old.RECORD_MODIFIED_DATE,
    :old.RECORD_MODIFIED_COUNT,
    :old.EMPLOYEE_RETIREMENT_DATE_TXT,
    'D'
    );


  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;
    insert into EMPLOYMENT_H
    (
    EMPLOYMENT_H_ID,
    EMPLOYMENT_ID,
    PERSON_ID,
    PERSON_RELATION_ID,
    STD_EMPLOYMENTSTATUS_ID,
    EMPLOYEE_OCCUPATION,
    EMPLOYER_FULL_NAME,
    PHONE_NUMBER,
    ADDRESS_LINE1,
    ADDRESS_LINE2,
    ADDRESS_LINE3,
    CITY,
    STATE_CODE,
    COUNTY_CODE,
    PROVINCE_CODE,
    ZIP_CODE,
    ZIP_PLUS_4,
    POSTAL_CODE,
    COUNTRY_CODE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    EMPLOYEE_RETIREMENT_DATE_TXT,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    EMPLOYMENT_h_s.nextval,
    :new.EMPLOYMENT_ID ,
    :new.PERSON_ID,
    :new.PERSON_RELATION_ID,
    :new.STD_EMPLOYMENTSTATUS_ID,
    :new.EMPLOYEE_OCCUPATION,
    :new.EMPLOYER_FULL_NAME,
    :new.PHONE_NUMBER,
    :new.ADDRESS_LINE1,
    :new.ADDRESS_LINE2,
    :new.ADDRESS_LINE3,
    :new.CITY,
    :new.STATE_CODE,
    :new.COUNTY_CODE,
    :new.PROVINCE_CODE,
    :new.ZIP_CODE,
    :new.ZIP_PLUS_4,
    :new.POSTAL_CODE,
    :new.COUNTRY_CODE,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY ,
    :new.RECORD_MODIFIED_DATE,
    :new.RECORD_MODIFIED_COUNT,
    :new.EMPLOYEE_RETIREMENT_DATE_TXT,
    mDML
    );



  end if;

end EMPLOYMENT_audir_trgr;
/
DROP TRIGGER ADR.ENROLLMENT_DETER_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ENROLLMENT_DETER_AUDIR_TRGR
    AFTER UPDATE OR DELETE OR INSERT
    ON ADR.ENROLLMENT_DETERMINATION
    FOR EACH ROW
DECLARE
    Mdml   CHAR (1);
BEGIN
    IF DELETING
    THEN
        INSERT INTO ADR.Enrollment_Determination_H (Enrollment_determination_h_id,
                                                    Enrollment_determination_id,
                                                    Person_id,
                                                    Std_enrollmentstatus_id,
                                                    Enrollment_data_src_type_id,
                                                    Priority_group_type_id,
                                                    Priority_sub_group_type_id,
                                                    Application_site_id,
                                                    Egt_setting_id,
                                                    Enrollment_application_date,
                                                    Enrollment_start_date,
                                                    Enrollment_end_date,
                                                    Change_effective_date,
                                                    Enrollment_overridden_flag,
                                                    Record_created_by,
                                                    Record_created_date,
                                                    Record_modified_by,
                                                    Record_modified_date,
                                                    Record_modified_count,
                                                    Transaction_type_code,
                                                    Std_enrollmentpriorgrp_id,
                                                    Std_enrollmentpriorsgrp_id,
                                                    CLOSE_APL_RSN_TYPE_ID,
                                                         CLOSE_APP_REMARKS
)
             VALUES (ADR.Enrollment_determination_h_s.NEXTVAL,
                     :OLD.Enrollment_determination_id,
                     :OLD.Person_id,
                     :OLD.Std_enrollmentstatus_id,
                     :OLD.Enrollment_data_src_type_id,
                     :OLD.Priority_group_type_id,
                     :OLD.Priority_sub_group_type_id,
                     :OLD.Application_site_id,
                     :OLD.Egt_setting_id,
                     :OLD.Enrollment_application_date,
                     :OLD.Enrollment_start_date,
                     :OLD.Enrollment_end_date,
                     :OLD.Change_effective_date,
                     :OLD.Enrollment_overridden_flag,
                     :OLD.Record_created_by,
                     :OLD.Record_created_date,
                     :OLD.Record_modified_by,
                     :OLD.Record_modified_date,
                     :OLD.Record_modified_count,
                     'D',
                     :OLD.Std_enrollmentpriorgrp_id,
                     :OLD.Std_enrollmentpriorsgrp_id,
                     :OLD.CLOSE_APL_RSN_TYPE_ID,
                     :OLD.CLOSE_APP_REMARKS);
    ELSE
        IF UPDATING
        THEN
            Mdml := 'U';
        ELSE
            Mdml := 'I';
        END IF;

        INSERT INTO ADR.Enrollment_Determination_H (Enrollment_determination_h_id,
                                                    Enrollment_determination_id,
                                                    Person_id,
                                                    Std_enrollmentstatus_id,
                                                    Enrollment_data_src_type_id,
                                                    Priority_group_type_id,
                                                    Priority_sub_group_type_id,
                                                    Application_site_id,
                                                    Egt_setting_id,
                                                    Enrollment_application_date,
                                                    Enrollment_start_date,
                                                    Enrollment_end_date,
                                                    Change_effective_date,
                                                    Enrollment_overridden_flag,
                                                    Record_created_by,
                                                    Record_created_date,
                                                    Record_modified_by,
                                                    Record_modified_date,
                                                    Record_modified_count,
                                                    Transaction_type_code,
                                                    Std_enrollmentpriorgrp_id,
                                                    Std_enrollmentpriorsgrp_id,
                                                    CLOSE_APL_RSN_TYPE_ID,
                                                         CLOSE_APP_REMARKS)
             VALUES (ADR.Enrollment_determination_h_s.NEXTVAL,
                     :NEW.Enrollment_determination_id,
                     :NEW.Person_id,
                     :NEW.Std_enrollmentstatus_id,
                     :NEW.Enrollment_data_src_type_id,
                     :NEW.Priority_group_type_id,
                     :NEW.Priority_sub_group_type_id,
                     :NEW.Application_site_id,
                     :NEW.Egt_setting_id,
                     :NEW.Enrollment_application_date,
                     :NEW.Enrollment_start_date,
                     :NEW.Enrollment_end_date,
                     :NEW.Change_effective_date,
                     :NEW.Enrollment_overridden_flag,
                     :NEW.Record_created_by,
                     :NEW.Record_created_date,
                     :NEW.Record_modified_by,
                     :NEW.Record_modified_date,
                     :NEW.Record_modified_count,
                     Mdml,
                     :NEW.Std_enrollmentpriorgrp_id,
                     :NEW.Std_enrollmentpriorsgrp_id,
                     :NEW.CLOSE_APL_RSN_TYPE_ID,
                     :NEW.CLOSE_APP_REMARKS);
    END IF;
END ENROLLMENT_DETER_AUDIR_TRGR;
/
DROP TRIGGER ADR.ENROLLMENT_OVER_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ENROLLMENT_OVER_AUDIR_TRGR
after Update or Delete or Insert
on ADR.ENROLLMENT_OVERRIDE
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ENROLLMENT_OVERRIDE_H
		(
		ENROLLMENT_OVERRIDE_H_ID,
		ENROLLMENT_OVERRIDE_ID,
		PERSON_ID,
		OVERRIDE_FLAG,
		OVERRIDE_DATE,
		STD_ENROLLMENTOVERRIDERSN_ID,
		REMARKS,
		OVERRIDE_CREATED_USER,
		OVERRIDE_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		ENROLLMENT_OVERRIDE_H_S.nextval,
		:old.ENROLLMENT_OVERRIDE_ID,
		:old.PERSON_ID,
		:old.OVERRIDE_FLAG,
		:old.OVERRIDE_DATE,
		:old.STD_ENROLLMENTOVERRIDERSN_ID,
		:old.REMARKS,
		:old.OVERRIDE_CREATED_USER,
		:old.OVERRIDE_CREATED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ENROLLMENT_OVERRIDE_H
		(
		ENROLLMENT_OVERRIDE_H_ID,
		ENROLLMENT_OVERRIDE_ID,
		PERSON_ID,
		OVERRIDE_FLAG,
		OVERRIDE_DATE,
		STD_ENROLLMENTOVERRIDERSN_ID,
		REMARKS,
		OVERRIDE_CREATED_USER,
		OVERRIDE_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		ENROLLMENT_OVERRIDE_H_S.nextval,
		:new.ENROLLMENT_OVERRIDE_ID,
		:new.PERSON_ID,
		:new.OVERRIDE_FLAG,
		:new.OVERRIDE_DATE,
		:new.STD_ENROLLMENTOVERRIDERSN_ID,
		:new.REMARKS,
		:new.OVERRIDE_CREATED_USER,
		:new.OVERRIDE_CREATED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  ENROLLMENT_OVER_audir_trgr;
/
DROP TRIGGER ADR.FEE_BASIS_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.FEE_BASIS_audir_trgr
after Update or Delete or Insert
ON ADR.FEE_BASIS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into FEE_BASIS_H
		(
		FEE_BASIS_H_ID,
		FEE_BASIS_ID,
		PERSON_ID,
		FEE_BASIS_PROGRAM_TYPE_ID,
		FEE_BASIS_TREATMENT_TYPE_ID,
		STD_INSTITUTION_ID,
		AUTHORIZATION_FROM_DATE,
		AUTHORIZATION_TO_DATE,
		FEE_BASIS_REPORT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FEE_BASIS_H_S.nextval,
		:old.FEE_BASIS_ID,
		:old.PERSON_ID,
		:old.FEE_BASIS_PROGRAM_TYPE_ID,
		:old.FEE_BASIS_TREATMENT_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.AUTHORIZATION_FROM_DATE,
		:old.AUTHORIZATION_TO_DATE,
		:old.FEE_BASIS_REPORT_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FEE_BASIS_H
		(
		FEE_BASIS_H_ID,
		FEE_BASIS_ID,
		PERSON_ID,
		FEE_BASIS_PROGRAM_TYPE_ID,
		FEE_BASIS_TREATMENT_TYPE_ID,
		STD_INSTITUTION_ID,
		AUTHORIZATION_FROM_DATE,
		AUTHORIZATION_TO_DATE,
		FEE_BASIS_REPORT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FEE_BASIS_H_S.nextval,
		:new.FEE_BASIS_ID,
		:new.PERSON_ID,
		:new.FEE_BASIS_PROGRAM_TYPE_ID,
		:new.FEE_BASIS_TREATMENT_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.AUTHORIZATION_FROM_DATE,
		:new.AUTHORIZATION_TO_DATE,
		:new.FEE_BASIS_REPORT_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  FEE_BASIS_audir_trgr;
/
DROP TRIGGER ADR.FINAN_ASSET_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.FINAN_ASSET_DET_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."FINANCIAL_ASSET_DETAIL" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into FINANCIAL_ASSET_DETAIL_H
		(
		FINANCIAL_ASSET_DETAIL_H_ID,
		FINANCIAL_ASSET_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_ASSET_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_ASSET_DETAIL_H_S.nextval,
		:old.FINANCIAL_ASSET_DETAIL_ID,
		:old.FINANCIAL_STATEMENT_ID,
		:old.FINANCIAL_ASSET_TYPE_ID,
		:old.GROSS_AMOUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FINANCIAL_ASSET_DETAIL_H
		(
		FINANCIAL_ASSET_DETAIL_H_ID,
		FINANCIAL_ASSET_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_ASSET_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_ASSET_DETAIL_H_S.nextval,
		:new.FINANCIAL_ASSET_DETAIL_ID,
		:new.FINANCIAL_STATEMENT_ID,
		:new.FINANCIAL_ASSET_TYPE_ID,
		:new.GROSS_AMOUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  FINAN_ASSET_DET_audir_trgr;
/
DROP TRIGGER ADR.FINAN_DEBT_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.FINAN_DEBT_DET_AUDIR_TRGR
after Update or Delete or Insert
on ADR.FINANCIAL_DEBT_DETAIL
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
	d_prsnid	number	:= 0;
begin

	if DELETING then
		insert into FINANCIAL_DEBT_DETAIL_H
		(
		FINANCIAL_DEBT_DETAIL_H_ID,
		FINANCIAL_DEBT_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_DEBT_DETAIL_H_S.nextval,
		:old.FINANCIAL_DEBT_DETAIL_ID,
		:old.FINANCIAL_STATEMENT_ID,
		:old.GROSS_AMOUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
		select
			fs.person_id
		into
			d_prsnid
	  	from
			ADR.FINANCIAL_STATEMENT fs
	 	where 	financial_statement_id = :OLD.financial_statement_id;

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FINANCIAL_DEBT_DETAIL_H
		(
		FINANCIAL_DEBT_DETAIL_H_ID,
		FINANCIAL_DEBT_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_DEBT_DETAIL_H_S.nextval,
		:new.FINANCIAL_DEBT_DETAIL_ID,
		:new.FINANCIAL_STATEMENT_ID,
		:new.GROSS_AMOUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
		select
			fs.person_id
		into
			d_prsnid
	  	from
			ADR.FINANCIAL_STATEMENT fs
	 	where 	financial_statement_id = :NEW.financial_statement_id;

	end if;

end  FINAN_DEBT_DET_audir_trgr;
/
DROP TRIGGER ADR.FINAN_EXP_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.FINAN_EXP_DET_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."FINANCIAL_EXPENSE_DETAIL" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into FINANCIAL_EXPENSE_DETAIL_H
		(
		FINANCIAL_EXPENSE_DETAIL_H_ID,
		FINANCIAL_EXPENSE_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_EXPENSE_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_EXPENSE_DETAIL_H_S.nextval,
		:old.FINANCIAL_EXPENSE_DETAIL_ID,
		:old.FINANCIAL_STATEMENT_ID,
		:old.FINANCIAL_EXPENSE_TYPE_ID,
		:old.GROSS_AMOUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FINANCIAL_EXPENSE_DETAIL_H
		(
		FINANCIAL_EXPENSE_DETAIL_H_ID,
		FINANCIAL_EXPENSE_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_EXPENSE_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_EXPENSE_DETAIL_H_S.nextval,
		:new.FINANCIAL_EXPENSE_DETAIL_ID,
		:new.FINANCIAL_STATEMENT_ID,
		:new.FINANCIAL_EXPENSE_TYPE_ID,
		:new.GROSS_AMOUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  FINAN_EXP_DET_audir_trgr;
/
DROP TRIGGER ADR.FINAN_INC_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.FINAN_INC_DET_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."FINANCIAL_INCOME_DETAIL" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into FINANCIAL_INCOME_DETAIL_H
		(
		FINANCIAL_INCOME_DETAIL_H_ID,
		FINANCIAL_INCOME_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_INCOME_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_INCOME_DETAIL_H_S.nextval,
		:old.FINANCIAL_INCOME_DETAIL_ID,
		:old.FINANCIAL_STATEMENT_ID,
		:old.FINANCIAL_INCOME_TYPE_ID,
		:old.GROSS_AMOUNT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into FINANCIAL_INCOME_DETAIL_H
		(
		FINANCIAL_INCOME_DETAIL_H_ID,
		FINANCIAL_INCOME_DETAIL_ID,
		FINANCIAL_STATEMENT_ID,
		FINANCIAL_INCOME_TYPE_ID,
		GROSS_AMOUNT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		FINANCIAL_INCOME_DETAIL_H_S.nextval,
		:new.FINANCIAL_INCOME_DETAIL_ID,
		:new.FINANCIAL_STATEMENT_ID,
		:new.FINANCIAL_INCOME_TYPE_ID,
		:new.GROSS_AMOUNT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  FINAN_INC_DET_audir_trgr;
/
DROP TRIGGER ADR.FINAN_STATEMENT_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.FINAN_STATEMENT_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."FINANCIAL_STATEMENT" FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into FINANCIAL_STATEMENT_H
        (
        FINANCIAL_STATEMENT_H_ID,
        FINANCIAL_STATEMENT_ID,
        PERSON_ID,
        PERSON_RELATION_ID,
        REF_FINANCIAL_STATEMENT_ID,
        INCOME_YEAR,
        FIN_STMT_MAPPING_TYPE_CODE,
        CONTRIBUTION_TO_SPOUSE_AMT,
        CONTRIBUTION_TO_DEPENDENT_AMT,
        DISCLOSED_FINANCIAL_INFO_IND,
        SPOUSE_HAS_INCOME_IND,
        MARRIED_CURR_CALENDAR_YEAR_IND,
        MARRIED_PREV_CALENDAR_YEAR_IND,
        DEPENDENT_INCOME_AVAILABLE_IND,
        DEPENDENT_HAS_INCOME_IND,
        DEPENDENT_IN_SCHOOL_IND,
        LIVED_WITH_VETERAN_IND,
        IS_INCAPABLE_SELF_SUPPORT_IND,
        DEPENDENT_CHILDREN_COUNT,
        CHILD_SUPPORT_IND,
        VERIFIED_DATE,
        REMARKS,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        VALID_DEPENDENT_IND,
        POST_2005_DISPLAY_FORMAT_FLAG,
        TRANSACTION_TYPE_CODE,
        CONTRIBUTED_TO_SPOUSE_IND
          )
        values
        (
        FINANCIAL_STATEMENT_H_S.nextval,
        :old.FINANCIAL_STATEMENT_ID,
        :old.PERSON_ID,
        :old.PERSON_RELATION_ID,
        :old.REF_FINANCIAL_STATEMENT_ID,
        :old.INCOME_YEAR,
        :old.FIN_STMT_MAPPING_TYPE_CODE,
        :old.CONTRIBUTION_TO_SPOUSE_AMT,
        :old.CONTRIBUTION_TO_DEPENDENT_AMT,
        :old.DISCLOSED_FINANCIAL_INFO_IND,
        :old.SPOUSE_HAS_INCOME_IND,
        :old.MARRIED_CURR_CALENDAR_YEAR_IND,
        :old.MARRIED_PREV_CALENDAR_YEAR_IND,
        :old.DEPENDENT_INCOME_AVAILABLE_IND,
        :old.DEPENDENT_HAS_INCOME_IND,
        :old.DEPENDENT_IN_SCHOOL_IND,
        :old.LIVED_WITH_VETERAN_IND,
        :old.IS_INCAPABLE_SELF_SUPPORT_IND,
        :old.DEPENDENT_CHILDREN_COUNT,
        :old.CHILD_SUPPORT_IND,
        :old.VERIFIED_DATE,
        :old.REMARKS,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        :old.VALID_DEPENDENT_IND,
        :old.POST_2005_DISPLAY_FORMAT_FLAG,
        'D',
        :old.CONTRIBUTED_TO_SPOUSE_IND
        );

    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into FINANCIAL_STATEMENT_H
        (
        FINANCIAL_STATEMENT_H_ID,
        FINANCIAL_STATEMENT_ID,
        PERSON_ID,
        PERSON_RELATION_ID,
        REF_FINANCIAL_STATEMENT_ID,
        INCOME_YEAR,
        FIN_STMT_MAPPING_TYPE_CODE,
        CONTRIBUTION_TO_SPOUSE_AMT,
        CONTRIBUTION_TO_DEPENDENT_AMT,
        DISCLOSED_FINANCIAL_INFO_IND,
        SPOUSE_HAS_INCOME_IND,
        MARRIED_CURR_CALENDAR_YEAR_IND,
        MARRIED_PREV_CALENDAR_YEAR_IND,
        DEPENDENT_INCOME_AVAILABLE_IND,
        DEPENDENT_HAS_INCOME_IND,
        DEPENDENT_IN_SCHOOL_IND,
        LIVED_WITH_VETERAN_IND,
        IS_INCAPABLE_SELF_SUPPORT_IND,
        DEPENDENT_CHILDREN_COUNT,
        CHILD_SUPPORT_IND,
        VERIFIED_DATE,
        REMARKS,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        VALID_DEPENDENT_IND,
        POST_2005_DISPLAY_FORMAT_FLAG,
        TRANSACTION_TYPE_CODE,
        CONTRIBUTED_TO_SPOUSE_IND
          )
        values
        (
        FINANCIAL_STATEMENT_H_S.nextval,
        :new.FINANCIAL_STATEMENT_ID,
        :new.PERSON_ID,
        :new.PERSON_RELATION_ID,
        :new.REF_FINANCIAL_STATEMENT_ID,
        :new.INCOME_YEAR,
        :new.FIN_STMT_MAPPING_TYPE_CODE,
        :new.CONTRIBUTION_TO_SPOUSE_AMT,
        :new.CONTRIBUTION_TO_DEPENDENT_AMT,
        :new.DISCLOSED_FINANCIAL_INFO_IND,
        :new.SPOUSE_HAS_INCOME_IND,
        :new.MARRIED_CURR_CALENDAR_YEAR_IND,
        :new.MARRIED_PREV_CALENDAR_YEAR_IND,
        :new.DEPENDENT_INCOME_AVAILABLE_IND,
        :new.DEPENDENT_HAS_INCOME_IND,
        :new.DEPENDENT_IN_SCHOOL_IND,
        :new.LIVED_WITH_VETERAN_IND,
        :new.IS_INCAPABLE_SELF_SUPPORT_IND,
        :new.DEPENDENT_CHILDREN_COUNT,
        :new.CHILD_SUPPORT_IND,
        :new.VERIFIED_DATE,
        :new.REMARKS,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.VALID_DEPENDENT_IND,
        :new.POST_2005_DISPLAY_FORMAT_FLAG,
        mDML,
        :new.CONTRIBUTED_TO_SPOUSE_IND
        );

    end if;

end  FINAN_STATEMENT_audir_trgr;
/
DROP TRIGGER ADR.GEOCODE_STATION_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.GEOCODE_STATION_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.GEOCODE_STATION
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO GEOCODE_STATION_H (
         GEOCODE_STATION_H_ID  ,
         GEOCODE_STATION_ID,
         STD_INSTITUTION_ID,
         STATION_NUMBER,
         STATION_ADRR_LINE1,
         STATION_ADRR_LINE2,
         STATION_ADRR_LINE3 ,
         STATION_ADRR_LINE4,
         STATION_CITY ,
         STATION_STATE ,
         STATION_ZIP ,
         STATION_ZIP4,
         VA_SITE_IND ,
         CONTRACTED_IND ,
         NUMBER_OF_PROVIDERS,
         PARENT_STATION,
         PARENT_STA_COMPLEXITY,
         PLANNED_OR_OPERATIONAL,
         STATION_PHONE,
         STATION_FAX,
         SHARED_IND,
         SHARED_PARENT_STATION,
         HEALTHCARE_CENTER,
         MSCBOC,
         NEW_VAMC,
         PCCBOC,
         COC_CLASSIFICATION_CODE ,
         VA_HOSPITAL,
         VHA_SITE_CATEGORY_CODE,
         SITE_CLASSIFICATION_NAME,
         PRIMARY_SVC_TYPE ,
         OP_COC_CLASSIFICATION,
         STATION_LONGITUDE,
         STATION_LATITUDE,
         STATION_NEW_VISN,
         STATION_MARKET,
         STATION_SUBMARKET,
         STATION_COUNTYNAME,
         STATION_DISTRICT,
         STATION_DISTRICT_NAME,
         STATION_URH_CODE,
         STATION_OPERATION_DATE,
         VAST_EXTRACT_DATE ,
         ACTIVE_START_DT,
         ACTIVE_END_DT,
         ACTIVE_FAG,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         STATION_NAME ,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE,
         STATION_LAT,
         STATION_LONG
         )
 VALUES (GEOCODE_TRANSMIT_H_S.NEXTVAL,
       :old.GEOCODE_STATION_ID,
       :old.STD_INSTITUTION_ID,
       :old.STATION_NUMBER,
       :old.STATION_ADRR_LINE1,
       :old.STATION_ADRR_LINE2,
       :old.STATION_ADRR_LINE3 ,
       :old.STATION_ADRR_LINE4,
       :old.STATION_CITY ,
       :old.STATION_STATE ,
       :old.STATION_ZIP ,
       :old.STATION_ZIP4,
       :old.VA_SITE_IND ,
       :old.CONTRACTED_IND ,
       :old.NUMBER_OF_PROVIDERS,
       :old.PARENT_STATION,
       :old.PARENT_STA_COMPLEXITY,
       :old.PLANNED_OR_OPERATIONAL,
       :old.STATION_PHONE,
       :old.STATION_FAX,
       :old.SHARED_IND,
       :old.SHARED_PARENT_STATION,
       :old.HEALTHCARE_CENTER,
       :old.MSCBOC,
       :old.NEW_VAMC,
       :old.PCCBOC,
       :old.COC_CLASSIFICATION_CODE ,
       :old.VA_HOSPITAL,
       :old.VHA_SITE_CATEGORY_CODE,
       :old.SITE_CLASSIFICATION_NAME,
       :old.PRIMARY_SVC_TYPE ,
       :old.OP_COC_CLASSIFICATION,
       :old.STATION_LONGITUDE,
       :old.STATION_LATITUDE,
       :old.STATION_NEW_VISN,
       :old.STATION_MARKET,
       :old.STATION_SUBMARKET,
       :old.STATION_COUNTYNAME,
       :old.STATION_DISTRICT,
       :old.STATION_DISTRICT_NAME,
       :old.STATION_URH_CODE,
       :old.STATION_OPERATION_DATE,
       :old.VAST_EXTRACT_DATE ,
       :old.ACTIVE_START_DT,
       :old.ACTIVE_END_DT,
       :old.ACTIVE_FAG,
       :old.RECORD_CREATED_BY,
       :old.RECORD_CREATED_DATE,
       :old.RECORD_MODIFIED_BY,
       :old.RECORD_MODIFIED_DATE,
       :old.RECORD_MODIFIED_COUNT,
       :old.STATION_NAME ,
       sysdate,
       mDML,
       :old.STATION_LAT,
       :old.STATION_LONG);
ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

       INSERT INTO GEOCODE_STATION_H (
         GEOCODE_STATION_H_ID  ,
         GEOCODE_STATION_ID,
         STD_INSTITUTION_ID,
         STATION_NUMBER,
         STATION_ADRR_LINE1,
         STATION_ADRR_LINE2,
         STATION_ADRR_LINE3 ,
         STATION_ADRR_LINE4,
         STATION_CITY ,
         STATION_STATE ,
         STATION_ZIP ,
         STATION_ZIP4,
         VA_SITE_IND ,
         CONTRACTED_IND ,
         NUMBER_OF_PROVIDERS,
         PARENT_STATION,
         PARENT_STA_COMPLEXITY,
         PLANNED_OR_OPERATIONAL,
         STATION_PHONE,
         STATION_FAX,
         SHARED_IND,
         SHARED_PARENT_STATION,
         HEALTHCARE_CENTER,
         MSCBOC,
         NEW_VAMC,
         PCCBOC,
         COC_CLASSIFICATION_CODE ,
         VA_HOSPITAL,
         VHA_SITE_CATEGORY_CODE,
         SITE_CLASSIFICATION_NAME,
         PRIMARY_SVC_TYPE ,
         OP_COC_CLASSIFICATION,
         STATION_LONGITUDE,
         STATION_LATITUDE,
         STATION_NEW_VISN,
         STATION_MARKET,
         STATION_SUBMARKET,
         STATION_COUNTYNAME,
         STATION_DISTRICT,
         STATION_DISTRICT_NAME,
         STATION_URH_CODE,
         STATION_OPERATION_DATE,
         VAST_EXTRACT_DATE ,
         ACTIVE_START_DT,
         ACTIVE_END_DT,
         ACTIVE_FAG,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         STATION_NAME ,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE,
         STATION_LAT,
         STATION_LONG)
 VALUES (GEOCODE_STATION_H_S.NEXTVAL  ,
        :new.GEOCODE_STATION_ID,
        :new.STD_INSTITUTION_ID,
        :new.STATION_NUMBER,
        :new.STATION_ADRR_LINE1,
        :new.STATION_ADRR_LINE2,
        :new.STATION_ADRR_LINE3 ,
        :new.STATION_ADRR_LINE4,
        :new.STATION_CITY ,
        :new.STATION_STATE ,
        :new.STATION_ZIP ,
        :new.STATION_ZIP4,
        :new.VA_SITE_IND ,
        :new.CONTRACTED_IND ,
        :new.NUMBER_OF_PROVIDERS,
        :new.PARENT_STATION,
        :new.PARENT_STA_COMPLEXITY,
        :new.PLANNED_OR_OPERATIONAL,
        :new.STATION_PHONE,
        :new.STATION_FAX,
        :new.SHARED_IND,
        :new.SHARED_PARENT_STATION,
        :new.HEALTHCARE_CENTER,
        :new.MSCBOC,
        :new.NEW_VAMC,
        :new.PCCBOC,
        :new.COC_CLASSIFICATION_CODE ,
        :new.VA_HOSPITAL,
        :new.VHA_SITE_CATEGORY_CODE,
        :new.SITE_CLASSIFICATION_NAME,
        :new.PRIMARY_SVC_TYPE ,
        :new.OP_COC_CLASSIFICATION,
        :new.STATION_LONGITUDE,
        :new.STATION_LATITUDE,
        :new.STATION_NEW_VISN,
        :new.STATION_MARKET,
        :new.STATION_SUBMARKET,
        :new.STATION_COUNTYNAME,
        :new.STATION_DISTRICT,
        :new.STATION_DISTRICT_NAME,
        :new.STATION_URH_CODE,
        :new.STATION_OPERATION_DATE,
        :new.VAST_EXTRACT_DATE ,
        :new.ACTIVE_START_DT,
        :new.ACTIVE_END_DT,
        :new.ACTIVE_FAG,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.STATION_NAME ,
        sysdate,
        mDML,
        :new.STATION_LAT,
        :new.STATION_LONG);
   END IF;

 END GEOCODE_STATION_AUDIR_TRGR;
/
DROP TRIGGER ADR.GEOCODE_TRANSMIT_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.GEOCODE_TRANSMIT_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.GEOCODE_TRANSMIT
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO GEOCODE_TRANSMIT_H (GEOCODE_TRANSMIT_H_ID,
                                      GEOCODE_TRANSMIT_ID,
                                      GEOCODE_STATION_ID,
                                      PERSON_ID,
                                      ADDRESS_H_ID,
                                      ADDR_EXACT_MATCH_IND,
                                      ADDRESS_LINE1,
                                      ADDRESS_LINE2,
                                      CITY,
                                      STATE,
                                      ZIP,
                                      ZIP_PLUS4,
                                      COUNTRY,
                                      FIPS,
                                      NEW_VISN,
                                      MARKET,
                                      SUBMARKET,
                                      SECTOR,
                                      DISTRICT,
                                      STATE_FIPS,
                                      COUNTY_NAME,
                                      DISTRICT_NAME,
                                      MARKET_NAME,
                                      STATE_BY_COUNTY,
                                      URH_CODE,
                                      CONGRESSIONAL_DISTRICT,
                                      ADDR_LONGITUDE,
                                      ADDR_LATITUDE,
                                      DRIVING_DISTANCE,
                                      ADDR_LOCATION_NAME,
                                      ADDR_MATCH_TYPE,
                                      MATCH_ADDRESS,
                                      GEOCODING_FLAG,
                                      GEOCODE_SW_VER,
                                      GEOCODE_DATE,
                                      RECORD_CREATED_BY,
                                      RECORD_CREATED_DATE,
                                      RECORD_MODIFIED_BY,
                                      RECORD_MODIFIED_DATE,
                                      RECORD_MODIFIED_COUNT,
                                      VCELIGIBILITY_ID,
                                      TRANSACTION_TYPE_CODE,
                                      GEOCODE_RESULT,
                                      CENSUS_URH_CODE,
                                      CENSUS_RURALITY_CHANGED_IND)
           VALUES (GEOCODE_TRANSMIT_H_S.NEXTVAL,
                   :old.GEOCODE_TRANSMIT_ID,
                   :old.GEOCODE_STATION_ID,
                   :old.PERSON_ID,
                   :old.ADDRESS_H_ID,
                   :old.ADDR_EXACT_MATCH_IND,
                   :old.ADDRESS_LINE1,
                   :old.ADDRESS_LINE2,
                   :old.CITY,
                   :old.STATE,
                   :old.ZIP,
                   :old.ZIP_PLUS4,
                   :old.COUNTRY,
                   :old.FIPS,
                   :old.NEW_VISN,
                   :old.MARKET,
                   :old.SUBMARKET,
                   :old.SECTOR,
                   :old.DISTRICT,
                   :old.STATE_FIPS,
                   :old.COUNTY_NAME,
                   :old.DISTRICT_NAME,
                   :old.MARKET_NAME,
                   :old.STATE_BY_COUNTY,
                   :old.URH_CODE,
                   :old.CONGRESSIONAL_DISTRICT,
                   :old.ADDR_LONGITUDE,
                   :old.ADDR_LATITUDE,
                   :old.DRIVING_DISTANCE,
                   :old.ADDR_LOCATION_NAME,
                   :old.ADDR_MATCH_TYPE,
                   :old.MATCH_ADDRESS,
                   :old.GEOCODING_FLAG,
                   :old.GEOCODE_SW_VER,
                   :old.GEOCODE_DATE,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   :old.VCELIGIBILITY_ID,
                   mDML,
                   :old.GEOCODE_RESULT,
                   :old.CENSUS_URH_CODE,
                   :old.CENSUS_RURALITY_CHANGED_IND);
   ELSE
      IF UPDATING
      THEN
         -- exempt the logging when :new.CENSUS_RURALITY_CHANGED_IND is
         -- 1. 'B' for batch update
         -- 2. 'Job-RuralityChangedProcess'
         --
         IF (:new.CENSUS_RURALITY_CHANGED_IND = 'B' or :new.RECORD_MODIFIED_BY = 'Job-RuralityChangedProcess')
         THEN
            mDML := 'X';
         ELSE
            mDML := 'U';
         END IF;
      ELSE
         mDML := 'I';
      END IF;

      IF mDML <> 'X'
      THEN
         INSERT INTO GEOCODE_TRANSMIT_H (GEOCODE_TRANSMIT_H_ID,
                                         GEOCODE_TRANSMIT_ID,
                                         GEOCODE_STATION_ID,
                                         PERSON_ID,
                                         ADDRESS_H_ID,
                                         ADDR_EXACT_MATCH_IND,
                                         ADDRESS_LINE1,
                                         ADDRESS_LINE2,
                                         CITY,
                                         STATE,
                                         ZIP,
                                         ZIP_PLUS4,
                                         COUNTRY,
                                         FIPS,
                                         NEW_VISN,
                                         MARKET,
                                         SUBMARKET,
                                         SECTOR,
                                         DISTRICT,
                                         STATE_FIPS,
                                         COUNTY_NAME,
                                         DISTRICT_NAME,
                                         MARKET_NAME,
                                         STATE_BY_COUNTY,
                                         URH_CODE,
                                         CONGRESSIONAL_DISTRICT,
                                         ADDR_LONGITUDE,
                                         ADDR_LATITUDE,
                                         DRIVING_DISTANCE,
                                         ADDR_LOCATION_NAME,
                                         ADDR_MATCH_TYPE,
                                         MATCH_ADDRESS,
                                         GEOCODING_FLAG,
                                         GEOCODE_SW_VER,
                                         GEOCODE_DATE,
                                         RECORD_CREATED_BY,
                                         RECORD_CREATED_DATE,
                                         RECORD_MODIFIED_BY,
                                         RECORD_MODIFIED_DATE,
                                         RECORD_MODIFIED_COUNT,
                                         VCELIGIBILITY_ID,
                                         TRANSACTION_TYPE_CODE,
                                         GEOCODE_RESULT,
                                         CENSUS_URH_CODE,
                                         CENSUS_RURALITY_CHANGED_IND)
              VALUES (GEOCODE_TRANSMIT_H_S.NEXTVAL,
                      :new.GEOCODE_TRANSMIT_ID,
                      :new.GEOCODE_STATION_ID,
                      :new.PERSON_ID,
                      :new.ADDRESS_H_ID,
                      :new.ADDR_EXACT_MATCH_IND,
                      :new.ADDRESS_LINE1,
                      :new.ADDRESS_LINE2,
                      :new.CITY,
                      :new.STATE,
                      :new.ZIP,
                      :new.ZIP_PLUS4,
                      :new.COUNTRY,
                      :new.FIPS,
                      :new.NEW_VISN,
                      :new.MARKET,
                      :new.SUBMARKET,
                      :new.SECTOR,
                      :new.DISTRICT,
                      :new.STATE_FIPS,
                      :new.COUNTY_NAME,
                      :new.DISTRICT_NAME,
                      :new.MARKET_NAME,
                      :new.STATE_BY_COUNTY,
                      :new.URH_CODE,
                      :new.CONGRESSIONAL_DISTRICT,
                      :new.ADDR_LONGITUDE,
                      :new.ADDR_LATITUDE,
                      :new.DRIVING_DISTANCE,
                      :new.ADDR_LOCATION_NAME,
                      :new.ADDR_MATCH_TYPE,
                      :new.MATCH_ADDRESS,
                      :new.GEOCODING_FLAG,
                      :new.GEOCODE_SW_VER,
                      :new.GEOCODE_DATE,
                      :new.RECORD_CREATED_BY,
                      :new.RECORD_CREATED_DATE,
                      :new.RECORD_MODIFIED_BY,
                      :new.RECORD_MODIFIED_DATE,
                      :new.RECORD_MODIFIED_COUNT,
                      :new.VCELIGIBILITY_ID,
                      mDML,
                      :new.GEOCODE_RESULT,
                      :new.CENSUS_URH_CODE,
                      :new.CENSUS_RURALITY_CHANGED_IND);
      END IF;
   END IF;
END GEOCODE_TRANSMIT_AUDIR_TRGR;
/
DROP TRIGGER ADR.HANDBOOK_BATCH_REQ_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.HANDBOOK_BATCH_REQ_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.HANDBOOK_BATCH_REQUEST  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into HANDBOOK_BATCH_REQUEST_H
        (
        HANDBOOK_BATCH_REQUEST_H_ID,
        HANDBOOK_BATCH_REQUEST_ID,
    MAX_PER_JOB_NUMBER,
    BATCH_RELEASE_DATE,
    BATCH_RELEASE_SIZE,
    BATCH_CANCEL_DATE,
    NOTE,
    STD_HANDBOOKRELEASECNTL_ID,
    STD_HANDBOOKBATCHREQUESTSTA_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_BATCH_REQUEST_H_S.nextval,
        :old.HANDBOOK_BATCH_REQUEST_ID,
        :old.MAX_PER_JOB_NUMBER,
        :old.BATCH_RELEASE_DATE,
        :old.BATCH_RELEASE_SIZE,
        :old.BATCH_CANCEL_DATE,
        :old.NOTE,
        :old.STD_HANDBOOKRELEASECNTL_ID,
       :OLD.STD_HANDBOOKBATCHREQUESTSTA_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into HANDBOOK_BATCH_REQUEST_H
        (
        HANDBOOK_BATCH_REQUEST_H_ID,
        HANDBOOK_BATCH_REQUEST_ID,
    MAX_PER_JOB_NUMBER,
    BATCH_RELEASE_DATE,
    BATCH_RELEASE_SIZE,
    BATCH_CANCEL_DATE,
    NOTE,
    STD_HANDBOOKRELEASECNTL_ID,
  STD_HANDBOOKBATCHREQUESTSTA_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_BATCH_REQUEST_H_S.nextval,
        :new.HANDBOOK_BATCH_REQUEST_ID,
        :new.MAX_PER_JOB_NUMBER,
        :new.BATCH_RELEASE_DATE,
        :new.BATCH_RELEASE_SIZE,
        :new.BATCH_CANCEL_DATE,
        :new.NOTE,
        :new.STD_HANDBOOKRELEASECNTL_ID,
        :new.STD_HANDBOOKBATCHREQUESTSTA_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end HANDBOOK_BATCH_REQ_AUDIR_TRGR;
/
DROP TRIGGER ADR.HANDBOOK_MAIL_QUEUE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.HANDBOOK_MAIL_QUEUE_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."HANDBOOK_MAIL_QUEUE" FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into HANDBOOK_MAIL_QUEUE_H
        (
        HANDBOOK_MAIL_QUEUE_H_ID,
        HANDBOOK_MAIL_QUEUE_ID,
    COM_LETTER_TEMPLATE_ID,
    REMARK,
    STD_HANDBOOKRELEASECNTL_ID,
    PERSON_ID,
    ADDRESS_ID,
    HANDBOOK_BATCH_REQUEST_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_MAIL_QUEUE_H_S.nextval,
        :old.HANDBOOK_MAIL_QUEUE_ID,
    :old.COM_LETTER_TEMPLATE_ID,
    :old.REMARK,
    :old.STD_HANDBOOKRELEASECNTL_ID,
    :old.PERSON_ID,
    :old.ADDRESS_ID,
    :old.HANDBOOK_BATCH_REQUEST_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into HANDBOOK_MAIL_QUEUE_H
        (
        HANDBOOK_MAIL_QUEUE_H_ID,
        HANDBOOK_MAIL_QUEUE_ID,
    COM_LETTER_TEMPLATE_ID,
    REMARK,
    STD_HANDBOOKRELEASECNTL_ID,
    PERSON_ID,
    ADDRESS_ID,
    HANDBOOK_BATCH_REQUEST_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_MAIL_QUEUE_H_S.nextval,
        :new.HANDBOOK_MAIL_QUEUE_ID,
    :new.COM_LETTER_TEMPLATE_ID,
    :new.REMARK,
    :new.STD_HANDBOOKRELEASECNTL_ID,
    :new.PERSON_ID,
    :new.ADDRESS_ID,
    :new.HANDBOOK_BATCH_REQUEST_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end HANDBOOK_MAIL_QUEUE_audir_trgr;
/
DROP TRIGGER ADR.HANDBOOK_MAIL_STATUS_AUD_TRGR;

CREATE OR REPLACE TRIGGER ADR.HANDBOOK_MAIL_STATUS_AUD_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."HANDBOOK_MAIL_STATUS" FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into HANDBOOK_MAIL_STATUS_H
        (
        HANDBOOK_MAIL_STATUS_H_ID,
        HANDBOOK_MAIL_STATUS_ID,
    CMS_FILE_GENERATED_DATE,
    SENT_TO_USPS_DATE,
    HANDBOOK_MAIL_QUEUE_ID,
    STD_COMREJECTREASONTYPE_ID,
    STD_HANDBOOKMAILSTATTYPE_ID,
    ERROR_TEXT,
    RETURNED_FROM_USPS_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_MAIL_STATUS_H_S.nextval,
        :old.HANDBOOK_MAIL_STATUS_ID,
    :old.CMS_FILE_GENERATED_DATE,
    :old.SENT_TO_USPS_DATE,
    :old.HANDBOOK_MAIL_QUEUE_ID,
    :old.STD_COMREJECTREASONTYPE_ID,
    :old.STD_HANDBOOKMAILSTATTYPE_ID,
    :old.ERROR_TEXT,
    :old.RETURNED_FROM_USPS_DATE,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into HANDBOOK_MAIL_STATUS_H
        (
        HANDBOOK_MAIL_STATUS_H_ID,
        HANDBOOK_MAIL_STATUS_ID,
    CMS_FILE_GENERATED_DATE,
    SENT_TO_USPS_DATE,
    HANDBOOK_MAIL_QUEUE_ID,
    STD_COMREJECTREASONTYPE_ID,
    STD_HANDBOOKMAILSTATTYPE_ID,
    ERROR_TEXT,
    RETURNED_FROM_USPS_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HANDBOOK_MAIL_STATUS_H_S.nextval,
        :new.HANDBOOK_MAIL_STATUS_ID,
    :new.CMS_FILE_GENERATED_DATE,
    :new.SENT_TO_USPS_DATE,
    :new.HANDBOOK_MAIL_QUEUE_ID,
    :new.STD_COMREJECTREASONTYPE_ID,
    :new.STD_HANDBOOKMAILSTATTYPE_ID,
    :new.ERROR_TEXT,
    :new.RETURNED_FROM_USPS_DATE,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end HANDBOOK_MAIL_STATUS_AUD_TRGR;
/
DROP TRIGGER ADR.HANDBOOK_REQ_VET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.HANDBOOK_REQ_VET_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.HANDBOOK_REQUEST_VETERAN  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into HANDBOOK_REQUEST_VETERAN_H
        (
       HANDBOOK_REQUEST_VETERAN_H_ID,
       HANDBOOK_REQUEST_VETERAN_ID,
        HANDBOOK_BATCH_REQUEST_ID,
        PERSON_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
       HANDBOOK_REQUEST_VETERAN_H_S.nextval,
        :old.HANDBOOK_REQUEST_VETERAN_ID,
        :old.HANDBOOK_BATCH_REQUEST_ID,
        :old.PERSON_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into HANDBOOK_REQUEST_VETERAN_H
        (
       HANDBOOK_REQUEST_VETERAN_H_ID,
       HANDBOOK_REQUEST_VETERAN_ID,
        HANDBOOK_BATCH_REQUEST_ID,
        PERSON_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
       HANDBOOK_REQUEST_VETERAN_H_S.nextval,
        :new.HANDBOOK_REQUEST_VETERAN_ID,
        :new.HANDBOOK_BATCH_REQUEST_ID,
        :new.PERSON_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end HANDBOOK_REQ_VET_AUDIR_TRGR;
/
DROP TRIGGER ADR.HEALTH_BENEFIT_PLAN_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.HEALTH_BENEFIT_PLAN_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.Health_Benefit_Plan
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO Health_Benefit_Plan_H
        (Health_benefit_plan_h_id,
         Health_benefit_plan_id,
         Health_benefit_profile_id,
         Std_healthbenefitplan_id,
         Health_bnft_pln_update_date,
         Std_datachangesource_id,
         Std_institution_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Override_flag,
         Override_assignment,
         Override_reason,
         Transaction_type_code
        )
        VALUES
        (Health_Benefit_Plan_H_S.NEXTVAL,
         :OLD.Health_benefit_plan_id,
         :OLD.Health_benefit_profile_id,
         :OLD.Std_healthbenefitplan_id,
         :OLD.Health_bnft_pln_update_date,
         :OLD.Std_datachangesource_id,
         :OLD.Std_institution_id,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_date,
         :OLD.Record_modified_count,
         SYSDATE,
         :OLD.Override_flag,
         :OLD.Override_assignment,
         :OLD.Override_reason,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      insert into HEALTH_BENEFIT_PLAN_H
        (Health_benefit_plan_h_id,
         Health_benefit_plan_id,
         Health_benefit_profile_id,
         Std_healthbenefitplan_id,
         Health_bnft_pln_update_date,
         Std_datachangesource_id,
         Std_institution_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Override_flag,
         Override_assignment,
         Override_reason,
         Transaction_type_code
        )
        VALUES
        (Health_Benefit_Plan_H_S.NEXTVAL,
         :NEW.Health_benefit_plan_id,
         :NEW.Health_benefit_profile_id,
         :NEW.Std_healthbenefitplan_id,
         :NEW.Health_bnft_pln_update_date,
         :NEW.Std_datachangesource_id,
         :NEW.Std_institution_id,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_date,
         :NEW.Record_modified_count,
         SYSDATE,
         :NEW.Override_flag,
         :NEW.Override_assignment,
         :NEW.Override_reason,
         mDML
        );

    END IF;

  END Health_Benefit_Plan_Audir_Trgr;
/
DROP TRIGGER ADR.HEALTH_BENEFIT_PROF_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.HEALTH_BENEFIT_PROF_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.Health_Benefit_Profile
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO Health_Benefit_Profile_H
        (Health_benefit_profile_h_id,
         Health_benefit_profile_id,
         Person_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Transaction_type_code,
         triggerZ11
        )
        VALUES
        (Health_Benefit_Profile_H_S.NEXTVAL,
         :OLD.Health_benefit_profile_id,
         :OLD.Person_id,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_date,
         :OLD.Record_modified_count,
         SYSDATE,
         'D',
         :OLD.triggerZ11
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      INSERT INTO Health_Benefit_Profile_H
        (Health_benefit_profile_h_id,
         Health_benefit_profile_id,
         Person_id,
         Record_created_by,
         Record_created_date,
         Record_modified_by,
         Record_modified_date,
         Record_modified_count,
         History_created_date,
         Transaction_type_code,
         triggerZ11
        )
        VALUES
        (Health_Benefit_Profile_H_S.NEXTVAL,
         :NEW.Health_benefit_profile_id,
         :NEW.Person_id,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_date,
         :NEW.Record_modified_count,
         SYSDATE,
         mDML,
         :NEW.triggerZ11
        );

    END IF;

  END Health_Benefit_Prof_Audir_Trgr;
/
DROP TRIGGER ADR.HEALTH_BENF_APPLN_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.HEALTH_BENF_APPLN_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.HEALTH_BENEFITS_APPLICATION for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into HEALTH_BENEFITS_APPLICATION_H
    (
    HEALTH_BENEFITS_APPLN_H_ID,
    HEALTH_BENEFITS_APPLICATION_ID,
    PERSON_ID,
    STD_INSTITUTION_ID,
    APPLICATION_DATE,
    STD_HEALTHBENEFITTYPE_ID,
    Z07_FROM_VISTA_IND,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE
        )
    values
    (
    HEALTH_BENEFITS_APP_H_S.nextval,
    :old.HEALTH_BENEFITS_APPLICATION_ID,
    :old.PERSON_ID,
    :old.STD_INSTITUTION_ID,
    :old.APPLICATION_DATE,
    :old.STD_HEALTHBENEFITTYPE_ID,
    :old.Z07_FROM_VISTA_IND,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.RECORD_MODIFIED_COUNT,
    'D'
    );

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into HEALTH_BENEFITS_APPLICATION_H
    (
    HEALTH_BENEFITS_APPLN_H_ID,
    HEALTH_BENEFITS_APPLICATION_ID,
    PERSON_ID,
    STD_INSTITUTION_ID,
    APPLICATION_DATE,
    STD_HEALTHBENEFITTYPE_ID,
    Z07_FROM_VISTA_IND,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE
        )
    values
    (
    HEALTH_BENEFITS_APP_H_S.nextval,
    :new.HEALTH_BENEFITS_APPLICATION_ID,
    :new.PERSON_ID,
    :new.STD_INSTITUTION_ID,
    :new.APPLICATION_DATE,
    :new.STD_HEALTHBENEFITTYPE_ID,
    :new.Z07_FROM_VISTA_IND,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.RECORD_MODIFIED_COUNT,
    mDML
    );

  end if;

end  HEALTH_BENF_APPLN_audir_trgr;
/
DROP TRIGGER ADR.HEALTH_CARE_PROV_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.HEALTH_CARE_PROV_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.HEALTH_CARE_PROVIDER
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into HEALTH_CARE_PROVIDER_H
        (
        HEALTH_CARE_PROVIDER_H_ID,
        HEALTH_CARE_PROVIDER_ID,
        LAST_NAME,
        FIRST_NAME,
        MIDDLE_NAME,
        SUFFIX,
        PREFIX,
        EDUCATIONAL_DEGREE,
        PRACTITIONER_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HEALTH_CARE_PROVIDER_H_S.nextval,
        :old.HEALTH_CARE_PROVIDER_ID,
        :old.LAST_NAME,
        :old.FIRST_NAME,
        :old.MIDDLE_NAME,
        :old.SUFFIX,
        :old.PREFIX,
        :old.EDUCATIONAL_DEGREE,
        :old.PRACTITIONER_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into HEALTH_CARE_PROVIDER_H
        (
        HEALTH_CARE_PROVIDER_H_ID,
        HEALTH_CARE_PROVIDER_ID,
        LAST_NAME,
        FIRST_NAME,
        MIDDLE_NAME,
        SUFFIX,
        PREFIX,
        EDUCATIONAL_DEGREE,
        PRACTITIONER_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        HEALTH_CARE_PROVIDER_H_S.nextval,
        :new.HEALTH_CARE_PROVIDER_ID,
        :new.LAST_NAME,
        :new.FIRST_NAME,
        :new.MIDDLE_NAME,
        :new.SUFFIX,
        :new.PREFIX,
        :new.EDUCATIONAL_DEGREE,
        :new.PRACTITIONER_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end HEALTH_CARE_PROV_audir_trgr;
/
DROP TRIGGER ADR.HLTH_BEN_PLAN_DESC_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.HLTH_BEN_PLAN_DESC_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.HEALTH_BENEFIT_PLAN_DESC
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO ADR.HEALTH_BENEFIT_PLAN_DESC_H
        (HLTH_BEN_PLAN_DESC_H_ID,
         HLTH_BEN_PLAN_DESC_ID,
         HLTH_BEN_PLAN_DESCRIPTION,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE,
         HEALTH_BENEFIT_PLAN_DETAIL_ID
        )
        VALUES
        (HEALTH_BENEFIT_PLAN_DESC_H_S.NEXTVAL,
         :OLD.HLTH_BEN_PLAN_DESC_ID,
         :OLD.HLTH_BEN_PLAN_DESCRIPTION,
         :OLD.Record_created_by,
         :OLD.Record_created_date,
         :OLD.Record_modified_by,
         :OLD.Record_modified_date,
         :OLD.Record_modified_count,
         SYSDATE,
         'D',
         :OLD.HEALTH_BENEFIT_PLAN_DETAIL_ID
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      insert into ADR.HEALTH_BENEFIT_PLAN_DESC_H
        (HLTH_BEN_PLAN_DESC_H_ID,
         HLTH_BEN_PLAN_DESC_ID,
         HLTH_BEN_PLAN_DESCRIPTION,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE,
         HEALTH_BENEFIT_PLAN_DETAIL_ID
        )
        VALUES
        (HEALTH_BENEFIT_PLAN_DESC_H_S.NEXTVAL,
         :NEW.HLTH_BEN_PLAN_DESC_ID,
         :NEW.HLTH_BEN_PLAN_DESCRIPTION,
         :NEW.Record_created_by,
         :NEW.Record_created_date,
         :NEW.Record_modified_by,
         :NEW.Record_modified_date,
         :NEW.Record_modified_count,
         SYSDATE,
         mDML,
         :NEW.HEALTH_BENEFIT_PLAN_DETAIL_ID
        );

    END IF;

  END HLTH_BEN_PLAN_DESC_AUDIR_TRGR;
/
DROP TRIGGER ADR.HLTH_BEN_PLN_DTL_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.HLTH_BEN_PLN_DTL_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.HEALTH_BENEFIT_PLAN_DETAIL
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO ADR.HEALTH_BENEFIT_PLAN_DETAIL_H
        (HEALTH_BENEFIT_PLAN_DET_H_ID,
         HEALTH_BENEFIT_PLAN_DETAIL_ID,
         HLTH_BEN_PLAN_NAME_ID,
         HLTH_BEN_PLAN_CODE,
      	 HLTH_BEN_PLAN_COV_CODE,
     	 HLTH_BEN_PLAN_EFF_DATE,
     	 HLTH_BEN_PLAN_EXP_DATE,
         HLTH_BEN_PLAN_AUTO_IND,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (HEALTH_BENEFIT_PLAN_DETAIL_H_S.NEXTVAL,
         :OLD.HEALTH_BENEFIT_PLAN_DETAIL_ID,
     	 :OLD.HLTH_BEN_PLAN_NAME_ID,
    	 :OLD.HLTH_BEN_PLAN_CODE,
     	 :OLD.HLTH_BEN_PLAN_COV_CODE,
     	 :OLD.HLTH_BEN_PLAN_EFF_DATE,
    	 :OLD.HLTH_BEN_PLAN_EXP_DATE,
     	 :OLD.HLTH_BEN_PLAN_AUTO_IND,
     	 :OLD.RECORD_CREATED_BY,
     	 :OLD.RECORD_CREATED_DATE,
     	 :OLD.RECORD_MODIFIED_BY,
     	 :OLD.RECORD_MODIFIED_DATE,
     	 :OLD.RECORD_MODIFIED_COUNT,
         SYSDATE,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      insert into ADR.HEALTH_BENEFIT_PLAN_DETAIL_H
      (HEALTH_BENEFIT_PLAN_DET_H_ID,
         HEALTH_BENEFIT_PLAN_DETAIL_ID,
         HLTH_BEN_PLAN_NAME_ID,
         HLTH_BEN_PLAN_CODE,
         HLTH_BEN_PLAN_COV_CODE,
         HLTH_BEN_PLAN_EFF_DATE,
         HLTH_BEN_PLAN_EXP_DATE,
         HLTH_BEN_PLAN_AUTO_IND,
         RECORD_CREATED_BY,
         RECORD_CREATED_DATE,
         RECORD_MODIFIED_BY,
         RECORD_MODIFIED_DATE,
         RECORD_MODIFIED_COUNT,
         HISTORY_CREATED_DATE,
         TRANSACTION_TYPE_CODE
        )
        VALUES
        (HEALTH_BENEFIT_PLAN_DETAIL_H_S.NEXTVAL,
           :NEW.HEALTH_BENEFIT_PLAN_DETAIL_ID,
           :NEW.HLTH_BEN_PLAN_NAME_ID,
           :NEW.HLTH_BEN_PLAN_CODE,
           :NEW.HLTH_BEN_PLAN_COV_CODE,
           :NEW.HLTH_BEN_PLAN_EFF_DATE,
           :NEW.HLTH_BEN_PLAN_EXP_DATE,
           :NEW.HLTH_BEN_PLAN_AUTO_IND,
           :NEW.RECORD_CREATED_BY,
           :NEW.RECORD_CREATED_DATE,
           :NEW.RECORD_MODIFIED_BY,
           :NEW.RECORD_MODIFIED_DATE,
           :NEW.RECORD_MODIFIED_COUNT,
         SYSDATE,
         mDML
      );

    END IF;

  END HLTH_BEN_PLAN_DESC_AUDIR_TRGR;
/
DROP TRIGGER ADR.HLTH_BEN_PLN_NAM_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.HLTH_BEN_PLN_NAM_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
    ON ADR.HEALTH_BENEFIT_PLAN_NAME
  REFERENCING  OLD AS OLD NEW AS NEW
  FOR EACH ROW
DECLARE

    mDML char(1);

  BEGIN

    IF DELETING THEN

      INSERT INTO ADR.HEALTH_BENEFIT_PLAN_NAME_H
          (HLTH_BEN_PLAN_NAME_H_ID ,
    	   HLTH_BEN_PLAN_NAME_ID,
   	   HLTH_BEN_PLAN_NAME,
    	   STD_HLTHBENEFITPLANTYPE_ID ,
           RECORD_CREATED_BY,
           RECORD_CREATED_DATE,
           RECORD_MODIFIED_BY,
           RECORD_MODIFIED_DATE,
           RECORD_MODIFIED_COUNT,
           HISTORY_CREATED_DATE ,
           TRANSACTION_TYPE_CODE
       )
      VALUES
        (HEALTH_BENEFIT_PLAN_NAME_H_S.NEXTVAL,
         :OLD.HLTH_BEN_PLAN_NAME_ID,
         :OLD.HLTH_BEN_PLAN_NAME,
         :OLD.STD_HLTHBENEFITPLANTYPE_ID,
         :OLD.RECORD_CREATED_BY,
         :OLD.RECORD_CREATED_DATE,
         :OLD.RECORD_MODIFIED_BY,
         :OLD.RECORD_MODIFIED_DATE,
         :OLD.RECORD_MODIFIED_COUNT,
         SYSDATE,
         'D'
        );

    ELSE

      IF UPDATING THEN

        mDML := 'U';

      ELSE

        mDML := 'I';

      END IF;

      INSERT INTO ADR.HEALTH_BENEFIT_PLAN_NAME_H
      (	HLTH_BEN_PLAN_NAME_H_ID ,
       	HLTH_BEN_PLAN_NAME_ID,
     	HLTH_BEN_PLAN_NAME,
     	STD_HLTHBENEFITPLANTYPE_ID ,
     	RECORD_CREATED_BY,
     	RECORD_CREATED_DATE,
     	RECORD_MODIFIED_BY,
     	RECORD_MODIFIED_DATE,
     	RECORD_MODIFIED_COUNT,
     	HISTORY_CREATED_DATE ,
     	TRANSACTION_TYPE_CODE
     )
     VALUES
     	(HEALTH_BENEFIT_PLAN_NAME_H_S.NEXTVAL,
     	:NEW.HLTH_BEN_PLAN_NAME_ID,
     	:NEW.HLTH_BEN_PLAN_NAME,
     	:NEW.STD_HLTHBENEFITPLANTYPE_ID,
     	:NEW.RECORD_CREATED_BY,
     	:NEW.RECORD_CREATED_DATE,
     	:NEW.RECORD_MODIFIED_BY,
     	:NEW.RECORD_MODIFIED_DATE,
     	:NEW.RECORD_MODIFIED_COUNT,
     	 SYSDATE,
         mDML
        );

    END IF;

  END HLTH_BEN_PLN_NAM_AUDIR_TRGR;
/
DROP TRIGGER ADR.INCOME_TEST_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.INCOME_TEST_AUDIR_TRGR
after Update or Delete or Insert
on ADR.INCOME_TEST
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
       mDML char(1);
begin

    if DELETING then
        insert into INCOME_TEST_H
        (
        INCOME_TEST_H_ID,
        INCOME_TEST_ID,
        PERSON_ID,
        INCOME_TEST_TYPE_ID,
        INCOME_TEST_SRC_TYPE_ID,
        MEANS_TEST_STATUS_TYPE_ID,
        MT_NOT_REQD_RSN_TYPE_ID,
        SITE_CONDUCTING_TEST_ID,
        INCOME_YEAR,
        INCOME_TEST_EFFECTIVE_DATE,
        IVM_TEST_COMPLETION_DATE,
        PRIMARY_TEST_IND,
        ADJUDICATION_SENT_DATE,
        ADJUDICATED_DATE,
        THRESHOLD_MT_EXEMPT_AMOUNT,
        THRESHOLD_GMT_AMOUNT,
        THRESHOLD_NETWORTH_AMOUNT,
        THRESHOLD_PENSION_AMOUNT,
        THRESHOLD_INCOME_AMOUNT,
        DEDUCTIBLE_EXPENSE_AMOUNT,
        INCOME_VERIFY_STATUS_DATE,
        FARM_RANCH_INCOME_AMOUNT,
        DISCLOSE_FINANCIAL_INCOME_IND,
        AGREED_TO_PAY_DEDUCTIBLE_IND,
        DEPENDENT_OTHER_COUNT,
        INCOME_TOTAL,
        EXPENSE_TOTAL,
        NET_WORTH_TOTAL,
        PREV_YEAR_THRESHOLD_IND,
        MT_NOT_REQUIRED_DATE,
        REFUSED_TO_SIGN_IND,
        GMT_ADDRESS_LINE1,
        GMT_ADDRESS_LINE2,
        GMT_CITY,
        GMT_STATE_CODE,
        GMT_COUNTY_CODE,
        GMT_POSTAL_CODE,
        GMT_MSA_CODE,
        GMT_SITE_ADDRESS_IND,
        FINANCIAL_HARDSHIP_IND,
        HARDSHIP_REVIEW_DATE,
        HARDSHIP_EFFECTIVE_DATE,
        REMARKS,
        HARDSHIP_REASON_TEXT,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        CAD_ADJUSTED_IND,
        HARDSHIP_REVIEW_SITE_ID,
        INCOME_VERIFY_STATUS_TYPE_ID,
        GMT_ADDRESS_LINE3,
        GMT_COUNTRY_CODE,
        FUTURE_TEST_FLAG,
        INCOME_NET_TOTAL,
        ASSIGNED_CONTACT_REP_USERNAME,
        PG8_RELAXATION_IND,        --ccr 1802
        TRANSACTION_TYPE_CODE,
        STD_WORKFLOWCASESTATUS_ID,
        IVM_CONVERSION_DATE,
        BT_FINANCIAL_IND
          )
        values
        (
        INCOME_TEST_H_S.nextval,
        :old.INCOME_TEST_ID,
        :old.PERSON_ID,
        :old.INCOME_TEST_TYPE_ID,
        :old.INCOME_TEST_SRC_TYPE_ID,
        :old.MEANS_TEST_STATUS_TYPE_ID,
        :old.MT_NOT_REQD_RSN_TYPE_ID,
        :old.SITE_CONDUCTING_TEST_ID,
        :old.INCOME_YEAR,
        :old.INCOME_TEST_EFFECTIVE_DATE,
        :old.IVM_TEST_COMPLETION_DATE,
        :old.PRIMARY_TEST_IND,
        :old.ADJUDICATION_SENT_DATE,
        :old.ADJUDICATED_DATE,
        :old.THRESHOLD_MT_EXEMPT_AMOUNT,
        :old.THRESHOLD_GMT_AMOUNT,
        :old.THRESHOLD_NETWORTH_AMOUNT,
        :old.THRESHOLD_PENSION_AMOUNT,
        :old.THRESHOLD_INCOME_AMOUNT,
        :old.DEDUCTIBLE_EXPENSE_AMOUNT,
        :old.INCOME_VERIFY_STATUS_DATE,
        :old.FARM_RANCH_INCOME_AMOUNT,
        :old.DISCLOSE_FINANCIAL_INCOME_IND,
        :old.AGREED_TO_PAY_DEDUCTIBLE_IND,
        :old.DEPENDENT_OTHER_COUNT,
        :old.INCOME_TOTAL,
        :old.EXPENSE_TOTAL,
        :old.NET_WORTH_TOTAL,
        :old.PREV_YEAR_THRESHOLD_IND,
        :old.MT_NOT_REQUIRED_DATE,
        :old.REFUSED_TO_SIGN_IND,
        :old.GMT_ADDRESS_LINE1,
        :old.GMT_ADDRESS_LINE2,
        :old.GMT_CITY,
        :old.GMT_STATE_CODE,
        :old.GMT_COUNTY_CODE,
        :old.GMT_POSTAL_CODE,
        :old.GMT_MSA_CODE,
        :old.GMT_SITE_ADDRESS_IND,
        :old.FINANCIAL_HARDSHIP_IND,
        :old.HARDSHIP_REVIEW_DATE,
        :old.HARDSHIP_EFFECTIVE_DATE,
        :old.REMARKS,
        :old.HARDSHIP_REASON_TEXT,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        :old.CAD_ADJUSTED_IND,
        :old.HARDSHIP_REVIEW_SITE_ID,
        :old.INCOME_VERIFY_STATUS_TYPE_ID,
        :old.GMT_ADDRESS_LINE3,
        :old.GMT_COUNTRY_CODE,
        :old.FUTURE_TEST_FLAG,
        :old.INCOME_NET_TOTAL,
        :old.ASSIGNED_CONTACT_REP_USERNAME,
        :OLD.PG8_RELAXATION_IND,    -- ccr 1802
        'D',
        :old.STD_WORKFLOWCASESTATUS_ID,
        :old.IVM_CONVERSION_DATE,
        :old.BT_FINANCIAL_IND
        );

    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into INCOME_TEST_H
        (
        INCOME_TEST_H_ID,
        INCOME_TEST_ID,
        PERSON_ID,
        INCOME_TEST_TYPE_ID,
        INCOME_TEST_SRC_TYPE_ID,
        MEANS_TEST_STATUS_TYPE_ID,
        MT_NOT_REQD_RSN_TYPE_ID,
        SITE_CONDUCTING_TEST_ID,
        INCOME_YEAR,
        INCOME_TEST_EFFECTIVE_DATE,
        IVM_TEST_COMPLETION_DATE,
        PRIMARY_TEST_IND,
        ADJUDICATION_SENT_DATE,
        ADJUDICATED_DATE,
        THRESHOLD_MT_EXEMPT_AMOUNT,
        THRESHOLD_GMT_AMOUNT,
        THRESHOLD_NETWORTH_AMOUNT,
        THRESHOLD_PENSION_AMOUNT,
        THRESHOLD_INCOME_AMOUNT,
        DEDUCTIBLE_EXPENSE_AMOUNT,
        INCOME_VERIFY_STATUS_DATE,
        FARM_RANCH_INCOME_AMOUNT,
        DISCLOSE_FINANCIAL_INCOME_IND,
        AGREED_TO_PAY_DEDUCTIBLE_IND,
        DEPENDENT_OTHER_COUNT,
        INCOME_TOTAL,
        EXPENSE_TOTAL,
        NET_WORTH_TOTAL,
        PREV_YEAR_THRESHOLD_IND,
        MT_NOT_REQUIRED_DATE,
        REFUSED_TO_SIGN_IND,
        GMT_ADDRESS_LINE1,
        GMT_ADDRESS_LINE2,
        GMT_CITY,
        GMT_STATE_CODE,
        GMT_COUNTY_CODE,
        GMT_POSTAL_CODE,
        GMT_MSA_CODE,
        GMT_SITE_ADDRESS_IND,
        FINANCIAL_HARDSHIP_IND,
        HARDSHIP_REVIEW_DATE,
        HARDSHIP_EFFECTIVE_DATE,
        REMARKS,
        HARDSHIP_REASON_TEXT,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        CAD_ADJUSTED_IND,
        HARDSHIP_REVIEW_SITE_ID,
        INCOME_VERIFY_STATUS_TYPE_ID,
        GMT_ADDRESS_LINE3,
        GMT_COUNTRY_CODE,
        FUTURE_TEST_FLAG,
        INCOME_NET_TOTAL,
        ASSIGNED_CONTACT_REP_USERNAME,
        PG8_RELAXATION_IND,        --ccr 1802
        TRANSACTION_TYPE_CODE,
        STD_WORKFLOWCASESTATUS_ID,
        IVM_CONVERSION_DATE,
        BT_FINANCIAL_IND
          )
        values
        (
        INCOME_TEST_H_S.nextval,
        :new.INCOME_TEST_ID,
        :new.PERSON_ID,
        :new.INCOME_TEST_TYPE_ID,
        :new.INCOME_TEST_SRC_TYPE_ID,
        :new.MEANS_TEST_STATUS_TYPE_ID,
        :new.MT_NOT_REQD_RSN_TYPE_ID,
        :new.SITE_CONDUCTING_TEST_ID,
        :new.INCOME_YEAR,
        :new.INCOME_TEST_EFFECTIVE_DATE,
        :new.IVM_TEST_COMPLETION_DATE,
        :new.PRIMARY_TEST_IND,
        :new.ADJUDICATION_SENT_DATE,
        :new.ADJUDICATED_DATE,
        :new.THRESHOLD_MT_EXEMPT_AMOUNT,
        :new.THRESHOLD_GMT_AMOUNT,
        :new.THRESHOLD_NETWORTH_AMOUNT,
        :new.THRESHOLD_PENSION_AMOUNT,
        :new.THRESHOLD_INCOME_AMOUNT,
        :new.DEDUCTIBLE_EXPENSE_AMOUNT,
        :new.INCOME_VERIFY_STATUS_DATE,
        :new.FARM_RANCH_INCOME_AMOUNT,
        :new.DISCLOSE_FINANCIAL_INCOME_IND,
        :new.AGREED_TO_PAY_DEDUCTIBLE_IND,
        :new.DEPENDENT_OTHER_COUNT,
        :new.INCOME_TOTAL,
        :new.EXPENSE_TOTAL,
        :new.NET_WORTH_TOTAL,
        :new.PREV_YEAR_THRESHOLD_IND,
        :new.MT_NOT_REQUIRED_DATE,
        :new.REFUSED_TO_SIGN_IND,
        :new.GMT_ADDRESS_LINE1,
        :new.GMT_ADDRESS_LINE2,
        :new.GMT_CITY,
        :new.GMT_STATE_CODE,
        :new.GMT_COUNTY_CODE,
        :new.GMT_POSTAL_CODE,
        :new.GMT_MSA_CODE,
        :new.GMT_SITE_ADDRESS_IND,
        :new.FINANCIAL_HARDSHIP_IND,
        :new.HARDSHIP_REVIEW_DATE,
        :new.HARDSHIP_EFFECTIVE_DATE,
        :new.REMARKS,
        :new.HARDSHIP_REASON_TEXT,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.CAD_ADJUSTED_IND,
        :new.HARDSHIP_REVIEW_SITE_ID,
        :new.INCOME_VERIFY_STATUS_TYPE_ID,
        :new.GMT_ADDRESS_LINE3,
        :new.GMT_COUNTRY_CODE,
        :new.FUTURE_TEST_FLAG,
        :new.INCOME_NET_TOTAL,
        :new.ASSIGNED_CONTACT_REP_USERNAME,
        :NEW.PG8_RELAXATION_IND,        --ccr 1802
        mDML,
         :new.STD_WORKFLOWCASESTATUS_ID,
         :new.IVM_CONVERSION_DATE,
         :new.BT_FINANCIAL_IND
        );

    end if;

end  INCOME_TEST_audir_trgr;
/
DROP TRIGGER ADR.INCOME_TEST_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.INCOME_TEST_DET_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."INCOME_TEST_DETAIL" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into INCOME_TEST_DETAIL_H
		(
		INCOME_TEST_DETAIL_H_ID,
		INCOME_TEST_DETAIL_ID,
		INCOME_TEST_ID,
		INCOME_TEST_TYPE_ID,
		TEST_STATUS_TYPE_ID,
		TEST_DETMND_STATUS_TYPE_ID,
		INCOME_TEST_LAST_EDITED_DATE,
		INCOME_TEST_COMPLETED_DATE,
		INCOME_TEST_EXPIRATION_DATE,
		INCOME_TEST_EFFECTIVE_DATE,
		INCOME_TEST_SIGNED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		INCOME_TEST_DETAIL_H_S.nextval,
		:old.INCOME_TEST_DETAIL_ID,
		:old.INCOME_TEST_ID,
		:old.INCOME_TEST_TYPE_ID,
		:old.TEST_STATUS_TYPE_ID,
		:old.TEST_DETMND_STATUS_TYPE_ID,
		:old.INCOME_TEST_LAST_EDITED_DATE,
		:old.INCOME_TEST_COMPLETED_DATE,
		:old.INCOME_TEST_EXPIRATION_DATE,
		:old.INCOME_TEST_EFFECTIVE_DATE,
		:old.INCOME_TEST_SIGNED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into INCOME_TEST_DETAIL_H
		(
		INCOME_TEST_DETAIL_H_ID,
		INCOME_TEST_DETAIL_ID,
		INCOME_TEST_ID,
		INCOME_TEST_TYPE_ID,
		TEST_STATUS_TYPE_ID,
		TEST_DETMND_STATUS_TYPE_ID,
		INCOME_TEST_LAST_EDITED_DATE,
		INCOME_TEST_COMPLETED_DATE,
		INCOME_TEST_EXPIRATION_DATE,
		INCOME_TEST_EFFECTIVE_DATE,
		INCOME_TEST_SIGNED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		INCOME_TEST_DETAIL_H_S.nextval,
		:new.INCOME_TEST_DETAIL_ID,
		:new.INCOME_TEST_ID,
		:new.INCOME_TEST_TYPE_ID,
		:new.TEST_STATUS_TYPE_ID,
		:new.TEST_DETMND_STATUS_TYPE_ID,
		:new.INCOME_TEST_LAST_EDITED_DATE,
		:new.INCOME_TEST_COMPLETED_DATE,
		:new.INCOME_TEST_EXPIRATION_DATE,
		:new.INCOME_TEST_EFFECTIVE_DATE,
		:new.INCOME_TEST_SIGNED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  INCOME_TEST_DET_audir_trgr;
/
DROP TRIGGER ADR.INCOMPETENT_RUL_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.INCOMPETENT_RUL_AUDIR_TRGR
after Update or Delete or Insert
on ADR.INCOMPETENT_RULING
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into INCOMPETENT_RULING_H
		(
		INCOMPETENT_RULING_H_ID,
		INCOMPETENT_RULING_ID,
		PERSON_ID,
		CIVIL_INCPTNT_RULING_DATE_TXT,
		VA_INCPTNT_RULING_DATE_TXT,
		RULED_INCOMPETENT_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		INCOMPETENT_RULING_H_S.nextval,
		:old.INCOMPETENT_RULING_ID,
		:old.PERSON_ID,
		:old.CIVIL_INCPTNT_RULING_DATE_TXT,
		:old.VA_INCPTNT_RULING_DATE_TXT,
		:old.RULED_INCOMPETENT_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into INCOMPETENT_RULING_H
		(
		INCOMPETENT_RULING_H_ID,
		INCOMPETENT_RULING_ID,
		PERSON_ID,
		CIVIL_INCPTNT_RULING_DATE_TXT,
		VA_INCPTNT_RULING_DATE_TXT,
		RULED_INCOMPETENT_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		INCOMPETENT_RULING_H_S.nextval,
		:new.INCOMPETENT_RULING_ID,
		:new.PERSON_ID,
		:new.CIVIL_INCPTNT_RULING_DATE_TXT,
		:new.VA_INCPTNT_RULING_DATE_TXT,
		:new.RULED_INCOMPETENT_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  INCOMPETENT_RUL_audir_trgr;
/
DROP TRIGGER ADR.INELIGIBLE_RUL_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.INELIGIBLE_RUL_AUDIR_TRGR
after Update or Delete or Insert
on ADR.INELIGIBLE_RULING
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into INELIGIBLE_RULING_H
		(
		INELIGIBLE_RULING_H_ID,
		INELIGIBLE_RULING_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		INELIGIBLE_DATE,
		INELIGIBLE_REASON_TEXT,
		VARO_DECISION_TEXT,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT     ,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		INELIGIBLE_RULING_H_S.nextval,
		:old.INELIGIBLE_RULING_ID,
		:old.PERSON_ID,
		:old.STD_INSTITUTION_ID,
		:old.INELIGIBLE_DATE,
		:old.INELIGIBLE_REASON_TEXT,
		:old.VARO_DECISION_TEXT,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT     ,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into INELIGIBLE_RULING_H
		(
		INELIGIBLE_RULING_H_ID,
		INELIGIBLE_RULING_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		INELIGIBLE_DATE,
		INELIGIBLE_REASON_TEXT,
		VARO_DECISION_TEXT,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		INELIGIBLE_RULING_H_S.nextval,
		:new.INELIGIBLE_RULING_ID,
		:new.PERSON_ID,
		:new.STD_INSTITUTION_ID,
		:new.INELIGIBLE_DATE,
		:new.INELIGIBLE_REASON_TEXT,
		:new.VARO_DECISION_TEXT,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  INELIGIBLE_RUL_audir_trgr;
/
DROP TRIGGER ADR.INSURANCE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.INSURANCE_AUDIR_TRGR
After Update or Delete or Insert
ON ADR.INSURANCE REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
       mDML char(1);
    mc_eff_d date;
begin

    if DELETING then
        insert into INSURANCE_H
        (
        INSURANCE_H_ID,
        INSURANCE_ID,
        PERSON_ID,
        INSURANCE_RPT_SRC_TYPE_ID,
        POLICY_HOLDER_TYPE_ID,
        INSURANCE_MAPPING_TYPE_CODE,
        INSURANCE_COMPANY_NAME,
        POLICY_HOLDER_SSN,
        POLICY_HOLDER_NAME,
        POLICY_HOLDER_BIRTH_DATE,
        POLICY_NUMBER,
        POLICY_EFFECTIVE_DATE_TXT,
        POLICY_EXPIRATION_DATE_TXT,
        GROUP_NAME,
        GROUP_NUMBER,
        NAME_ON_MEDICARE_CARD,
        MEDICARE_CLAIM_NUMBER,
        MEDICARE_PART_A_IND,
        MEDICARE_PART_B_IND,
        INSURANCE_DATA_LAST_EDIT_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        PRE_CERTIFICATION_PENALTY_IND,
        RECORD_MODIFIED_COUNT,
        INSURANCE_DATA_LAST_EDIT_USER,
        STD_INSTITUTION_ID,
        SITE_UPLOAD_STATUS_TYPE_ID,
        SITE_NO_UPLOAD_REASON_TYPE_ID,
        INSURANCE_PLAN_TYPE_ID,
        PRECRTFN_REQD_IND,
        DEDUCTIBLE_AMOUNT,
        PERCENTAGE_PAYABLE,
        FILING_TIME_LIMIT,
        MEDICARE_PART_A_EFF_DATE_TXT,
        MEDICARE_PART_B_EFF_DATE_TXT,
        TRANSACTION_TYPE_CODE
          )
        values
        (
        INSURANCE_H_S.nextval,
        :old.INSURANCE_ID,
        :old.PERSON_ID,
        :old.INSURANCE_RPT_SRC_TYPE_ID,
        :old.POLICY_HOLDER_TYPE_ID,
        :old.INSURANCE_MAPPING_TYPE_CODE,
        :old.INSURANCE_COMPANY_NAME,
        :old.POLICY_HOLDER_SSN,
        :old.POLICY_HOLDER_NAME,
        :old.POLICY_HOLDER_BIRTH_DATE,
        :old.POLICY_NUMBER,
        :old.POLICY_EFFECTIVE_DATE_TXT,
        :old.POLICY_EXPIRATION_DATE_TXT,
        :old.GROUP_NAME,
        :old.GROUP_NUMBER,
        :old.NAME_ON_MEDICARE_CARD,
        :old.MEDICARE_CLAIM_NUMBER,
        :old.MEDICARE_PART_A_IND,
        :old.MEDICARE_PART_B_IND,
        :old.INSURANCE_DATA_LAST_EDIT_DATE,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.PRE_CERTIFICATION_PENALTY_IND,
        :old.RECORD_MODIFIED_COUNT,
        :old.INSURANCE_DATA_LAST_EDIT_USER,
        :old.STD_INSTITUTION_ID,
        :old.SITE_UPLOAD_STATUS_TYPE_ID,
        :old.SITE_NO_UPLOAD_REASON_TYPE_ID,
        :old.INSURANCE_PLAN_TYPE_ID,
        :old.PRECRTFN_REQD_IND,
        :old.DEDUCTIBLE_AMOUNT,
        :old.PERCENTAGE_PAYABLE,
        :old.FILING_TIME_LIMIT,
        :old.MEDICARE_PART_A_EFF_DATE_TXT,
        :old.MEDICARE_PART_B_EFF_DATE_TXT,
        'D'
        );

    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;


        insert into INSURANCE_H
        (
        INSURANCE_H_ID,
        INSURANCE_ID,
        PERSON_ID,
        INSURANCE_RPT_SRC_TYPE_ID,
        POLICY_HOLDER_TYPE_ID,
        INSURANCE_MAPPING_TYPE_CODE,
        INSURANCE_COMPANY_NAME,
        POLICY_HOLDER_SSN,
        POLICY_HOLDER_NAME,
        POLICY_HOLDER_BIRTH_DATE,
        POLICY_NUMBER,
        POLICY_EFFECTIVE_DATE_TXT,
        POLICY_EXPIRATION_DATE_TXT,
        GROUP_NAME,
        GROUP_NUMBER,
        NAME_ON_MEDICARE_CARD,
        MEDICARE_CLAIM_NUMBER,
        MEDICARE_PART_A_IND,
        MEDICARE_PART_B_IND,
        INSURANCE_DATA_LAST_EDIT_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        PRE_CERTIFICATION_PENALTY_IND,
        RECORD_MODIFIED_COUNT,
        INSURANCE_DATA_LAST_EDIT_USER,
        STD_INSTITUTION_ID,
        SITE_UPLOAD_STATUS_TYPE_ID,
        SITE_NO_UPLOAD_REASON_TYPE_ID,
        INSURANCE_PLAN_TYPE_ID,
        PRECRTFN_REQD_IND,
        DEDUCTIBLE_AMOUNT,
        PERCENTAGE_PAYABLE,
        FILING_TIME_LIMIT,
        MEDICARE_PART_A_EFF_DATE_TXT,
        MEDICARE_PART_B_EFF_DATE_TXT,
        TRANSACTION_TYPE_CODE
          )
        values
        (
        INSURANCE_H_S.nextval,
        :new.INSURANCE_ID,
        :new.PERSON_ID,
        :new.INSURANCE_RPT_SRC_TYPE_ID,
        :new.POLICY_HOLDER_TYPE_ID,
        :new.INSURANCE_MAPPING_TYPE_CODE,
        :new.INSURANCE_COMPANY_NAME,
        :new.POLICY_HOLDER_SSN,
        :new.POLICY_HOLDER_NAME,
        :new.POLICY_HOLDER_BIRTH_DATE,
        :new.POLICY_NUMBER,
        :new.POLICY_EFFECTIVE_DATE_TXT,
        :new.POLICY_EXPIRATION_DATE_TXT,
        :new.GROUP_NAME,
        :new.GROUP_NUMBER,
        :new.NAME_ON_MEDICARE_CARD,
        :new.MEDICARE_CLAIM_NUMBER,
        :new.MEDICARE_PART_A_IND,
        :new.MEDICARE_PART_B_IND,
        :new.INSURANCE_DATA_LAST_EDIT_DATE,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.PRE_CERTIFICATION_PENALTY_IND,
        :new.RECORD_MODIFIED_COUNT,
        :new.INSURANCE_DATA_LAST_EDIT_USER,
        :new.STD_INSTITUTION_ID,
        :new.SITE_UPLOAD_STATUS_TYPE_ID,
        :new.SITE_NO_UPLOAD_REASON_TYPE_ID,
        :new.INSURANCE_PLAN_TYPE_ID,
        :new.PRECRTFN_REQD_IND,
        :new.DEDUCTIBLE_AMOUNT,
        :new.PERCENTAGE_PAYABLE,
        :new.FILING_TIME_LIMIT,
        :new.MEDICARE_PART_A_EFF_DATE_TXT,
        :new.MEDICARE_PART_B_EFF_DATE_TXT,
        mDML
        );


    end if;

end  INSURANCE_audir_trgr;
/
DROP TRIGGER ADR.MANUAL_OVERRIDE_AUD_TRGR;

CREATE OR REPLACE TRIGGER ADR.MANUAL_OVERRIDE_AUD_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.MANUAL_OVERRIDE  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
        mDML := 'D';
      INSERT
        INTO ADR.MANUAL_OVERRIDE_H (MANUAL_OVERRIDE_H_ID,
                                             TRANSACTION_TYPE_CODE,
                                             MANUAL_OVERRIDE_ID,
                                             PERSON_ID,
                                             OVERRIDE_IND,
                                             MANUAL_OVERRIDE_RSN_TYPE_ID,
                                             MANUAL_RSN_COMMENTS,
                                             VCESTATUSTYPE_ID,
                                             RECORD_CREATED_BY,
                                             RECORD_CREATED_DATE,
                                             RECORD_MODIFIED_BY,
                                             RECORD_MODIFIED_DATE,
                                             RECORD_MODIFIED_COUNT,
                                             HISTORY_CREATED_DATE)
      VALUES (MANUAL_OVERRIDE_H_S.NEXTVAL,
             mDML,
             :old.MANUAL_OVERRIDE_ID,
             :old.PERSON_ID,
             :old.OVERRIDE_IND,
             :old.MANUAL_OVERRIDE_RSN_TYPE_ID,
             :old.MANUAL_RSN_COMMENTS,
             :old.VCESTATUSTYPE_ID,
             :old.RECORD_CREATED_BY,
             :old.RECORD_CREATED_DATE,
             :old.RECORD_MODIFIED_BY,
             :old.RECORD_MODIFIED_DATE,
             :old.RECORD_MODIFIED_COUNT,
             SYSDATE);
    ELSE

      IF UPDATING THEN
        mDML := 'U';
      ELSE
        mDML := 'I';
      END IF;

     INSERT INTO ADR.MANUAL_OVERRIDE_H (MANUAL_OVERRIDE_H_ID,
                                            TRANSACTION_TYPE_CODE,
                                            MANUAL_OVERRIDE_ID,
                                            PERSON_ID,
                                            OVERRIDE_IND,
                                            MANUAL_OVERRIDE_RSN_TYPE_ID,
                                            MANUAL_RSN_COMMENTS,
                                            VCESTATUSTYPE_ID,
                                            RECORD_CREATED_BY,
                                            RECORD_CREATED_DATE,
                                            RECORD_MODIFIED_BY,
                                            RECORD_MODIFIED_DATE,
                                            RECORD_MODIFIED_COUNT,
                                            HISTORY_CREATED_DATE)
     VALUES (MANUAL_OVERRIDE_H_S.NEXTVAL,
             mDML,
             :new.MANUAL_OVERRIDE_ID,
             :new.PERSON_ID,
             :new.OVERRIDE_IND,
             :new.MANUAL_OVERRIDE_RSN_TYPE_ID,
             :new.MANUAL_RSN_COMMENTS,
             :new.VCESTATUSTYPE_ID,
             :new.RECORD_CREATED_BY,
             :new.RECORD_CREATED_DATE,
             :new.RECORD_MODIFIED_BY,
             :new.RECORD_MODIFIED_DATE,
             :new.RECORD_MODIFIED_COUNT,
             SYSDATE);
    END IF;
END MANUAL_OVERRIDE_AUD_TRGR;
/
DROP TRIGGER ADR.MEDICAID_FACTOR_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.MEDICAID_FACTOR_AUDIR_TRGR
after Update or Delete or Insert
on ADR.MEDICAID_FACTOR
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into MEDICAID_FACTOR_H
		(
		MEDICAID_FACTOR_H_ID,
		MEDICAID_FACTOR_ID,
		PERSON_ID,
		MEDICAID_ELIGIBILITY_IND,
		MEDICAID_LAST_EDIT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MEDICAID_FACTOR_H_S.nextval,
		:old.MEDICAID_FACTOR_ID,
		:old.PERSON_ID,
		:old.MEDICAID_ELIGIBILITY_IND,
		:old.MEDICAID_LAST_EDIT_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into MEDICAID_FACTOR_H
		(
		MEDICAID_FACTOR_H_ID,
		MEDICAID_FACTOR_ID,
		PERSON_ID,
		MEDICAID_ELIGIBILITY_IND,
		MEDICAID_LAST_EDIT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MEDICAID_FACTOR_H_S.nextval,
		:new.MEDICAID_FACTOR_ID,
		:new.PERSON_ID,
		:new.MEDICAID_ELIGIBILITY_IND,
		:new.MEDICAID_LAST_EDIT_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  MEDICAID_FACTOR_audir_trgr;
/
DROP TRIGGER ADR.MILITARY_FUT_DIS_AUDIT_TRGR;

CREATE OR REPLACE TRIGGER ADR.MILITARY_FUT_DIS_AUDIT_TRGR
    AFTER UPDATE OR DELETE OR INSERT OF FUTURE_DISCHARGE_DATE
    ON ADR.MILITARY_FUTURE_DISCHARGE
    FOR EACH ROW
DECLARE
    mDML   CHAR (1) := 'D';
BEGIN
    IF DELETING
    THEN
        INSERT
          INTO ADR.MILITARY_FUTURE_DISCHARGE_H (MILITARY_FUTURE_DISCHARGE_H_ID,
                                                MILITARY_FUTURE_DISCHARGE_ID,
                                                FUTURE_DISCHARGE_DATE,
                                                FUTURE_DISCHARGE_SRC_TYPE_ID,
                                                OTHER_EXPLANATION,
                                                SERVICE_BRANCH_TYPE_ID,
                                                SERVICE_ENTRY_DATE,
                                                SITE_OF_CHANGE,
                                                SOURCE_ID,
                                                MILITARY_SERVICE_NUMBER,
                                                TRANSACTION_TYPE_CODE,
                                                RECORD_CREATED_BY,
                                                RECORD_CREATED_DATE,
                                                RECORD_MODIFIED_BY,
                                                RECORD_MODIFIED_DATE,
                                                MILITARY_SERVICE_ID,
                                                RECORD_MODIFIED_COUNT)
        VALUES (ADR.MILITARY_FUTURE_DIS_H_S.NEXTVAL,
                :old.MILITARY_FUTURE_DISCHARGE_ID,
                :old.FUTURE_DISCHARGE_DATE,
                :old.FUTURE_DISCHARGE_SRC_TYPE_ID,
                :old.OTHER_EXPLANATION,
                :old.SERVICE_BRANCH_TYPE_ID,
                :old.SERVICE_ENTRY_DATE,
                :old.SITE_OF_CHANGE,
                :old.SOURCE_ID,
                :old.MILITARY_SERVICE_NUMBER,
                mDML,
                :old.RECORD_CREATED_BY,
                :old.RECORD_CREATED_DATE,
                :old.RECORD_MODIFIED_BY,
                :old.RECORD_MODIFIED_DATE,
                :old.MILITARY_SERVICE_ID,
                :old.RECORD_MODIFIED_COUNT);
    ELSE
        IF UPDATING
        THEN
            mDML := 'U';
        ELSE
            mDML := 'I';
        END IF;

        INSERT
          INTO ADR.MILITARY_FUTURE_DISCHARGE_H (MILITARY_FUTURE_DISCHARGE_H_ID,
                                                MILITARY_FUTURE_DISCHARGE_ID,
                                                FUTURE_DISCHARGE_DATE,
                                                FUTURE_DISCHARGE_SRC_TYPE_ID,
                                                OTHER_EXPLANATION,
                                                SERVICE_BRANCH_TYPE_ID,
                                                SERVICE_ENTRY_DATE,
                                                SITE_OF_CHANGE,
                                                SOURCE_ID,
                                                MILITARY_SERVICE_NUMBER,
                                                TRANSACTION_TYPE_CODE,
                                                RECORD_CREATED_BY,
                                                RECORD_CREATED_DATE,
                                                RECORD_MODIFIED_BY,
                                                RECORD_MODIFIED_DATE,
                                                MILITARY_SERVICE_ID,
                                                RECORD_MODIFIED_COUNT)
        VALUES (ADR.MILITARY_FUTURE_DIS_H_S.NEXTVAL,
                :new.MILITARY_FUTURE_DISCHARGE_ID,
                :new.FUTURE_DISCHARGE_DATE,
                :new.FUTURE_DISCHARGE_SRC_TYPE_ID,
                :new.OTHER_EXPLANATION,
                :new.SERVICE_BRANCH_TYPE_ID,
                :new.SERVICE_ENTRY_DATE,
                :new.SITE_OF_CHANGE,
                :new.SOURCE_ID,
                :new.MILITARY_SERVICE_NUMBER,
                mDML,
                :new.RECORD_CREATED_BY,
                :new.RECORD_CREATED_DATE,
                :new.RECORD_MODIFIED_BY,
                :new.RECORD_MODIFIED_DATE,
                :new.MILITARY_SERVICE_ID,
                :new.RECORD_MODIFIED_COUNT + 1);
    END IF;
END MILITARY_FUT_DIS_AUDIT_TRGR;
/
DROP TRIGGER ADR.MILITARY_SERV_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.MILITARY_SERV_AUDIR_TRGR
AFTER INSERT OR UPDATE OR DELETE ON ADR.MILITARY_SERVICE FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into MILITARY_SERVICE_H
		(
		MILITARY_SERVICE_H_ID,
		MILITARY_SERVICE_ID,
		PERSON_ID,
		STD_PERIODOFSERVICE_ID,
		FILIPINO_VET_DOC_TYPE_ID,
		STD_INSTITUTION_ID,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MILITARY_SERVICE_H_S.nextval,
		:old.MILITARY_SERVICE_ID,
		:old.PERSON_ID,
		:old.STD_PERIODOFSERVICE_ID,
		:old.FILIPINO_VET_DOC_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into MILITARY_SERVICE_H
		(
		MILITARY_SERVICE_H_ID,
		MILITARY_SERVICE_ID,
		PERSON_ID,
		STD_PERIODOFSERVICE_ID,
		FILIPINO_VET_DOC_TYPE_ID,
		STD_INSTITUTION_ID,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MILITARY_SERVICE_H_S.nextval,
		:new.MILITARY_SERVICE_ID,
		:new.PERSON_ID,
		:new.STD_PERIODOFSERVICE_ID,
		:new.FILIPINO_VET_DOC_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		 mDML
		);
	end if;

end  MILITARY_SERV_audir_trgr;
/
DROP TRIGGER ADR.MILITARY_SERV_EPIS_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.MILITARY_SERV_EPIS_AUDIR_TRGR
   AFTER INSERT OR UPDATE OR DELETE
   ON ADR.MILITARY_SERVICE_EPISODE
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      INSERT INTO MILITARY_SERVICE_EPISODE_H (MILITARY_SERVICE_EPISODE_H_ID,
                                              MILITARY_SERVICE_EPISODE_ID,
                                              MILITARY_SERVICE_ID,
                                              SERVICE_BRANCH_TYPE_ID,
                                              SERVICE_DISCHARGE_TYPE_ID,
                                              SERVICECOMPONENTTYPE_ID,
                                              MILITARY_SERVICE_NUMBER,
                                              SERVICE_ENTRY_DATE_TXT,
                                              SERVICE_SEPARATION_DATE_TXT,
                                              RECORD_CREATED_BY,
                                              RECORD_CREATED_DATE,
                                              RECORD_MODIFIED_BY,
                                              RECORD_MODIFIED_DATE,
                                              RECORD_MODIFIED_COUNT,
                                              TRANSACTION_TYPE_CODE,
                                              NARRATIVE_REASON_TYPE_ID,
                                              NAR_RSN_SEP_SRC,
                                              PAY_PLAN_TYPE_ID)
           VALUES (MILITARY_SERVICE_EPISODE_H_S.NEXTVAL,
                   :old.MILITARY_SERVICE_EPISODE_ID,
                   :old.MILITARY_SERVICE_ID,
                   :old.SERVICE_BRANCH_TYPE_ID,
                   :old.SERVICE_DISCHARGE_TYPE_ID,
                   :old.SERVICECOMPONENTTYPE_ID,
                   :old.MILITARY_SERVICE_NUMBER,
                   :old.SERVICE_ENTRY_DATE_TXT,
                   :old.SERVICE_SEPARATION_DATE_TXT,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   'D',
                   :old.NARRATIVE_REASON_TYPE_ID,
                   :old.NAR_RSN_SEP_SRC,
                   :old.PAY_PLAN_TYPE_ID);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO MILITARY_SERVICE_EPISODE_H (MILITARY_SERVICE_EPISODE_H_ID,
                                              MILITARY_SERVICE_EPISODE_ID,
                                              MILITARY_SERVICE_ID,
                                              SERVICE_BRANCH_TYPE_ID,
                                              SERVICE_DISCHARGE_TYPE_ID,
                                              SERVICECOMPONENTTYPE_ID,
                                              MILITARY_SERVICE_NUMBER,
                                              SERVICE_ENTRY_DATE_TXT,
                                              SERVICE_SEPARATION_DATE_TXT,
                                              RECORD_CREATED_BY,
                                              RECORD_CREATED_DATE,
                                              RECORD_MODIFIED_BY,
                                              RECORD_MODIFIED_DATE,
                                              RECORD_MODIFIED_COUNT,
                                              TRANSACTION_TYPE_CODE,
                                              NARRATIVE_REASON_TYPE_ID,
                                              NAR_RSN_SEP_SRC,
                                              PAY_PLAN_TYPE_ID)
           VALUES (MILITARY_SERVICE_EPISODE_H_S.NEXTVAL,
                   :new.MILITARY_SERVICE_EPISODE_ID,
                   :new.MILITARY_SERVICE_ID,
                   :new.SERVICE_BRANCH_TYPE_ID,
                   :new.SERVICE_DISCHARGE_TYPE_ID,
                   :new.SERVICECOMPONENTTYPE_ID,
                   :new.MILITARY_SERVICE_NUMBER,
                   :new.SERVICE_ENTRY_DATE_TXT,
                   :new.SERVICE_SEPARATION_DATE_TXT,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   mDML,
                   :new.NARRATIVE_REASON_TYPE_ID,
                   :new.NAR_RSN_SEP_SRC,
                   :new.PAY_PLAN_TYPE_ID);
   END IF;
END MILITARY_SERV_EPIS_audir_trgr;
/
DROP TRIGGER ADR.MOH_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.MOH_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.MEDAL_OF_HONOR
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into MEDAL_OF_HONOR_H
        (
        MEDAL_OF_HONOR_H_ID,
        MEDAL_OF_HONOR_ID,
        PERSON_ID,
        MH_INDICATOR,
        MH_STATUS_UPDATE_DATE,
        STD_DECORATIONSTATUS_ID,
        DOCUMENT_RECEIPT_DATE,
        STD_DECORATIONDOCUMENT_ID,
        STD_MHDATASOURCE_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE,
        AWARD_DATE
        )
        values
        (
        MEDAL_OF_HONOR_H_S.nextval,
        :old.MEDAL_OF_HONOR_ID,
        :old.PERSON_ID,
        :old.MH_INDICATOR,
        :old.MH_STATUS_UPDATE_DATE,
        :old.STD_DECORATIONSTATUS_ID,
        :old.DOCUMENT_RECEIPT_DATE,
        :old.STD_DECORATIONDOCUMENT_ID,
        :old.STD_MHDATASOURCE_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D',
        :old.AWARD_DATE
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into MEDAL_OF_HONOR_H
        (
        MEDAL_OF_HONOR_H_ID,
        MEDAL_OF_HONOR_ID,
        PERSON_ID,
        MH_INDICATOR,
        MH_STATUS_UPDATE_DATE,
        STD_DECORATIONSTATUS_ID,
        DOCUMENT_RECEIPT_DATE,
        STD_DECORATIONDOCUMENT_ID,
        STD_MHDATASOURCE_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE,
        AWARD_DATE
        )
        values
        (
        MEDAL_OF_HONOR_H_S.nextval,
        :new.MEDAL_OF_HONOR_ID,
        :new.PERSON_ID,
        :new.MH_INDICATOR,
        :new.MH_STATUS_UPDATE_DATE,
        :new.STD_DECORATIONSTATUS_ID,
        :new.DOCUMENT_RECEIPT_DATE,
        :new.STD_DECORATIONDOCUMENT_ID,
        :new.STD_MHDATASOURCE_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML,
        :new.AWARD_DATE
        );
    end if;

end MOH_AUDIR_TRGR;
/
DROP TRIGGER ADR.MONETARY_BENF_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.MONETARY_BENF_AUDIR_TRGR
after Update or Delete or Insert
on ADR.MONETARY_BENEFIT
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into MONETARY_BENEFIT_H
		(
		MONETARY_BENEFIT_H_ID,
		MONETARY_BENEFIT_ID,
		PERSON_ID,
		MONETARY_BENEFIT_AWARD_AMOUNT,
		VERIFIED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MONETARY_BENEFIT_H_S.nextval,
		:old.MONETARY_BENEFIT_ID,
		:old.PERSON_ID,
		:old.MONETARY_BENEFIT_AWARD_AMOUNT,
		:old.VERIFIED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into MONETARY_BENEFIT_H
		(
		MONETARY_BENEFIT_H_ID,
		MONETARY_BENEFIT_ID,
		PERSON_ID,
		MONETARY_BENEFIT_AWARD_AMOUNT,
		VERIFIED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MONETARY_BENEFIT_H_S.nextval,
		:new.MONETARY_BENEFIT_ID,
		:new.PERSON_ID,
		:new.MONETARY_BENEFIT_AWARD_AMOUNT,
		:new.VERIFIED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end  MONETARY_BENF_audir_trgr;
/
DROP TRIGGER ADR.MONETARY_BENF_DEF_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.MONETARY_BENF_DEF_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."MONETARY_BENEFIT_DETAIL" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into MONETARY_BENEFIT_DETAIL_H
		(
		MONETARY_BENEFIT_DETAIL_H_ID,
		MONETARY_BENEFIT_DETAIL_ID,
		MONETARY_BENEFIT_ID,
		MONETARY_BENEFIT_TYPE_ID,
		MONETARY_BENEFIT_STDYESNO_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MONETARY_BENEFIT_DETAIL_H_S.nextval,
		:old.MONETARY_BENEFIT_DETAIL_ID,
		:old.MONETARY_BENEFIT_ID,
		:old.MONETARY_BENEFIT_TYPE_ID,
		:old.MONETARY_BENEFIT_STDYESNO_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into MONETARY_BENEFIT_DETAIL_H
		(
		MONETARY_BENEFIT_DETAIL_H_ID,
		MONETARY_BENEFIT_DETAIL_ID,
		MONETARY_BENEFIT_ID,
		MONETARY_BENEFIT_TYPE_ID,
		MONETARY_BENEFIT_STDYESNO_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MONETARY_BENEFIT_DETAIL_H_S.nextval,
		:new.MONETARY_BENEFIT_DETAIL_ID,
		:new.MONETARY_BENEFIT_ID,
		:new.MONETARY_BENEFIT_TYPE_ID,
		:new.MONETARY_BENEFIT_STDYESNO_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  MONETARY_BENF_DEF_audir_trgr;
/
DROP TRIGGER ADR.PAT_PROV_ASSIGN_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PAT_PROV_ASSIGN_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."PATIENT_PROVIDER_ASSIGNMENT" FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into PATIENT_PROVIDER_ASSIGNMENT_H
        (
        PATIENT_PROVIDER_ASSIGN_H_ID,
        PATIENT_PROVIDER_ASSIGNMENT_ID,
        HEALTH_CARE_PROVIDER_ID,
        PERSON_ID,
        STD_TEAM_PURPOSE_ID,
        STD_INSTITUTION_ID,
        TEAM_ID,
        TEAM_NAME,
        DATE_ASSIGNED,
        DATE_UNASSIGNED,
        PATIENT_IEN,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PATIENT_PROV_ASSIGN_H_S.nextval,
        :old.PATIENT_PROVIDER_ASSIGNMENT_ID,
        :old.HEALTH_CARE_PROVIDER_ID,
        :old.PERSON_ID,
        :old.STD_TEAM_PURPOSE_ID,
        :old.STD_INSTITUTION_ID,
        :old.TEAM_ID,
        :old.TEAM_NAME,
        :old.DATE_ASSIGNED,
        :old.DATE_UNASSIGNED,
        :old.PATIENT_IEN,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into PATIENT_PROVIDER_ASSIGNMENT_H
        (
        PATIENT_PROVIDER_ASSIGN_H_ID,
        PATIENT_PROVIDER_ASSIGNMENT_ID,
        HEALTH_CARE_PROVIDER_ID,
        PERSON_ID,
        STD_TEAM_PURPOSE_ID,
        STD_INSTITUTION_ID,
        TEAM_ID,
        TEAM_NAME,
        DATE_ASSIGNED,
        DATE_UNASSIGNED,
        PATIENT_IEN,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PATIENT_PROV_ASSIGN_H_S.nextval,
        :new.PATIENT_PROVIDER_ASSIGNMENT_ID,
        :new.HEALTH_CARE_PROVIDER_ID,
        :new.PERSON_ID,
        :new.STD_TEAM_PURPOSE_ID,
        :new.STD_INSTITUTION_ID,
        :new.TEAM_ID,
        :new.TEAM_NAME,
        :new.DATE_ASSIGNED,
        :new.DATE_UNASSIGNED,
        :new.PATIENT_IEN,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end PAT_PROV_ASSIGN_AUDIR_TRGR;
/
DROP TRIGGER ADR.PENSION_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PENSION_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.PENSION
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into PENSION_H
        (
        PENSION_H_ID,
        PENSION_ID,
        MONETARY_BENEFIT_DETAIL_ID,
        PENSION_AWARD_REASON_ID,
        PENSION_AWARD_EFFECTIVE_DATE,
        PENSION_AWARD_TERMINATION_DATE,
        PENSION_AWARD_TERMINATION_ID1,
        PENSION_AWARD_TERMINATION_ID2,
        PENSION_AWARD_TERMINATION_ID3,
        PENSION_AWARD_TERMINATION_ID4,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PENSION_H_S.nextval,
        :old.PENSION_ID,
        :old.MONETARY_BENEFIT_DETAIL_ID,
        :old.PENSION_AWARD_REASON_ID,
        :old.PENSION_AWARD_EFFECTIVE_DATE,
        :old.PENSION_AWARD_TERMINATION_DATE,
        :old.PENSION_AWARD_TERMINATION_ID1,
        :old.PENSION_AWARD_TERMINATION_ID2,
        :old.PENSION_AWARD_TERMINATION_ID3,
        :old.PENSION_AWARD_TERMINATION_ID4,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into PENSION_H
        (
        PENSION_H_ID,
        PENSION_ID,
        MONETARY_BENEFIT_DETAIL_ID,
        PENSION_AWARD_REASON_ID,
        PENSION_AWARD_EFFECTIVE_DATE,
        PENSION_AWARD_TERMINATION_DATE,
        PENSION_AWARD_TERMINATION_ID1,
        PENSION_AWARD_TERMINATION_ID2,
        PENSION_AWARD_TERMINATION_ID3,
        PENSION_AWARD_TERMINATION_ID4,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PENSION_H_S.nextval,
        :new.PENSION_ID,
        :new.MONETARY_BENEFIT_DETAIL_ID,
        :new.PENSION_AWARD_REASON_ID,
        :new.PENSION_AWARD_EFFECTIVE_DATE,
        :new.PENSION_AWARD_TERMINATION_DATE,
        :new.PENSION_AWARD_TERMINATION_ID1,
        :new.PENSION_AWARD_TERMINATION_ID2,
        :new.PENSION_AWARD_TERMINATION_ID3,
        :new.PENSION_AWARD_TERMINATION_ID4,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end PENSION_audir_trgr;
/
DROP TRIGGER ADR.PERMISSION_SET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PERMISSION_SET_audir_trgr
after Update or Delete or Insert
ON ADR.PERMISSION_SET
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERMISSION_SET_H
		(
		PERMISSION_SET_H_ID,
		PERMISSION_SET_ID,
		NAME,
		DESCRIPTION,
		ACTIVE_DATE,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMISSION_SET_H_S.nextval,
		:old.PERMISSION_SET_ID,
		:old.NAME,
		:old.DESCRIPTION,
		:old.ACTIVE_DATE,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERMISSION_SET_H
		(
		PERMISSION_SET_H_ID,
		PERMISSION_SET_ID,
		NAME,
		DESCRIPTION,
		ACTIVE_DATE,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMISSION_SET_H_S.nextval,
		:new.PERMISSION_SET_ID,
		:new.NAME,
		:new.DESCRIPTION,
		:new.ACTIVE_DATE,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PERMISSION_SET_audir_trgr;
/
DROP TRIGGER ADR.PERM_SET_PERM_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PERM_SET_PERM_audir_trgr
after Update or Delete or Insert
ON ADR.PERMISSION_SET_PERMISSIONS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERMISSION_SET_PERMISSIONS_H
		(
		PERM_SET_PERMISSIONS_H_ID,
		PERM_SET_PERMISSIONS_ID,
		PERMISSION_SET_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMSSN_SET_PERMSSNS_H_S.nextval,
		:old.PERM_SET_PERMISSIONS_ID,
		:old.PERMISSION_SET_ID,
		:old.PERMISSION_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERMISSION_SET_PERMISSIONS_H
		(
		PERM_SET_PERMISSIONS_H_ID,
		PERM_SET_PERMISSIONS_ID,
		PERMISSION_SET_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMSSN_SET_PERMSSNS_H_S.nextval,
		:new.PERM_SET_PERMISSIONS_ID,
		:new.PERMISSION_SET_ID,
		:new.PERMISSION_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PERM_SET_PERM_audir_trgr;
/
DROP TRIGGER ADR.PERSON_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PERSON_AUDIR_TRGR
    AFTER DELETE OR INSERT OR UPDATE
    ON ADR.PERSON
    REFERENCING OLD AS OLD NEW AS NEW
    FOR EACH ROW
DECLARE
    mDML   CHAR (1);
BEGIN
    IF DELETING
    THEN
        INSERT INTO person_h (PERSON_H_ID,
                              PERSON_ID,
                              VPID_ID,
                              HEC_IEN,
                              CLAIM_FOLDER_NUMBER,
                              EDUCATIONAL_DEGREE,
                              REMARKS,
                              SENSITIVITY_IND,
                              SENSITIVITY_FLAG_SET_BY,
                              SENSITIVITY_FLAG_SET_DATE,
                              VETERAN_IND,
                              DEATH_DATE_TXT,
                              DEATH_REPORTED_DATE,
                              LAZARUS_DATE_TXT,
                              USER_ENROLEE_SITE_ID,
                              USER_ENROLEE_THROUGH_YEAR,
                              DISABILITY_DISCHARGE_IND,
                              COMBAT_VET_ELIGIBILITY_END_DT,
                              RECORD_CREATED_BY,
                              RECORD_CREATED_DATE,
                              RECORD_MODIFIED_BY,
                              RECORD_MODIFIED_DATE,
                              STD_PROGRAMOFSTUDY_ID,
                              STD_MARITALSTATUS_ID,
                              STD_RELIGION_ID,
                              MILITARY_DSBLTY_RETIREMENT_IND,
                              DEATH_REPORTING_SITE_ID,
                              CLAIM_FOLDER_LOCATION_SITE_ID,
                              DEATH_NOTIFICATION_SRC_TYPE_ID,
                              VA_ASSOCIATE_TITLE,
                              VA_SIGNATURE_BLOCK_PRINT_NAME,
                              VA_SIGNATURE_BLOCK_TITLE,
                              VA_LAST_TRAINING_YEAR,
                              VAMC_MAIL_CODE,
                              VA_ROOM_NUMBER,
                              VA_TERMINATION_REASON_TEXT,
                              VA_TERMINATION_DATE,
                              RECORD_MODIFIED_COUNT,
                              VPID_VALUE,
                              PREFERRED_SITE_ID,
                              WAS_PRISONER_OF_WAR_IND,
                              APPOINTMENT_WAS_REQUESTED_IND,
                              APPOINTMENT_REQUESTED_DATE,
                              SENSITIVITY_FLAG_SET_SRC_ID,
                              SENSITIVITY_FLAG_SET_SITE_ID,
                              DEMOGRAPHIC_UPDATE_EVENT_DATE,
                              EE_MIGRATED_IND,
                              RECORD_MODIFIED_SITE_ID,
                              RECORD_MODIFIED_SRC_NAME,
                              TRANSACTION_TYPE_CODE,
                              DENTAL_CLASS2_IND,
                              DENTAL_CLS2_APP_BEF_DUE_DATE,
                              HISTORY_CREATED_DATE,
                              STD_MILITARYSVCQRYSTAT_ID,
                              VOA_IND,
                              DOD_VERIFIED_IND,
                              DEATH_REPORTED_BY,
                              MAIL_STOP_REASON,
                              STOP_COM_IND,
                              STOP_COM_RSN_TYPE_ID,
                              SUP_DOC_LOOKUP_TYPE_ID,
                              ACTIVE_DUTY_IND,
                              ACTIVE_DUTY_DATE,
                              GF_CONSIDERATION_STATUS_IND)
             VALUES (person_h_s.NEXTVAL,
                     :old.PERSON_ID,
                     :old.VPID_ID,
                     :old.HEC_IEN,
                     :old.CLAIM_FOLDER_NUMBER,
                     :old.EDUCATIONAL_DEGREE,
                     :old.REMARKS,
                     :old.SENSITIVITY_IND,
                     :old.SENSITIVITY_FLAG_SET_BY,
                     :old.SENSITIVITY_FLAG_SET_DATE,
                     :old.VETERAN_IND,
                     :old.DEATH_DATE_TXT,
                     :old.DEATH_REPORTED_DATE,
                     :old.LAZARUS_DATE_TXT,
                     :old.USER_ENROLEE_SITE_ID,
                     :old.USER_ENROLEE_THROUGH_YEAR,
                     :old.DISABILITY_DISCHARGE_IND,
                     :old.COMBAT_VET_ELIGIBILITY_END_DT,
                     :old.RECORD_CREATED_BY,
                     :old.RECORD_CREATED_DATE,
                     :old.RECORD_MODIFIED_BY,
                     :old.RECORD_MODIFIED_DATE,
                     :old.STD_PROGRAMOFSTUDY_ID,
                     :old.STD_MARITALSTATUS_ID,
                     :old.STD_RELIGION_ID,
                     :old.MILITARY_DSBLTY_RETIREMENT_IND,
                     :old.DEATH_REPORTING_SITE_ID,
                     :old.CLAIM_FOLDER_LOCATION_SITE_ID,
                     :old.DEATH_NOTIFICATION_SRC_TYPE_ID,
                     :old.VA_ASSOCIATE_TITLE,
                     :old.VA_SIGNATURE_BLOCK_PRINT_NAME,
                     :old.VA_SIGNATURE_BLOCK_TITLE,
                     :old.VA_LAST_TRAINING_YEAR,
                     :old.VAMC_MAIL_CODE,
                     :old.VA_ROOM_NUMBER,
                     :old.VA_TERMINATION_REASON_TEXT,
                     :old.VA_TERMINATION_DATE,
                     :old.RECORD_MODIFIED_COUNT,
                     :old.VPID_VALUE,
                     :old.PREFERRED_SITE_ID,
                     :old.WAS_PRISONER_OF_WAR_IND,
                     :old.APPOINTMENT_WAS_REQUESTED_IND,
                     :old.APPOINTMENT_REQUESTED_DATE,
                     :old.SENSITIVITY_FLAG_SET_SRC_ID,
                     :old.SENSITIVITY_FLAG_SET_SITE_ID,
                     :old.DEMOGRAPHIC_UPDATE_EVENT_DATE,
                     :old.EE_MIGRATED_IND,
                     :old.RECORD_MODIFIED_SITE_ID,
                     :old.RECORD_MODIFIED_SRC_NAME,
                     'D',
                     :old.DENTAL_CLASS2_IND,
                     :old.DENTAL_CLS2_APP_BEF_DUE_DATE,
                     SYSDATE,
                     :old.STD_MILITARYSVCQRYSTAT_ID,
                     :old.VOA_IND,
                     :old.DOD_VERIFIED_IND,
                     :old.DEATH_REPORTED_BY,
                     :old.MAIL_STOP_REASON,
                     :old.STOP_COM_IND,
                     :old.STOP_COM_RSN_TYPE_ID,
                     :old.SUP_DOC_LOOKUP_TYPE_ID,
                     :old.ACTIVE_DUTY_IND,
                     :old.ACTIVE_DUTY_DATE,
                     :old.GF_CONSIDERATION_STATUS_IND);
    ELSE
        IF UPDATING
        THEN
            mDML := 'U';
        ELSE
            mDML := 'I';
        END IF;

        INSERT INTO person_h (PERSON_H_ID,
                              PERSON_ID,
                              VPID_ID,
                              HEC_IEN,
                              CLAIM_FOLDER_NUMBER,
                              EDUCATIONAL_DEGREE,
                              REMARKS,
                              SENSITIVITY_IND,
                              SENSITIVITY_FLAG_SET_BY,
                              SENSITIVITY_FLAG_SET_DATE,
                              VETERAN_IND,
                              DEATH_DATE_TXT,
                              DEATH_REPORTED_DATE,
                              LAZARUS_DATE_TXT,
                              USER_ENROLEE_SITE_ID,
                              USER_ENROLEE_THROUGH_YEAR,
                              DISABILITY_DISCHARGE_IND,
                              COMBAT_VET_ELIGIBILITY_END_DT,
                              RECORD_CREATED_BY,
                              RECORD_CREATED_DATE,
                              RECORD_MODIFIED_BY,
                              RECORD_MODIFIED_DATE,
                              STD_PROGRAMOFSTUDY_ID,
                              STD_MARITALSTATUS_ID,
                              STD_RELIGION_ID,
                              MILITARY_DSBLTY_RETIREMENT_IND,
                              DEATH_REPORTING_SITE_ID,
                              CLAIM_FOLDER_LOCATION_SITE_ID,
                              DEATH_NOTIFICATION_SRC_TYPE_ID,
                              VA_ASSOCIATE_TITLE,
                              VA_SIGNATURE_BLOCK_PRINT_NAME,
                              VA_SIGNATURE_BLOCK_TITLE,
                              VA_LAST_TRAINING_YEAR,
                              VAMC_MAIL_CODE,
                              VA_ROOM_NUMBER,
                              VA_TERMINATION_REASON_TEXT,
                              VA_TERMINATION_DATE,
                              RECORD_MODIFIED_COUNT,
                              VPID_VALUE,
                              PREFERRED_SITE_ID,
                              WAS_PRISONER_OF_WAR_IND,
                              APPOINTMENT_WAS_REQUESTED_IND,
                              APPOINTMENT_REQUESTED_DATE,
                              SENSITIVITY_FLAG_SET_SRC_ID,
                              SENSITIVITY_FLAG_SET_SITE_ID,
                              DEMOGRAPHIC_UPDATE_EVENT_DATE,
                              EE_MIGRATED_IND,
                              RECORD_MODIFIED_SITE_ID,
                              RECORD_MODIFIED_SRC_NAME,
                              TRANSACTION_TYPE_CODE,
                              DENTAL_CLASS2_IND,
                              DENTAL_CLS2_APP_BEF_DUE_DATE,
                              HISTORY_CREATED_DATE,
                              STD_MILITARYSVCQRYSTAT_ID,
                              VOA_IND,
                              DOD_VERIFIED_IND,
                              DEATH_REPORTED_BY,
                              MAIL_STOP_REASON,
                              STOP_COM_IND,
                              STOP_COM_RSN_TYPE_ID,
                              SUP_DOC_LOOKUP_TYPE_ID,
                              ACTIVE_DUTY_IND,
                              ACTIVE_DUTY_DATE,
                              GF_CONSIDERATION_STATUS_IND)
             VALUES (person_h_s.NEXTVAL,
                     :new.PERSON_ID,
                     :new.VPID_ID,
                     :new.HEC_IEN,
                     :new.CLAIM_FOLDER_NUMBER,
                     :new.EDUCATIONAL_DEGREE,
                     :new.REMARKS,
                     :new.SENSITIVITY_IND,
                     :new.SENSITIVITY_FLAG_SET_BY,
                     :new.SENSITIVITY_FLAG_SET_DATE,
                     :new.VETERAN_IND,
                     :new.DEATH_DATE_TXT,
                     :new.DEATH_REPORTED_DATE,
                     :new.LAZARUS_DATE_TXT,
                     :new.USER_ENROLEE_SITE_ID,
                     :new.USER_ENROLEE_THROUGH_YEAR,
                     :new.DISABILITY_DISCHARGE_IND,
                     :new.COMBAT_VET_ELIGIBILITY_END_DT,
                     :new.RECORD_CREATED_BY,
                     :new.RECORD_CREATED_DATE,
                     :new.RECORD_MODIFIED_BY,
                     :new.RECORD_MODIFIED_DATE,
                     :new.STD_PROGRAMOFSTUDY_ID,
                     :new.STD_MARITALSTATUS_ID,
                     :new.STD_RELIGION_ID,
                     :new.MILITARY_DSBLTY_RETIREMENT_IND,
                     :new.DEATH_REPORTING_SITE_ID,
                     :new.CLAIM_FOLDER_LOCATION_SITE_ID,
                     :new.DEATH_NOTIFICATION_SRC_TYPE_ID,
                     :new.VA_ASSOCIATE_TITLE,
                     :new.VA_SIGNATURE_BLOCK_PRINT_NAME,
                     :new.VA_SIGNATURE_BLOCK_TITLE,
                     :new.VA_LAST_TRAINING_YEAR,
                     :new.VAMC_MAIL_CODE,
                     :new.VA_ROOM_NUMBER,
                     :new.VA_TERMINATION_REASON_TEXT,
                     :new.VA_TERMINATION_DATE,
                     :new.RECORD_MODIFIED_COUNT,
                     :new.VPID_VALUE,
                     :new.PREFERRED_SITE_ID,
                     :new.WAS_PRISONER_OF_WAR_IND,
                     :new.APPOINTMENT_WAS_REQUESTED_IND,
                     :new.APPOINTMENT_REQUESTED_DATE,
                     :new.SENSITIVITY_FLAG_SET_SRC_ID,
                     :new.SENSITIVITY_FLAG_SET_SITE_ID,
                     :new.DEMOGRAPHIC_UPDATE_EVENT_DATE,
                     :new.EE_MIGRATED_IND,
                     :new.RECORD_MODIFIED_SITE_ID,
                     :new.RECORD_MODIFIED_SRC_NAME,
                     mDML,
                     :new.DENTAL_CLASS2_IND,
                     :new.DENTAL_CLS2_APP_BEF_DUE_DATE,
                     SYSDATE,
                     :new.STD_MILITARYSVCQRYSTAT_ID,
                     :new.VOA_IND,
                     :new.DOD_VERIFIED_IND,
                     :new.DEATH_REPORTED_BY,
                     :new.MAIL_STOP_REASON,
                     :new.STOP_COM_IND,
                     :new.STOP_COM_RSN_TYPE_ID,
                     :new.SUP_DOC_LOOKUP_TYPE_ID,
                     :new.ACTIVE_DUTY_IND,
                     :new.ACTIVE_DUTY_DATE,
                     :new.GF_CONSIDERATION_STATUS_IND);
    END IF;
END person_audir_trgr;
/
DROP TRIGGER ADR.PERSON_CONTACT_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PERSON_CONTACT_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."PERSON_CONTACT" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERSON_CONTACT_H
		(
		PERSON_CONTACT_H_ID,
		PERSON_CONTACT_ID,
		PERSON_ID,
		PERSON_CONTACT_TYPE_ID,
		CONTACT_RELATIONSHIP_TEXT,
		ORGANIZATION_NAME,
		PREFIX,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		SUFFIX,
		ADDRESS_LINE1,
		ADDRESS_LINE2,
		ADDRESS_LINE3,
		CITY,
		STATE_CODE,
		COUNTY_CODE,
		PROVINCE_CODE,
		POSTAL_CODE,
		ZIP_PLUS_4,
		COUNTRY_CODE,
		HOME_PHONE,
		WORK_PHONE,
		EMAIL_ADDRESS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		HOME_PHONE_UPDATE_DATE,
		WORK_PHONE_UPDATE_DATE,
		ZIP_CODE,
		CONTACT_DATA_LAST_EDIT_DATE,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		deactivation_date,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERSON_CONTACT_H_S.nextval,
		:old.PERSON_CONTACT_ID,
		:old.PERSON_ID,
		:old.PERSON_CONTACT_TYPE_ID,
		:old.CONTACT_RELATIONSHIP_TEXT,
		:old.ORGANIZATION_NAME,
		:old.PREFIX,
		:old.FIRST_NAME,
		:old.MIDDLE_NAME,
		:old.LAST_NAME,
		:old.SUFFIX,
		:old.ADDRESS_LINE1,
		:old.ADDRESS_LINE2,
		:old.ADDRESS_LINE3,
		:old.CITY,
		:old.STATE_CODE,
		:old.COUNTY_CODE,
		:old.PROVINCE_CODE,
		:old.POSTAL_CODE,
		:old.ZIP_PLUS_4,
		:old.COUNTRY_CODE,
		:old.HOME_PHONE,
		:old.WORK_PHONE,
		:old.EMAIL_ADDRESS,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		:old.HOME_PHONE_UPDATE_DATE,
		:old.WORK_PHONE_UPDATE_DATE,
		:old.ZIP_CODE,
		:old.CONTACT_DATA_LAST_EDIT_DATE,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		:old.deactivation_date,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERSON_CONTACT_H
		(
		PERSON_CONTACT_H_ID,
		PERSON_CONTACT_ID,
		PERSON_ID,
		PERSON_CONTACT_TYPE_ID,
		CONTACT_RELATIONSHIP_TEXT,
		ORGANIZATION_NAME,
		PREFIX,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		SUFFIX,
		ADDRESS_LINE1,
		ADDRESS_LINE2,
		ADDRESS_LINE3,
		CITY,
		STATE_CODE,
		COUNTY_CODE,
		PROVINCE_CODE,
		POSTAL_CODE,
		ZIP_PLUS_4,
		COUNTRY_CODE,
		HOME_PHONE,
		WORK_PHONE,
		EMAIL_ADDRESS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		HOME_PHONE_UPDATE_DATE,
		WORK_PHONE_UPDATE_DATE,
		ZIP_CODE,
		CONTACT_DATA_LAST_EDIT_DATE,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		deactivation_date,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERSON_CONTACT_H_S.nextval,
		:new.PERSON_CONTACT_ID,
		:new.PERSON_ID,
		:new.PERSON_CONTACT_TYPE_ID,
		:new.CONTACT_RELATIONSHIP_TEXT,
		:new.ORGANIZATION_NAME,
		:new.PREFIX,
		:new.FIRST_NAME,
		:new.MIDDLE_NAME,
		:new.LAST_NAME,
		:new.SUFFIX,
		:new.ADDRESS_LINE1,
		:new.ADDRESS_LINE2,
		:new.ADDRESS_LINE3,
		:new.CITY,
		:new.STATE_CODE,
		:new.COUNTY_CODE,
		:new.PROVINCE_CODE,
		:new.POSTAL_CODE,
		:new.ZIP_PLUS_4,
		:new.COUNTRY_CODE,
		:new.HOME_PHONE,
		:new.WORK_PHONE,
		:new.EMAIL_ADDRESS,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		:new.HOME_PHONE_UPDATE_DATE,
		:new.WORK_PHONE_UPDATE_DATE,
		:new.ZIP_CODE,
		:new.CONTACT_DATA_LAST_EDIT_DATE,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		:new.deactivation_date,
		mDML
		);
	end if;

end PERSON_CONTACT_audir_trgr;
/
DROP TRIGGER ADR.PERSON_ETHNICITY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PERSON_ETHNICITY_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PERSON_ETHNICITY for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into PERSON_ETHNICITY_H
    (
    PERSON_ETHNICITY_H_ID,
    PERSON_ETHNICITY_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_ETHNICITY_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_ETHNICITY_H_S.nextval,
    :old.PERSON_ETHNICITY_ID,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.STD_ETHNICITY_ID,
    :old.COLLECTION_METHOD_TYPE_ID,
    :old.PERSON_ID,
    :old.RECORD_MODIFIED_COUNT,
    :old.RECORD_MODIFIED_SITE_ID,
    :old.RECORD_MODIFIED_SRC_NAME,
    'D'
    );

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into PERSON_ETHNICITY_H
    (
    PERSON_ETHNICITY_H_ID,
    PERSON_ETHNICITY_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_ETHNICITY_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_ETHNICITY_H_S.nextval,
    :new.PERSON_ETHNICITY_ID,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.STD_ETHNICITY_ID,
    :new.COLLECTION_METHOD_TYPE_ID,
    :new.PERSON_ID,
    :new.RECORD_MODIFIED_COUNT,
    :new.RECORD_MODIFIED_SITE_ID,
    :new.RECORD_MODIFIED_SRC_NAME,
    mDML
    );

  end if;

end PERSON_ETHNICITY_audir_trgr;
/
DROP TRIGGER ADR.PERSON_RACE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PERSON_RACE_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PERSON_RACE for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into PERSON_RACE_H
    (
    PERSON_RACE_H_ID,
    PERSON_RACE_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_RACE_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_RACE_H_S.nextval,
    :old.PERSON_RACE_ID,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.STD_RACE_ID,
    :old.COLLECTION_METHOD_TYPE_ID,
    :old.PERSON_ID,
    :old.RECORD_MODIFIED_COUNT,
    :old.RECORD_MODIFIED_SITE_ID,
    :old.RECORD_MODIFIED_SRC_NAME,
    'D'
    );



  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into PERSON_RACE_H
    (
    PERSON_RACE_H_ID,
    PERSON_RACE_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_RACE_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_RACE_H_S.nextval,
    :new.PERSON_RACE_ID,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.STD_RACE_ID,
    :new.COLLECTION_METHOD_TYPE_ID,
    :new.PERSON_ID,
    :new.RECORD_MODIFIED_COUNT,
    :new.RECORD_MODIFIED_SITE_ID,
    :new.RECORD_MODIFIED_SRC_NAME,
    mDML
    );



  end if;

end PERSON_RACE_audir_trgr;
/
DROP TRIGGER ADR.PERSON_RELATION_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PERSON_RELATION_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PERSON_RELATION
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERSON_RELATION_H
		(
		PERSON_RELATION_H_ID,
		PERSON_RELATION_ID,
		PERSON_ID,
		STD_GENDER_ID,
		PERSON_RELATION_TYPE_ID,
		PRSN_RELATION_MAPPING_TYPE_CD,
		HEC_IEN,
		PREFIX,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		MAIDEN_NAME,
		SUFFIX,
		BIRTH_DATE_TXT,
		EDUCATIONAL_DEGREE,
		RELATION_EFFECTIVE_DATE_TXT,
		RELATION_END_DATE,
		INCAPABLE_SELF_SUPPORT_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERSON_RELATION_H_S.nextval,
		:old.PERSON_RELATION_ID,
		:old.PERSON_ID,
		:old.STD_GENDER_ID,
		:old.PERSON_RELATION_TYPE_ID,
		:old.PRSN_RELATION_MAPPING_TYPE_CD,
		:old.HEC_IEN,
		:old.PREFIX,
		:old.FIRST_NAME,
		:old.MIDDLE_NAME,
		:old.LAST_NAME,
		:old.MAIDEN_NAME,
		:old.SUFFIX,
		:old.BIRTH_DATE_TXT,
		:old.EDUCATIONAL_DEGREE,
		:old.RELATION_EFFECTIVE_DATE_TXT,
		:old.RELATION_END_DATE,
		:old.INCAPABLE_SELF_SUPPORT_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERSON_RELATION_H
		(
		PERSON_RELATION_H_ID,
		PERSON_RELATION_ID,
		PERSON_ID,
		STD_GENDER_ID,
		PERSON_RELATION_TYPE_ID,
		PRSN_RELATION_MAPPING_TYPE_CD,
		HEC_IEN,
		PREFIX,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		MAIDEN_NAME,
		SUFFIX,
		BIRTH_DATE_TXT,
		EDUCATIONAL_DEGREE,
		RELATION_EFFECTIVE_DATE_TXT,
		RELATION_END_DATE,
		INCAPABLE_SELF_SUPPORT_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERSON_RELATION_H_S.nextval,
		:new.PERSON_RELATION_ID,
		:new.PERSON_ID,
		:new.STD_GENDER_ID,
		:new.PERSON_RELATION_TYPE_ID,
		:new.PRSN_RELATION_MAPPING_TYPE_CD,
		:new.HEC_IEN,
		:new.PREFIX,
		:new.FIRST_NAME,
		:new.MIDDLE_NAME,
		:new.LAST_NAME,
		:new.MAIDEN_NAME,
		:new.SUFFIX,
		:new.BIRTH_DATE_TXT,
		:new.EDUCATIONAL_DEGREE,
		:new.RELATION_EFFECTIVE_DATE_TXT,
		:new.RELATION_END_DATE,
		:new.INCAPABLE_SELF_SUPPORT_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PERSON_RELATION_audir_trgr;
/
DROP TRIGGER ADR.PHONE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PHONE_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PHONE for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into PHONE_H
    (
    PHONE_H_ID,
    PHONE_ID  ,
    PHONE_NUMBER,
    CHANGE_EFFECTIVE_DATE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY ,
    RECORD_MODIFIED_DATE,
    INSURANCE_ID        ,
    PHONE_TYPE_ID       ,
    PERSON_ID           ,
    RECORD_MODIFIED_COUNT,
    STD_INSTITUTION_ID  ,
    PHONE_CHANGE_SOURCE_TYPE_ID,
    RECORD_MODIFIED_SRC_NAME,
    PERSON_RELATION_ID,
    TRANSACTION_TYPE_CODE,
    SITE_OF_CHANGE_ID
    )
    values
    (
    PHONE_h_s.nextval,
    :old.PHONE_ID  ,
    :old.PHONE_NUMBER,
    :old.CHANGE_EFFECTIVE_DATE,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY ,
    :old.RECORD_MODIFIED_DATE,
    :old.INSURANCE_ID        ,
    :old.PHONE_TYPE_ID       ,
    :old.PERSON_ID           ,
    :old.RECORD_MODIFIED_COUNT,
    :old.STD_INSTITUTION_ID  ,
    :old.PHONE_CHANGE_SOURCE_TYPE_ID,
    :old.RECORD_MODIFIED_SRC_NAME,
    :old.PERSON_RELATION_ID,
    'D',
    :old.SITE_OF_CHANGE_ID
    );

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;
    insert into PHONE_H
    (
    PHONE_H_ID,
    PHONE_ID  ,
    PHONE_NUMBER,
    CHANGE_EFFECTIVE_DATE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY ,
    RECORD_MODIFIED_DATE,
    INSURANCE_ID        ,
    PHONE_TYPE_ID       ,
    PERSON_ID           ,
    RECORD_MODIFIED_COUNT,
    STD_INSTITUTION_ID  ,
    PHONE_CHANGE_SOURCE_TYPE_ID,
    RECORD_MODIFIED_SRC_NAME,
    PERSON_RELATION_ID,
    TRANSACTION_TYPE_CODE,
    SITE_OF_CHANGE_ID
    )
    values
    (
    PHONE_h_s.nextval,
    :new.PHONE_ID  ,
    :new.PHONE_NUMBER,
    :new.CHANGE_EFFECTIVE_DATE,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY ,
    :new.RECORD_MODIFIED_DATE,
    :new.INSURANCE_ID        ,
    :new.PHONE_TYPE_ID       ,
    :new.PERSON_ID           ,
    :new.RECORD_MODIFIED_COUNT,
    :new.STD_INSTITUTION_ID  ,
    :new.PHONE_CHANGE_SOURCE_TYPE_ID,
    :new.RECORD_MODIFIED_SRC_NAME,
    :new.PERSON_RELATION_ID,
    mDML,
    :new.SITE_OF_CHANGE_ID
    );

  end if;

end PHONE_audir_trgr;
/
DROP TRIGGER ADR.PH_REGISTRY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PH_REGISTRY_AUDIR_TRGR
after Update or Delete or Insert
on ADR.PURPLE_HEART_REGISTRY
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PURPLE_HEART_REGISTRY_H
		(
		PURPLE_HEART_REGISTRY_H_ID,
		PURPLE_HEART_REGISTRY_ID,
		PH_STATUS_TYPE_ID,
		STD_INSTITUTION_ID,
                STD_REJECTEDREMARKS_ID,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		PH_STATUS_LAST_EDIT_USERNAME,
		PH_STATUS_LAST_EDIT_DATE,
		ASSIGNED_CONTACT_REP_USERNAME,
		PURPLE_HEART_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PURPLE_HEART_REGISTRY_H_S.nextval,
		:old.PURPLE_HEART_REGISTRY_ID,
		:old.PH_STATUS_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.STD_REJECTEDREMARKS_ID,
		:old.PERSON_ID,
		:old.REGISTRY_TRAIT_ID,
		:old.PH_STATUS_LAST_EDIT_USERNAME,
		:old.PH_STATUS_LAST_EDIT_DATE,
		:old.ASSIGNED_CONTACT_REP_USERNAME,
		:old.PURPLE_HEART_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PURPLE_HEART_REGISTRY_H
		(
		PURPLE_HEART_REGISTRY_H_ID,
		PURPLE_HEART_REGISTRY_ID,
		PH_STATUS_TYPE_ID,
		STD_INSTITUTION_ID,
		STD_REJECTEDREMARKS_ID,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		PH_STATUS_LAST_EDIT_USERNAME,
		PH_STATUS_LAST_EDIT_DATE,
		ASSIGNED_CONTACT_REP_USERNAME,
		PURPLE_HEART_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PURPLE_HEART_REGISTRY_H_S.nextval,
		:new.PURPLE_HEART_REGISTRY_ID,
		:new.PH_STATUS_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.STD_REJECTEDREMARKS_ID,
		:new.PERSON_ID,
		:new.REGISTRY_TRAIT_ID,
		:new.PH_STATUS_LAST_EDIT_USERNAME,
		:new.PH_STATUS_LAST_EDIT_DATE,
		:new.ASSIGNED_CONTACT_REP_USERNAME,
		:new.PURPLE_HEART_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end PH_REGISTRY_audir_trgr;
/
DROP TRIGGER ADR.PH_REGISTRY_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PH_REGISTRY_DET_audir_trgr
after Update or Delete or Insert
ON ADR.PH_REGISTRY_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PH_REGISTRY_DETAIL_H
		(
  		 PH_REGISTRY_DETAIL_H_ID,
 		 PH_REGISTRY_DETAIL_ID,
 		 PH_DOCUMENT_TYPE_ID,
		 PURPLE_HEART_REGISTRY_ID,
		 PH_DATA_SOURCE_TYPE_ID,
 		 PH_DOCUMENT_RECEIVED_DATE,
 		 PH_DOCUMENT_LOGIN_DATE,
 		 PH_DOCUMENT_LOGIN_USERNAME,
 		 PH_DOCUMENT_ACCEPTABLE_IND,
 		 PH_DOC_UNACCEPTABLE_REMARKS,
 		 RECORD_CREATED_BY,
 		 RECORD_CREATED_DATE,
 		 RECORD_MODIFIED_BY,
 		 RECORD_MODIFIED_DATE,
 		 RECORD_MODIFIED_COUNT,
		 TRANSACTION_TYPE_CODE
		)
		values
		(
		PH_REGISTRY_DETAIL_H_S.nextval,
		:old.PH_REGISTRY_DETAIL_ID,
		:old.PH_DOCUMENT_TYPE_ID,
		:old.PURPLE_HEART_REGISTRY_ID,
		:old.PH_DATA_SOURCE_TYPE_ID,
		:old.PH_DOCUMENT_RECEIVED_DATE,
		:old.PH_DOCUMENT_LOGIN_DATE,
		:old.PH_DOCUMENT_LOGIN_USERNAME,
		:old.PH_DOCUMENT_ACCEPTABLE_IND,
		:old.PH_DOC_UNACCEPTABLE_REMARKS,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PH_REGISTRY_DETAIL_H
		(
  		 PH_REGISTRY_DETAIL_H_ID,
 		 PH_REGISTRY_DETAIL_ID,
 		 PH_DOCUMENT_TYPE_ID,
		 PURPLE_HEART_REGISTRY_ID,
		 PH_DATA_SOURCE_TYPE_ID,
 		 PH_DOCUMENT_RECEIVED_DATE,
 		 PH_DOCUMENT_LOGIN_DATE,
 		 PH_DOCUMENT_LOGIN_USERNAME,
 		 PH_DOCUMENT_ACCEPTABLE_IND,
 		 PH_DOC_UNACCEPTABLE_REMARKS,
 		 RECORD_CREATED_BY,
 		 RECORD_CREATED_DATE,
 		 RECORD_MODIFIED_BY,
 		 RECORD_MODIFIED_DATE,
 		 RECORD_MODIFIED_COUNT,
		 TRANSACTION_TYPE_CODE
		)
		values
		(
		PH_REGISTRY_DETAIL_H_S.nextval,
		:new.PH_REGISTRY_DETAIL_ID,
		:new.PH_DOCUMENT_TYPE_ID,
		:new.PURPLE_HEART_REGISTRY_ID,
		:new.PH_DATA_SOURCE_TYPE_ID,
		:new.PH_DOCUMENT_RECEIVED_DATE,
		:new.PH_DOCUMENT_LOGIN_DATE,
		:new.PH_DOCUMENT_LOGIN_USERNAME,
		:new.PH_DOCUMENT_ACCEPTABLE_IND,
		:new.PH_DOC_UNACCEPTABLE_REMARKS,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PH_REGISTRY_DET_audir_trgr;
/
DROP TRIGGER ADR.POW_REGISTRY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.POW_REGISTRY_AUDIR_TRGR
after Update or Delete or Insert
on ADR.PRISONER_OF_WAR_REGISTRY
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PRISONER_OF_WAR_REGISTRY_H
		(
		PRISONER_OF_WAR_REGISTRY_H_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		LEGACY_ICN,
		LEGACY_USERNAME,
		LEGACY_ENTERED_DATE,
		POW_STDYESNO_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PRISONER_OF_WAR_REGISTRY_H_S.nextval,
		:old.PRISONER_OF_WAR_REGISTRY_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.PERSON_ID,
		:old.REGISTRY_TRAIT_ID,
		:old.LEGACY_ICN,
		:old.LEGACY_USERNAME,
		:old.LEGACY_ENTERED_DATE,
		:old.POW_STDYESNO_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PRISONER_OF_WAR_REGISTRY_H
		(
		PRISONER_OF_WAR_REGISTRY_H_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		LEGACY_ICN,
		LEGACY_USERNAME,
		LEGACY_ENTERED_DATE,
		POW_STDYESNO_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PRISONER_OF_WAR_REGISTRY_H_S.nextval,
		:new.PRISONER_OF_WAR_REGISTRY_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.PERSON_ID,
		:new.REGISTRY_TRAIT_ID,
		:new.LEGACY_ICN,
		:new.LEGACY_USERNAME,
		:new.LEGACY_ENTERED_DATE,
		:new.POW_STDYESNO_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end POW_REGISTRY_audir_trgr;
/
DROP TRIGGER ADR.POW_REG_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.pow_reg_det_audir_trgr
after Update or Delete or Insert
ON ADR.POW_REGISTRY_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into POW_REGISTRY_DETAIL_H
		(
		POW_REGISTRY_DETAIL_H_ID,
		POW_REGISTRY_DETAIL_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		POW_DATA_SOURCE_TYPE_ID,
		POW_DOCUMENT_TYPE_ID,
		POW_CONFINE_LOCN_TYPE_ID,
		STD_POWCASUALTYLOCATION_ID,
		POW_CAPTURE_DATE_TXT,
		POW_RELEASE_DATE_TXT,
		NUMBER_OF_DAYS_IN_CAPTIVITY,
		LEGACY_ENTERED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		POW_REGISTRY_DETAIL_H_S.nextval,
		:old.POW_REGISTRY_DETAIL_ID,
		:old.PRISONER_OF_WAR_REGISTRY_ID,
		:old.POW_DATA_SOURCE_TYPE_ID,
		:old.POW_DOCUMENT_TYPE_ID,
		:old.POW_CONFINE_LOCN_TYPE_ID,
		:old.STD_POWCASUALTYLOCATION_ID,
		:old.POW_CAPTURE_DATE_TXT,
		:old.POW_RELEASE_DATE_TXT,
		:old.NUMBER_OF_DAYS_IN_CAPTIVITY,
		:old.LEGACY_ENTERED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into POW_REGISTRY_DETAIL_H
		(
		POW_REGISTRY_DETAIL_H_ID,
		POW_REGISTRY_DETAIL_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		POW_DATA_SOURCE_TYPE_ID,
		POW_DOCUMENT_TYPE_ID,
		POW_CONFINE_LOCN_TYPE_ID,
		STD_POWCASUALTYLOCATION_ID,
		POW_CAPTURE_DATE_TXT,
		POW_RELEASE_DATE_TXT,
		NUMBER_OF_DAYS_IN_CAPTIVITY,
		LEGACY_ENTERED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		POW_REGISTRY_DETAIL_H_S.nextval,
		:new.POW_REGISTRY_DETAIL_ID,
		:new.PRISONER_OF_WAR_REGISTRY_ID,
		:new.POW_DATA_SOURCE_TYPE_ID,
		:new.POW_DOCUMENT_TYPE_ID,
		:new.POW_CONFINE_LOCN_TYPE_ID,
		:new.STD_POWCASUALTYLOCATION_ID,
		:new.POW_CAPTURE_DATE_TXT,
		:new.POW_RELEASE_DATE_TXT,
		:new.NUMBER_OF_DAYS_IN_CAPTIVITY,
		:new.LEGACY_ENTERED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end pow_reg_det_audir_trgr;
/
DROP TRIGGER ADR.PREFERRED_FACILITY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PREFERRED_FACILITY_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."PREFERRED_FACILITY" FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into PREFERRED_FACILITY_H
        (
        PREFERRED_FACILITY_H_ID,
        PREFERRED_FACILITY_ID,
        PERSON_ID,
        STD_PREFERRED_FACILITY_SRC_ID,
        STD_INSTITUTION_ID,
        ASSIGNMENT_DATE,
        UNASSIGNMENT_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PREFERRED_FACILITY_H_S.nextval,
        :old.PREFERRED_FACILITY_ID,
        :old.PERSON_ID,
        :old.STD_PREFERRED_FACILITY_SRC_ID,
        :old.STD_INSTITUTION_ID,
        :old.ASSIGNMENT_DATE,
        :old.UNASSIGNMENT_DATE,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into PREFERRED_FACILITY_H
        (
        PREFERRED_FACILITY_H_ID,
        PREFERRED_FACILITY_ID,
        PERSON_ID,
        STD_PREFERRED_FACILITY_SRC_ID,
        STD_INSTITUTION_ID,
        ASSIGNMENT_DATE,
        UNASSIGNMENT_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PREFERRED_FACILITY_H_S.nextval,
        :new.PREFERRED_FACILITY_ID,
        :new.PERSON_ID,
        :new.STD_PREFERRED_FACILITY_SRC_ID,
        :new.STD_INSTITUTION_ID,
        :new.ASSIGNMENT_DATE,
        :new.UNASSIGNMENT_DATE,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end PREFERRED_FACILITY_audir_trgr;
/
DROP TRIGGER ADR.PRSN_PREF_LANG_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.PRSN_PREF_LANG_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.PERSON_PREFERRED_LANGUAGE  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
  if DELETING then
      insert into PERSON_PREFERRED_LANGUAGE_H
      (
      PERSON_PREFERRED_LANG_H_ID,
      PERSON_PREFERRED_LANGUAGE_ID,
      PERSON_ID,
      STD_LANGUAGECODE_ID,
      LANGUAGE_ENTRY_DATE,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      HISTORY_CREATED_DATE,
      TRANSACTION_TYPE_CODE
      )
      values
      (
      PERSON_PREFERRED_LANGUAGE_H_S.nextval,
      :old.PERSON_PREFERRED_LANGUAGE_ID,
      :old.PERSON_ID,
      :old.STD_LANGUAGECODE_ID,
      :old.LANGUAGE_ENTRY_DATE,
      :old.RECORD_CREATED_BY,
      :old.RECORD_CREATED_DATE,
      :old.RECORD_MODIFIED_BY,
      :old.RECORD_MODIFIED_DATE,
      :old.RECORD_MODIFIED_COUNT,
      SYSDATE,
      'D'
      );

  else
      if UPDATING then
          mDML := 'U';
      else
          mDML := 'I';
      end if;

       insert into PERSON_PREFERRED_LANGUAGE_H
      (
      PERSON_PREFERRED_LANG_H_ID,
      PERSON_PREFERRED_LANGUAGE_ID,
      PERSON_ID,
      STD_LANGUAGECODE_ID,
      LANGUAGE_ENTRY_DATE,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      HISTORY_CREATED_DATE,
      TRANSACTION_TYPE_CODE
      )
      values
      (
      PERSON_PREFERRED_LANGUAGE_H_S.nextval,
      :new.PERSON_PREFERRED_LANGUAGE_ID,
      :new.PERSON_ID,
      :new.STD_LANGUAGECODE_ID,
      :new.LANGUAGE_ENTRY_DATE,
      :new.RECORD_CREATED_BY,
      :new.RECORD_CREATED_DATE,
      :new.RECORD_MODIFIED_BY,
      :new.RECORD_MODIFIED_DATE,
      :new.RECORD_MODIFIED_COUNT,
      SYSDATE,
      mDML
      );

  end if;

end PRSN_PREF_LANG_audir_trgr;
/
DROP TRIGGER ADR.RATED_DSBLTY_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.RATED_DSBLTY_DET_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."RATED_DISABILITY_DETAIL" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into RATED_DISABILITY_DETAIL_H
		(
		RATED_DISABILITY_DETAIL_H_ID,
		RATED_DISABILITY_DETAIL_ID,
		RATED_DISABILITY_IS_SC_IND,
		DISABILITY_PERCENT,
		DISABILITY_START_DATE,
		ORIG_EFCTV_RATING_DATE_TXT,
		RATING_DATE_TXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_DISABILITYCONDITION_ID,
		SERVICE_CONNECTED_ID,
		RECORD_MODIFIED_COUNT,
		DIAGNOSTIC_EXTREMITY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		RATED_DISABILITY_DETAIL_H_S.nextval,
		:old.RATED_DISABILITY_DETAIL_ID,
		:old.RATED_DISABILITY_IS_SC_IND,
		:old.DISABILITY_PERCENT,
		:old.DISABILITY_START_DATE,
		:old.ORIG_EFCTV_RATING_DATE_TXT,
		:old.RATING_DATE_TXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.STD_DISABILITYCONDITION_ID,
		:old.SERVICE_CONNECTED_ID,
		:old.RECORD_MODIFIED_COUNT,
		:old.DIAGNOSTIC_EXTREMITY_TYPE_ID,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into RATED_DISABILITY_DETAIL_H
		(
		RATED_DISABILITY_DETAIL_H_ID,
		RATED_DISABILITY_DETAIL_ID,
		RATED_DISABILITY_IS_SC_IND,
		DISABILITY_PERCENT,
		DISABILITY_START_DATE,
		ORIG_EFCTV_RATING_DATE_TXT,
		RATING_DATE_TXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_DISABILITYCONDITION_ID,
		SERVICE_CONNECTED_ID,
		RECORD_MODIFIED_COUNT,
		DIAGNOSTIC_EXTREMITY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		RATED_DISABILITY_DETAIL_H_S.nextval,
		:new.RATED_DISABILITY_DETAIL_ID,
		:new.RATED_DISABILITY_IS_SC_IND,
		:new.DISABILITY_PERCENT,
		:new.DISABILITY_START_DATE,
		:new.ORIG_EFCTV_RATING_DATE_TXT,
		:new.RATING_DATE_TXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.STD_DISABILITYCONDITION_ID,
		:new.SERVICE_CONNECTED_ID,
		:new.RECORD_MODIFIED_COUNT,
		:new.DIAGNOSTIC_EXTREMITY_TYPE_ID,
		mDML
		);
	end if;

end RATED_DSBLTY_DET_audir_trgr;
/
DROP TRIGGER ADR.REGISTRY_TRAIT_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.REGISTRY_TRAIT_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."REGISTRY_TRAIT" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into REGISTRY_TRAIT_H
		(
 		 REGISTRY_TRAIT_H_ID
 		,REGISTRY_TRAIT_ID
 		,REGISTRY_TYPE_ID
 		,SSN
		,FIRST_NAME
 		,LAST_NAME
		,PREFIX
		,MIDDLE_NAME
		,SUFFIX
		,EDUCATIONAL_DEGREE
		,DEATH_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		REGISTRY_TRAIT_H_S.nextval,
		:old.REGISTRY_TRAIT_ID,
		:old.REGISTRY_TYPE_ID,
		:old.SSN,
		:old.FIRST_NAME,
		:old.LAST_NAME,
		:old.PREFIX,
		:old.MIDDLE_NAME,
		:old.SUFFIX,
		:old.EDUCATIONAL_DEGREE,
		:old.DEATH_DATE_TXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into REGISTRY_TRAIT_H
		(
 		 REGISTRY_TRAIT_H_ID
 		,REGISTRY_TRAIT_ID
 		,REGISTRY_TYPE_ID
 		,SSN
		,FIRST_NAME
 		,LAST_NAME
		,PREFIX
		,MIDDLE_NAME
		,SUFFIX
		,EDUCATIONAL_DEGREE
		,DEATH_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		REGISTRY_TRAIT_H_S.nextval,
		:new.REGISTRY_TRAIT_ID,
		:new.REGISTRY_TYPE_ID,
		:new.SSN,
		:new.FIRST_NAME,
		:new.LAST_NAME,
		:new.PREFIX,
		:new.MIDDLE_NAME,
		:new.SUFFIX,
		:new.EDUCATIONAL_DEGREE,
		:new.DEATH_DATE_TXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end REGISTRY_TRAIT_audir_trgr;
/
DROP TRIGGER ADR.REGISTRY_TRAIT_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.REGISTRY_TRAIT_DET_audir_trgr
after Update or Delete or Insert
ON ADR.REGISTRY_TRAIT_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into REGISTRY_TRAIT_DETAIL_H
		(
 		REGISTRY_TRAIT_DETAIL_H_ID
 		,REGISTRY_TRAIT_DETAIL_ID
 		,REGISTRY_TRAIT_ID
 		,MILITARY_SERVICE_NUMBER
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		REGISTRY_TRAIT_DETAIL_H_S.nextval,
		:old.REGISTRY_TRAIT_DETAIL_ID,
		:old.REGISTRY_TRAIT_ID,
		:old.MILITARY_SERVICE_NUMBER,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into REGISTRY_TRAIT_DETAIL_H
		(
 		 REGISTRY_TRAIT_DETAIL_H_ID
 		,REGISTRY_TRAIT_DETAIL_ID
 		,REGISTRY_TRAIT_ID
 		,MILITARY_SERVICE_NUMBER
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		REGISTRY_TRAIT_DETAIL_H_S.nextval,
		:new.REGISTRY_TRAIT_DETAIL_ID,
		:new.REGISTRY_TRAIT_ID,
		:new.MILITARY_SERVICE_NUMBER,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  REGISTRY_TRAIT_DET_audir_trgr;
/
DROP TRIGGER ADR.RELAXATION_PCT_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.RELAXATION_PCT_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.RELAXATION_PERCENTAGE  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into RELAXATION_PERCENTAGE_H
        (
        RELAXATION_PERCENTAGE_H_ID,
        RELAXATION_PERCENTAGE_ID,
        RELAXATION_PERCENTAGE,
        START_DATE,
        END_DATE,
        INCOME_YEAR,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        RELAXATION_PERCENTAGE_H_S.nextval,
        :old.RELAXATION_PERCENTAGE_ID,
        :old.RELAXATION_PERCENTAGE,
        :old.START_DATE,
        :old.END_DATE,
        :old.INCOME_YEAR,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into RELAXATION_PERCENTAGE_H
        (
        RELAXATION_PERCENTAGE_H_ID,
        RELAXATION_PERCENTAGE_ID,
        RELAXATION_PERCENTAGE,
        START_DATE,
        END_DATE,
        INCOME_YEAR,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        RELAXATION_PERCENTAGE_H_S.nextval,
        :new.RELAXATION_PERCENTAGE_ID,
        :new.RELAXATION_PERCENTAGE,
        :new.START_DATE,
        :new.END_DATE,
        :new.INCOME_YEAR,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end;
/
DROP TRIGGER ADR.ROLES_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ROLES_audir_trgr
after Update or Delete or Insert
ON ADR.ROLES
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ROLES_H
		(
		ROLES_H_ID,
		ROLE_ID,
		ROLE_NAME,
		DESCRIPTION,
		SORT_ORDER,
		ACTIVE_DATE,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLES_H_S.nextval,
		:old.ROLE_ID,
		:old.ROLE_NAME,
		:old.DESCRIPTION,
		:old.SORT_ORDER,
		:old.ACTIVE_DATE,
		:old.INACTIVE_FLAG,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ROLES_H
		(
		ROLES_H_ID,
		ROLE_ID,
		ROLE_NAME,
		DESCRIPTION,
		SORT_ORDER,
		ACTIVE_DATE,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLES_H_S.nextval,
		:new.ROLE_ID,
		:new.ROLE_NAME,
		:new.DESCRIPTION,
		:new.SORT_ORDER,
		:new.ACTIVE_DATE,
		:new.INACTIVE_FLAG,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end ROLES_audir_trgr;
/
DROP TRIGGER ADR.ROLE_PERMSSN_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ROLE_PERMSSN_audir_trgr
after Update or Delete or Insert
ON ADR.ROLE_PERMISSIONS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ROLE_PERMISSIONS_H
		(
		ROLE_PERMISSIONS_H_ID,
		ROLE_PERMISSION_ID,
		ROLE_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLE_PERMISSIONS_H_S.nextval,
		:old.ROLE_PERMISSION_ID,
		:old.ROLE_ID,
		:old.PERMISSION_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ROLE_PERMISSIONS_H
		(
		ROLE_PERMISSIONS_H_ID,
		ROLE_PERMISSION_ID,
		ROLE_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLE_PERMISSIONS_H_S.nextval,
		:new.ROLE_PERMISSION_ID,
		:new.ROLE_ID,
		:new.PERMISSION_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end ROLE_PERMSSN_audir_trgr;
/
DROP TRIGGER ADR.ROLE_PERM_SET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.ROLE_PERM_SET_audir_trgr
after Update or Delete or Insert
ON ADR.ROLE_PERMISSION_SETS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ROLE_PERMISSION_SETS_H
		(
		ROLE_PERMISSION_SET_H_ID,
		ROLE_PERMISSION_SET_ID,
		ROLE_ID,
		PERMISSION_SET_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLE_PERMISSION_SETS_H_S.nextval,
		:old.ROLE_PERMISSION_SET_ID,
		:old.ROLE_ID,
		:old.PERMISSION_SET_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ROLE_PERMISSION_SETS_H
		(
		ROLE_PERMISSION_SET_H_ID,
		ROLE_PERMISSION_SET_ID,
		ROLE_ID,
		PERMISSION_SET_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLE_PERMISSION_SETS_H_S.nextval,
		:new.ROLE_PERMISSION_SET_ID,
		:new.ROLE_ID,
		:new.PERMISSION_SET_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end ROLE_PERM_SET_audir_trgr;
/
DROP TRIGGER ADR.SERVICE_CONNECTED_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.SERVICE_CONNECTED_AUDIR_TRGR
after Update or Delete or Insert
on ADR.SERVICE_CONNECTED
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SERVICE_CONNECTED_H
		(
		SERVICE_CONNECTED_H_ID,
		SERVICE_CONNECTED_ID,
		SC_TOTAL_AMOUNT,
		SERVICE_AWARD_DATE_TXT,
		SC_COMBINED_PERCENT,
		SC_COMBINED_PCT_EFCTV_DATE_TXT,
		SC_PERMANENT_AND_TOTAL_IND,
		SC_PERMNT_AND_TOTAL_EFCTV_DT,
		UNEMPLOYABLE_INDICATOR,
		SERVICE_CONNECTED_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SERVICE_CONNECTED_H_S.nextval,
		:old.SERVICE_CONNECTED_ID,
		:old.SC_TOTAL_AMOUNT,
		:old.SERVICE_AWARD_DATE_TXT,
		:old.SC_COMBINED_PERCENT,
		:old.SC_COMBINED_PCT_EFCTV_DATE_TXT,
		:old.SC_PERMANENT_AND_TOTAL_IND,
		:old.SC_PERMNT_AND_TOTAL_EFCTV_DT,
		:old.UNEMPLOYABLE_INDICATOR,
		:old.SERVICE_CONNECTED_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SERVICE_CONNECTED_H
		(
		SERVICE_CONNECTED_H_ID,
		SERVICE_CONNECTED_ID,
		SC_TOTAL_AMOUNT,
		SERVICE_AWARD_DATE_TXT,
		SC_COMBINED_PERCENT,
		SC_COMBINED_PCT_EFCTV_DATE_TXT,
		SC_PERMANENT_AND_TOTAL_IND,
		SC_PERMNT_AND_TOTAL_EFCTV_DT,
		UNEMPLOYABLE_INDICATOR,
		SERVICE_CONNECTED_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SERVICE_CONNECTED_H_S.nextval,
		:new.SERVICE_CONNECTED_ID,
		:new.SC_TOTAL_AMOUNT,
		:new.SERVICE_AWARD_DATE_TXT,
		:new.SC_COMBINED_PERCENT,
		:new.SC_COMBINED_PCT_EFCTV_DATE_TXT,
		:new.SC_PERMANENT_AND_TOTAL_IND,
		:new.SC_PERMNT_AND_TOTAL_EFCTV_DT,
		:new.UNEMPLOYABLE_INDICATOR,
		:new.SERVICE_CONNECTED_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end SERVICE_CONNECTED_audir_trgr;
/
DROP TRIGGER ADR.SHAD_REGISTRY_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.SHAD_REGISTRY_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.SHAD_REGISTRY
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SHAD_REGISTRY_H
		(
		SHAD_REGISTRY_H_ID,
		SHAD_REGISTRY_ID,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		CLAIM_NUMBER,
		SHAD_STDYESNO_ID,
		LEGACY_USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_H_S.nextval,
		:old.SHAD_REGISTRY_ID,
		:old.PERSON_ID,
		:old.REGISTRY_TRAIT_ID,
		:old.CLAIM_NUMBER,
		:old.SHAD_STDYESNO_ID,
		:old.LEGACY_USERNAME,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);

	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SHAD_REGISTRY_H
		(
		SHAD_REGISTRY_H_ID,
		SHAD_REGISTRY_ID,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		CLAIM_NUMBER,
		SHAD_STDYESNO_ID,
		LEGACY_USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_H_S.nextval,
		:new.SHAD_REGISTRY_ID,
		:new.PERSON_ID,
		:new.REGISTRY_TRAIT_ID,
		:new.CLAIM_NUMBER,
		:new.SHAD_STDYESNO_ID,
		:new.LEGACY_USERNAME,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);

	end if;

end SHAD_REGISTRY_audir_trgr;
/
DROP TRIGGER ADR.SHAD_REGISTRY_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.SHAD_REGISTRY_det_audir_trgr
after Update or Delete or Insert
ON ADR.SHAD_REGISTRY_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SHAD_REGISTRY_DETAIL_H
		(
 		SHAD_REGISTRY_DETAIL_H_ID
 		,SHAD_REGISTRY_DETAIL_ID
 		,SHAD_REGISTRY_ID
 		,SHAD_DOCUMENT_TYPE_ID
		,DOCUMENT_RECEIVED_DATE
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_DETAIL_H_S.nextval,
		:old.SHAD_REGISTRY_DETAIL_ID,
		:old.SHAD_REGISTRY_ID,
		:old.SHAD_DOCUMENT_TYPE_ID,
		:OLD.DOCUMENT_RECEIVED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SHAD_REGISTRY_DETAIL_H
		(
 		SHAD_REGISTRY_DETAIL_H_ID
 		,SHAD_REGISTRY_DETAIL_ID
 		,SHAD_REGISTRY_ID
 		,SHAD_DOCUMENT_TYPE_ID
		,DOCUMENT_RECEIVED_DATE
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_DETAIL_H_S.nextval,
		:new.SHAD_REGISTRY_DETAIL_ID,
		:new.SHAD_REGISTRY_ID,
		:new.SHAD_DOCUMENT_TYPE_ID,
		:new.DOCUMENT_RECEIVED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SHAD_REGISTRY_det_audir_trgr;
/
DROP TRIGGER ADR.SIGNATURE_IMAGE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.SIGNATURE_IMAGE_audir_trgr
after Update or Delete or Insert
ON ADR.SIGNATURE_IMAGE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SIGNATURE_IMAGE_H
		(
		SIGNATURE_IMAGE_H_ID,
		SIGNATURE_IMAGE_ID,
		SIGNATURE_INDICATOR_TYPE_ID,
		IMAGE_NUMBER,
		INCOME_YEAR,
		INDEXED_DATE,
		USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		SUBMITTING_SITE_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SIGNATURE_IMAGE_H_S.nextval,
		:old.SIGNATURE_IMAGE_ID,
		:old.SIGNATURE_INDICATOR_TYPE_ID,
		:old.IMAGE_NUMBER,
		:old.INCOME_YEAR,
		:old.INDEXED_DATE,
		:old.USERNAME,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.SUBMITTING_SITE_ID,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SIGNATURE_IMAGE_H
		(
		SIGNATURE_IMAGE_H_ID,
		SIGNATURE_IMAGE_ID,
		SIGNATURE_INDICATOR_TYPE_ID,
		IMAGE_NUMBER,
		INCOME_YEAR,
		INDEXED_DATE,
		USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		SUBMITTING_SITE_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SIGNATURE_IMAGE_H_S.nextval,
		:new.SIGNATURE_IMAGE_ID,
		:new.SIGNATURE_INDICATOR_TYPE_ID,
		:new.IMAGE_NUMBER,
		:new.INCOME_YEAR,
		:new.INDEXED_DATE,
		:new.USERNAME,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.SUBMITTING_SITE_ID,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SIGNATURE_IMAGE_audir_trgr;
/
DROP TRIGGER ADR.SITE_RECEIVED_ELIG_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.SITE_RECEIVED_ELIG_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."SITE_RECEIVED_ELIGIBILITY" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SITE_RECEIVED_ELIGIBILITY_H
		(
		SITE_RECEIVED_ELIGIBILITY_H_ID,
		SITE_RECEIVED_ELIGIBILITY_ID,
		ELIGIBILITY_EFFECTIVE_DATE,
		ELIGIBILITY_EXPIRATION_DATE,
		ELIGIBILITY_STATUS_DATE,
		STATUS_DATE_TXT,
		PRIMARY_SECONDARY_OR_OTHER_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		STD_INSTITUTION_ID,
		ELIGIBILITY_TYPE_ID,
		RECORD_MODIFIED_COUNT,
		ALLIED_COUNTRY_TYPE_ID,
		FEDERAL_AGENCY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SITE_RECEIVED_ELIGIBILITY_H_S.nextval,
		:old.SITE_RECEIVED_ELIGIBILITY_ID,
		:old.ELIGIBILITY_EFFECTIVE_DATE,
		:old.ELIGIBILITY_EXPIRATION_DATE,
		:old.ELIGIBILITY_STATUS_DATE,
		:old.STATUS_DATE_TXT,
		:old.PRIMARY_SECONDARY_OR_OTHER_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.PERSON_ID,
		:old.STD_INSTITUTION_ID,
		:old.ELIGIBILITY_TYPE_ID,
		:old.RECORD_MODIFIED_COUNT,
		:old.ALLIED_COUNTRY_TYPE_ID,
		:old.FEDERAL_AGENCY_TYPE_ID,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SITE_RECEIVED_ELIGIBILITY_H
		(
		SITE_RECEIVED_ELIGIBILITY_H_ID,
		SITE_RECEIVED_ELIGIBILITY_ID,
		ELIGIBILITY_EFFECTIVE_DATE,
		ELIGIBILITY_EXPIRATION_DATE,
		ELIGIBILITY_STATUS_DATE,
		STATUS_DATE_TXT,
		PRIMARY_SECONDARY_OR_OTHER_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		STD_INSTITUTION_ID,
		ELIGIBILITY_TYPE_ID,
		RECORD_MODIFIED_COUNT,
		ALLIED_COUNTRY_TYPE_ID,
		FEDERAL_AGENCY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SITE_RECEIVED_ELIGIBILITY_H_S.nextval,
		:new.SITE_RECEIVED_ELIGIBILITY_ID,
		:new.ELIGIBILITY_EFFECTIVE_DATE,
		:new.ELIGIBILITY_EXPIRATION_DATE,
		:new.ELIGIBILITY_STATUS_DATE,
		:new.STATUS_DATE_TXT,
		:new.PRIMARY_SECONDARY_OR_OTHER_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.PERSON_ID,
		:new.STD_INSTITUTION_ID,
		:new.ELIGIBILITY_TYPE_ID,
		:new.RECORD_MODIFIED_COUNT,
		:new.ALLIED_COUNTRY_TYPE_ID,
		:new.FEDERAL_AGENCY_TYPE_ID,
		mDML
		);
	end if;

end SITE_RECEIVED_ELIG_audir_trgr;
/
DROP TRIGGER ADR.SITE_RECEIVED_ENROL_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.SITE_RECEIVED_ENROL_audir_trgr
after Update or Delete or Insert
ON ADR.SITE_RECEIVED_ENROLLMENT
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SITE_RECEIVED_ENROLLMENT_H
		(
		SITE_RECEIVED_ENROLLMENT_H_ID,
		SITE_RECEIVED_ENROLLMENT_ID,
		ENROLLMENT_START_DATE,
		ENROLLMENT_END_DATE,
		ENROLLMENT_CHANGE_EFCTV_DATE,
		OVERRIDE_IND,
		REMARKS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_ENROLLMENTSTATUS_ID,
		PRIORITY_GROUP_TYPE_ID,
		ENROLLMENT_DATA_SRC_TYPE_ID,
		STD_INSTITUTION_ID,
		PRIORITY_SUB_GROUP_TYPE_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SITE_RECEIVED_ENROLLMENT_H_S.nextval,
		:old.SITE_RECEIVED_ENROLLMENT_ID,
		:old.ENROLLMENT_START_DATE,
		:old.ENROLLMENT_END_DATE,
		:old.ENROLLMENT_CHANGE_EFCTV_DATE,
		:old.OVERRIDE_IND,
		:old.REMARKS,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.STD_ENROLLMENTSTATUS_ID,
		:old.PRIORITY_GROUP_TYPE_ID,
		:old.ENROLLMENT_DATA_SRC_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.PRIORITY_SUB_GROUP_TYPE_ID,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SITE_RECEIVED_ENROLLMENT_H
		(
		SITE_RECEIVED_ENROLLMENT_H_ID,
		SITE_RECEIVED_ENROLLMENT_ID,
		ENROLLMENT_START_DATE,
		ENROLLMENT_END_DATE,
		ENROLLMENT_CHANGE_EFCTV_DATE,
		OVERRIDE_IND,
		REMARKS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_ENROLLMENTSTATUS_ID,
		PRIORITY_GROUP_TYPE_ID,
		ENROLLMENT_DATA_SRC_TYPE_ID,
		STD_INSTITUTION_ID,
		PRIORITY_SUB_GROUP_TYPE_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SITE_RECEIVED_ENROLLMENT_H_S.nextval,
		:new.SITE_RECEIVED_ENROLLMENT_ID,
		:new.ENROLLMENT_START_DATE,
		:new.ENROLLMENT_END_DATE,
		:new.ENROLLMENT_CHANGE_EFCTV_DATE,
		:new.OVERRIDE_IND,
		:new.REMARKS,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.STD_ENROLLMENTSTATUS_ID,
		:new.PRIORITY_GROUP_TYPE_ID,
		:new.ENROLLMENT_DATA_SRC_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.PRIORITY_SUB_GROUP_TYPE_ID,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SITE_RECEIVED_ENROL_audir_trgr;
/
DROP TRIGGER ADR.SPECIAL_FACTOR_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.SPECIAL_FACTOR_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."SPECIAL_FACTOR" FOR EACH ROW
declare
    mDML char(1);
begin

  if DELETING then
    insert into SPECIAL_FACTOR_H
    (
    SPECIAL_FACTOR_H_ID,
    SPECIAL_FACTOR_ID,
    SPCL_FACTOR_MAPPING_TYPE_CODE,
    SPECIAL_FACTOR_REGISTER_NUMBER,
    SPECIAL_FACTOR_REG_DATE_TXT,
    SPECIAL_FACTOR_EXAM_DATE_TXT,
    REMARKS,
    SPECIAL_FACTOR_STDYESNO_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RADIATION_EXP_METHOD_TYPE_ID,
    PERSON_ID,
    AGENT_ORANGE_LOCATION_TYPE_ID,
    RECORD_MODIFIED_COUNT,
    CL_VERIFICATION_METHOD_CODE,
    CL_CHANGE_SITE,
    CL_COMMENT,
    CL_SOURCE_OF_CHANGE,
    HISTORY_CREATED_DATE,
    TRANSACTION_TYPE_CODE

    )
    values
    (
    SPECIAL_FACTOR_H_S.nextval,
    :old.SPECIAL_FACTOR_ID,
    :old.SPCL_FACTOR_MAPPING_TYPE_CODE,
    :old.SPECIAL_FACTOR_REGISTER_NUMBER,
    :old.SPECIAL_FACTOR_REG_DATE_TXT,
    :old.SPECIAL_FACTOR_EXAM_DATE_TXT,
    :old.REMARKS,
    :old.SPECIAL_FACTOR_STDYESNO_ID,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.RADIATION_EXP_METHOD_TYPE_ID,
    :old.PERSON_ID,
    :old.AGENT_ORANGE_LOCATION_TYPE_ID,
    :old.RECORD_MODIFIED_COUNT,
    :old.CL_VERIFICATION_METHOD_CODE,
    :old.CL_CHANGE_SITE,
    :old.CL_COMMENT,
    :old.CL_SOURCE_OF_CHANGE,
    SYSDATE,
    'D'
    );

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into SPECIAL_FACTOR_H
    (
    SPECIAL_FACTOR_H_ID,
    SPECIAL_FACTOR_ID,
    SPCL_FACTOR_MAPPING_TYPE_CODE,
    SPECIAL_FACTOR_REGISTER_NUMBER,
    SPECIAL_FACTOR_REG_DATE_TXT,
    SPECIAL_FACTOR_EXAM_DATE_TXT,
    REMARKS,
    SPECIAL_FACTOR_STDYESNO_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RADIATION_EXP_METHOD_TYPE_ID,
    PERSON_ID,
    AGENT_ORANGE_LOCATION_TYPE_ID,
    RECORD_MODIFIED_COUNT,
    CL_VERIFICATION_METHOD_CODE,
    CL_CHANGE_SITE,
    CL_COMMENT,
    CL_SOURCE_OF_CHANGE,
    HISTORY_CREATED_DATE,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    SPECIAL_FACTOR_H_S.nextval,
    :new.SPECIAL_FACTOR_ID,
    :new.SPCL_FACTOR_MAPPING_TYPE_CODE,
    :new.SPECIAL_FACTOR_REGISTER_NUMBER,
    :new.SPECIAL_FACTOR_REG_DATE_TXT,
    :new.SPECIAL_FACTOR_EXAM_DATE_TXT,
    :new.REMARKS,
    :new.SPECIAL_FACTOR_STDYESNO_ID,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.RADIATION_EXP_METHOD_TYPE_ID,
    :new.PERSON_ID,
    :new.AGENT_ORANGE_LOCATION_TYPE_ID,
    :new.RECORD_MODIFIED_COUNT,
    :new.CL_VERIFICATION_METHOD_CODE,
    :new.CL_CHANGE_SITE,
    :new.CL_COMMENT,
    :new.CL_SOURCE_OF_CHANGE,
    SYSDATE,
    mDML
    );

  end if;

end SPECIAL_FACTOR_audir_trgr;
/
DROP TRIGGER ADR.SSN_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.SSN_AUDIR_TRGR AFTER UPDATE OR INSERT OR DELETE ON "ADR"."SSN" FOR EACH ROW
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SSN_H
		(
		SSN_H_ID,
		SSN_ID,
		PERSON_ID,
		PERSON_RELATION_ID,
		STD_SSNTYPE_ID,
		PSEUDO_SSN_REASON_TYPE_ID,
		SSN_CHANGE_SOURCE_TYPE_ID,
		SSN_VRFN_STATUS_TYPE_ID,
		SSA_MESSAGE_TYPE_ID,
		SSN,
		SSA_VERIFIED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SSN_H_S.nextval,
		:old.SSN_ID,
		:old.PERSON_ID,
		:old.PERSON_RELATION_ID,
		:old.STD_SSNTYPE_ID,
		:old.PSEUDO_SSN_REASON_TYPE_ID,
		:old.SSN_CHANGE_SOURCE_TYPE_ID,
		:old.SSN_VRFN_STATUS_TYPE_ID,
		:old.SSA_MESSAGE_TYPE_ID,
		:old.SSN,
		:old.SSA_VERIFIED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SSN_H
		(
		SSN_H_ID,
		SSN_ID,
		PERSON_ID,
		PERSON_RELATION_ID,
		STD_SSNTYPE_ID,
		PSEUDO_SSN_REASON_TYPE_ID,
		SSN_CHANGE_SOURCE_TYPE_ID,
		SSN_VRFN_STATUS_TYPE_ID,
		SSA_MESSAGE_TYPE_ID,
		SSN,
		SSA_VERIFIED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SSN_H_S.nextval,
		:new.SSN_ID,
		:new.PERSON_ID,
		:new.PERSON_RELATION_ID,
		:new.STD_SSNTYPE_ID,
		:new.PSEUDO_SSN_REASON_TYPE_ID,
		:new.SSN_CHANGE_SOURCE_TYPE_ID,
		:new.SSN_VRFN_STATUS_TYPE_ID,
		:new.SSA_MESSAGE_TYPE_ID,
		:new.SSN,
		:new.SSA_VERIFIED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SSN_audir_trgr;
/
DROP TRIGGER ADR.TITLE_38_CARE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.TITLE_38_CARE_AUDIR_TRGR
   AFTER DELETE OR INSERT OR UPDATE
   ON ADR.title_38_care
   REFERENCING OLD AS OLD NEW AS NEW
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      INSERT INTO title_38_care_h (title_38_care_h_id,
                                   title_38_care_id,
                                   person_id,
                                   LOOKUP_TYPE_ID,
                                   qualify_ind,
                                   RECORD_CREATED_BY,
                                   RECORD_CREATED_DATE,
                                   RECORD_MODIFIED_BY,
                                   RECORD_MODIFIED_DATE,
                                   RECORD_MODIFIED_COUNT,
                                   transaction_type_code)
           VALUES (title_38_care_h_s.NEXTVAL,
                   :old.title_38_care_id,
                   :old.person_id,
                   :old.LOOKUP_TYPE_ID,
                   :old.qualify_ind,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   'D');
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO title_38_care_h (title_38_care_h_id,
                                   title_38_care_id,
                                   person_id,
                                   LOOKUP_TYPE_ID,
                                   qualify_ind,
                                   RECORD_CREATED_BY,
                                   RECORD_CREATED_DATE,
                                   RECORD_MODIFIED_BY,
                                   RECORD_MODIFIED_DATE,
                                   RECORD_MODIFIED_COUNT,
                                   transaction_type_code)
           VALUES (title_38_care_h_s.NEXTVAL,
                   :new.title_38_care_id,
                   :new.person_id,
                   :new.LOOKUP_TYPE_ID,
                   :new.qualify_ind,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   mDML);
   END IF;
END title_38_care_audir_trgr;
/
DROP TRIGGER ADR.USERS_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.USERS_AUDIR_TRGR
   AFTER UPDATE OR DELETE OR INSERT
   ON ADR.USERS
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      INSERT INTO USERS_H (USERS_H_ID,
                           USERID,
                           STD_INSTITUTION_ID,
                           USERNAME,
                           FULL_NAME,
                           PASSWORD,
                           PASSWORD_CREATE_DATE,
                           PASSWORD_CHANGE_DATE,
                           PASSWORD_EXPIRE_DATE,
                           USER_GROUP_TYPE_ID,
                           FIRST_NAME,
                           MIDDLE_NAME,
                           LAST_NAME,
                           MAIDEN_NAME,
                           EMPLOYEE_NUMBER,
                           EMAIL_ADDRESS,
                           TELEPHONE_NUMBER,
                           FAX_NUMBER,
                           JOB_TITLE,
                           AGREEMENT_SIGNATURE_CODE,
                           SIGNATURE_VERIFIED_IND,
                           INACTIVE_FLAG,
                           INACTIVE_DATE,
                           RECORD_CREATED_BY,
                           RECORD_CREATED_DATE,
                           RECORD_MODIFIED_BY,
                           RECORD_MODIFIED_DATE,
                           ACCOUNT_EXPIRE_DATE,
                           ACCOUNT_LOCK_DATE,
                           NUMBER_OF_LOGIN_ATTEMPTS,
                           INITIAL_LOGIN_DATE,
                           RECORD_MODIFIED_COUNT,
                           TRANSACTION_TYPE_CODE,
                           VHIC_ROLE_FLAG,
                           VHIC_ROLE_ADD_DT)
           VALUES (USERS_H_S.NEXTVAL,
                   :old.USERID,
                   :old.STD_INSTITUTION_ID,
                   :old.USERNAME,
                   :old.FULL_NAME,
                   :old.PASSWORD,
                   :old.PASSWORD_CREATE_DATE,
                   :old.PASSWORD_CHANGE_DATE,
                   :old.PASSWORD_EXPIRE_DATE,
                   :old.USER_GROUP_TYPE_ID,
                   :old.FIRST_NAME,
                   :old.MIDDLE_NAME,
                   :old.LAST_NAME,
                   :old.MAIDEN_NAME,
                   :old.EMPLOYEE_NUMBER,
                   :old.EMAIL_ADDRESS,
                   :old.TELEPHONE_NUMBER,
                   :old.FAX_NUMBER,
                   :old.JOB_TITLE,
                   :old.AGREEMENT_SIGNATURE_CODE,
                   :old.SIGNATURE_VERIFIED_IND,
                   :old.INACTIVE_FLAG,
                   :old.INACTIVE_DATE,
                   :old.RECORD_CREATED_BY,
                   :old.RECORD_CREATED_DATE,
                   :old.RECORD_MODIFIED_BY,
                   :old.RECORD_MODIFIED_DATE,
                   :old.ACCOUNT_EXPIRE_DATE,
                   :old.ACCOUNT_LOCK_DATE,
                   :old.NUMBER_OF_LOGIN_ATTEMPTS,
                   :old.INITIAL_LOGIN_DATE,
                   :old.RECORD_MODIFIED_COUNT,
                   'D',
                   :old.VHIC_ROLE_FLAG,
                   :old.VHIC_ROLE_ADD_DT);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

      INSERT INTO USERS_H (USERS_H_ID,
                           USERID,
                           STD_INSTITUTION_ID,
                           USERNAME,
                           FULL_NAME,
                           PASSWORD,
                           PASSWORD_CREATE_DATE,
                           PASSWORD_CHANGE_DATE,
                           PASSWORD_EXPIRE_DATE,
                           USER_GROUP_TYPE_ID,
                           FIRST_NAME,
                           MIDDLE_NAME,
                           LAST_NAME,
                           MAIDEN_NAME,
                           EMPLOYEE_NUMBER,
                           EMAIL_ADDRESS,
                           TELEPHONE_NUMBER,
                           FAX_NUMBER,
                           JOB_TITLE,
                           AGREEMENT_SIGNATURE_CODE,
                           SIGNATURE_VERIFIED_IND,
                           INACTIVE_FLAG,
                           INACTIVE_DATE,
                           RECORD_CREATED_BY,
                           RECORD_CREATED_DATE,
                           RECORD_MODIFIED_BY,
                           RECORD_MODIFIED_DATE,
                           ACCOUNT_EXPIRE_DATE,
                           ACCOUNT_LOCK_DATE,
                           NUMBER_OF_LOGIN_ATTEMPTS,
                           INITIAL_LOGIN_DATE,
                           RECORD_MODIFIED_COUNT,
                           TRANSACTION_TYPE_CODE,
                           VHIC_ROLE_FLAG,
                           VHIC_ROLE_ADD_DT)
           VALUES (USERS_H_S.NEXTVAL,
                   :new.USERID,
                   :new.STD_INSTITUTION_ID,
                   :new.USERNAME,
                   :new.FULL_NAME,
                   :new.PASSWORD,
                   :new.PASSWORD_CREATE_DATE,
                   :new.PASSWORD_CHANGE_DATE,
                   :new.PASSWORD_EXPIRE_DATE,
                   :new.USER_GROUP_TYPE_ID,
                   :new.FIRST_NAME,
                   :new.MIDDLE_NAME,
                   :new.LAST_NAME,
                   :new.MAIDEN_NAME,
                   :new.EMPLOYEE_NUMBER,
                   :new.EMAIL_ADDRESS,
                   :new.TELEPHONE_NUMBER,
                   :new.FAX_NUMBER,
                   :new.JOB_TITLE,
                   :new.AGREEMENT_SIGNATURE_CODE,
                   :new.SIGNATURE_VERIFIED_IND,
                   :new.INACTIVE_FLAG,
                   :new.INACTIVE_DATE,
                   :new.RECORD_CREATED_BY,
                   :new.RECORD_CREATED_DATE,
                   :new.RECORD_MODIFIED_BY,
                   :new.RECORD_MODIFIED_DATE,
                   :new.ACCOUNT_EXPIRE_DATE,
                   :new.ACCOUNT_LOCK_DATE,
                   :new.NUMBER_OF_LOGIN_ATTEMPTS,
                   :new.INITIAL_LOGIN_DATE,
                   :new.RECORD_MODIFIED_COUNT,
                   mDML,
                   :new.VHIC_ROLE_FLAG,
                   :new.VHIC_ROLE_ADD_DT);
   END IF;
END USERS_audir_trgr;
/
DROP TRIGGER ADR.USER_LOGIN_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.USER_LOGIN_audir_trgr
after Update or Delete or Insert
ON ADR.USER_LOGIN
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USER_LOGIN_H
		(
		USER_LOGIN_H_ID,
		ID,
		USERID,
		LAST_LOGIN_SUCCESS_DATE,
		LAST_LOGIN_FAILURE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_LOGIN_H_S.nextval,
		:old.ID,
		:old.USERID,
		:old.LAST_LOGIN_SUCCESS_DATE,
		:old.LAST_LOGIN_FAILURE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USER_LOGIN_H
		(
		USER_LOGIN_H_ID,
		ID,
		USERID,
		LAST_LOGIN_SUCCESS_DATE,
		LAST_LOGIN_FAILURE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_LOGIN_H_S.nextval,
		:new.ID,
		:new.USERID,
		:new.LAST_LOGIN_SUCCESS_DATE,
		:new.LAST_LOGIN_FAILURE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USER_LOGIN_audir_trgr;
/
DROP TRIGGER ADR.USER_PERMISSIONS_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.USER_PERMISSIONS_audir_trgr
after Update or Delete or Insert
ON ADR.USER_PERMISSIONS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USER_PERMISSIONS_H
		(
		USER_PERMISSIONS_H_ID,
		USER_PERMISSION_ID,
		USERID,
		PERMISSION_TYPE_ID,
		ACTIVE_DATE,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_PERMISSIONS_H_S.nextval,
		:old.USER_PERMISSION_ID,
		:old.USERID,
		:old.PERMISSION_TYPE_ID,
		:old.ACTIVE_DATE,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USER_PERMISSIONS_H
		(
		USER_PERMISSIONS_H_ID,
		USER_PERMISSION_ID,
		USERID,
		PERMISSION_TYPE_ID,
		ACTIVE_DATE,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_PERMISSIONS_H_S.nextval,
		:new.USER_PERMISSION_ID,
		:new.USERID,
		:new.PERMISSION_TYPE_ID,
		:new.ACTIVE_DATE,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USER_PERMISSIONS_audir_trgr;
/
DROP TRIGGER ADR.USER_PERM_SET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.USER_PERM_SET_audir_trgr
after Update or Delete or Insert
ON ADR.USER_PERMISSION_SETS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USER_PERMISSION_SETS_H
		(
		USER_PERMISSION_SET_H_ID,
		USER_PERMISSION_SET_ID,
		USERID,
		PERMISSION_SET_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_PERMISSION_SETS_H_S.nextval,
		:old.USER_PERMISSION_SET_ID,
		:old.USERID,
		:old.PERMISSION_SET_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USER_PERMISSION_SETS_H
		(
		USER_PERMISSION_SET_H_ID,
		USER_PERMISSION_SET_ID,
		USERID,
		PERMISSION_SET_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_PERMISSION_SETS_H_S.nextval,
		:new.USER_PERMISSION_SET_ID,
		:new.USERID,
		:new.PERMISSION_SET_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USER_PERM_SET_audir_trgr;
/
DROP TRIGGER ADR.USER_ROLES_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.USER_ROLES_audir_trgr
after Update or Delete or Insert
ON ADR.USER_ROLES
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USER_ROLES_H
		(
		USER_ROLES_H_ID,
		USER_ROLE_ID,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		USERID,
		ROLE_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_ROLES_H_S.nextval,
		:old.USER_ROLE_ID,
		:old.INACTIVE_FLAG,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.USERID,
		:old.ROLE_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USER_ROLES_H
		(
		USER_ROLES_H_ID,
		USER_ROLE_ID,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		USERID,
		ROLE_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_ROLES_H_S.nextval,
		:new.USER_ROLE_ID,
		:new.INACTIVE_FLAG,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.USERID,
		:new.ROLE_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USER_ROLES_audir_trgr;
/
DROP TRIGGER ADR.VA_PERSON_CLASS_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.VA_PERSON_CLASS_DET_audir_trgr
after Update or Delete or Insert
ON ADR.VA_PERSON_CLASS_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into VA_PERSON_CLASS_DETAIL_H
		(
		VA_PERSON_CLASS_DETAIL_H_ID,
		VA_PERSON_CLASS_DETAIL_ID,
		PERSON_CLASS_START_DATE,
		PERSON_CLASS_END_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_PERSONCLASS_ID,
		STD_INSTITUTION_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		VA_PERSON_CLASS_DETAIL_H_S.nextval,
		:old.VA_PERSON_CLASS_DETAIL_ID,
		:old.PERSON_CLASS_START_DATE,
		:old.PERSON_CLASS_END_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.STD_PERSONCLASS_ID,
		:old.STD_INSTITUTION_ID,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into VA_PERSON_CLASS_DETAIL_H
		(
		VA_PERSON_CLASS_DETAIL_H_ID,
		VA_PERSON_CLASS_DETAIL_ID,
		PERSON_CLASS_START_DATE,
		PERSON_CLASS_END_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_PERSONCLASS_ID,
		STD_INSTITUTION_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		VA_PERSON_CLASS_DETAIL_H_S.nextval,
		:new.VA_PERSON_CLASS_DETAIL_ID,
		:new.PERSON_CLASS_START_DATE,
		:new.PERSON_CLASS_END_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.STD_PERSONCLASS_ID,
		:new.STD_INSTITUTION_ID,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML
		);
	end if;

end VA_PERSON_CLASS_DET_audir_trgr;
/
DROP TRIGGER ADR.VA_PERSON_DIV_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.VA_PERSON_DIV_DET_audir_trgr
after Update or Delete or Insert
ON ADR.VA_PERSON_DIVISION_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into VA_PERSON_DIVISION_DETAIL_H
		(
		VA_PERSON_DIVISION_DETAIL_H_ID,
		VA_PERSON_DIVISION_DETAIL_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		DEFAULT_DIVISION_FLAG,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		VA_PERSON_DIVISION_DETAIL_H_S.nextval,
		:old.VA_PERSON_DIVISION_DETAIL_ID,
		:old.PERSON_ID,
		:old.STD_INSTITUTION_ID,
		:old.DEFAULT_DIVISION_FLAG,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into VA_PERSON_DIVISION_DETAIL_H
		(
		VA_PERSON_DIVISION_DETAIL_H_ID,
		VA_PERSON_DIVISION_DETAIL_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		DEFAULT_DIVISION_FLAG,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		VA_PERSON_DIVISION_DETAIL_H_S.nextval,
		:new.VA_PERSON_DIVISION_DETAIL_ID,
		:new.PERSON_ID,
		:new.STD_INSTITUTION_ID,
		:new.DEFAULT_DIVISION_FLAG,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML
		);
	end if;

end VA_PERSON_DIV_DET_audir_trgr;
/
DROP TRIGGER ADR.VCADMIN_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.VCADMIN_AUDIR_TRGR
    AFTER UPDATE OR DELETE OR INSERT
    ON ADR.VCADMIN
    FOR EACH ROW
DECLARE
    mDML   CHAR (1);
BEGIN
    IF DELETING
    THEN
        INSERT INTO ADR.VCADMIN_H (VCADMIN_H_ID,
                                   VCADMIN_ID,
                                   PERSON_ID,
                                   ERROR_TXT,
                                   VCADMISTATUS_TYPE_ID,
                                   TRANSACTION_TYPE_CODE,
                                   RECORD_CREATED_BY,
                                   RECORD_CREATED_DATE,
                                   RECORD_MODIFIED_BY,
                                   RECORD_MODIFIED_DATE,
                                   RECORD_MODIFIED_COUNT)
             VALUES (VCADMIN_H_S.NEXTVAL,
                     :old.VCADMIN_ID,
                     :old.PERSON_ID,
                     :old.ERROR_TXT,
                     :old.VCADMISTATUS_TYPE_ID,
                     'D',
                     :old.RECORD_CREATED_BY,
                     :old.RECORD_CREATED_DATE,
                     :old.RECORD_MODIFIED_BY,
                     :old.RECORD_MODIFIED_DATE,
                     :old.RECORD_MODIFIED_COUNT);
    ELSE
        IF UPDATING
        THEN
            mDML := 'U';
        ELSE
            mDML := 'I';
        END IF;

        INSERT INTO ADR.VCADMIN_H (VCADMIN_H_ID,
                                   VCADMIN_ID,
                                   PERSON_ID,
                                   ERROR_TXT,
                                   VCADMISTATUS_TYPE_ID,
                                   TRANSACTION_TYPE_CODE,
                                   RECORD_CREATED_BY,
                                   RECORD_CREATED_DATE,
                                   RECORD_MODIFIED_BY,
                                   RECORD_MODIFIED_DATE,
                                   RECORD_MODIFIED_COUNT)
             VALUES (VCADMIN_H_S.NEXTVAL,
                     :new.VCADMIN_ID,
                     :new.PERSON_ID,
                     :new.ERROR_TXT,
                     :new.VCADMISTATUS_TYPE_ID,
                     mDML,
                     :new.RECORD_CREATED_BY,
                     :new.RECORD_CREATED_DATE,
                     :new.RECORD_MODIFIED_BY,
                     :new.RECORD_MODIFIED_DATE,
                     :new.RECORD_MODIFIED_COUNT);
    END IF;
END VCADMIN_AUDIR_TRGR;
/
DROP TRIGGER ADR.VCELIGIB_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.VCELIGIB_AUDIR_TRGR
    AFTER UPDATE OR DELETE OR INSERT
    ON ADR.VCELIGIBILITY
    FOR EACH ROW
DECLARE
    mDML   CHAR (1);
BEGIN
    IF DELETING
    THEN
        INSERT INTO ADR.VCELIGIBILITY_H (VCELIGIBILITY_H_ID,
                                         TRANSACTION_TYPE_CODE,
                                         VCELIGIBILITY_ID,
                                         PERSON_ID,
                                         VCESTATUSTYPE_ID,
                                         RECORD_CREATED_BY,
                                         RECORD_CREATED_DATE,
                                         RECORD_MODIFIED_BY,
                                         RECORD_MODIFIED_DATE,
                                         RECORD_MODIFIED_COUNT,
                                         VCE_RECALC_REQUIRED_IND)
             VALUES (VCELIGIBILITY_H_S.NEXTVAL,
                     'D',
                     :old.VCELIGIBILITY_ID,
                     :old.PERSON_ID,
                     :old.VCESTATUSTYPE_ID,
                     :old.RECORD_CREATED_BY,
                     :old.RECORD_CREATED_DATE,
                     :old.RECORD_MODIFIED_BY,
                     :old.RECORD_MODIFIED_DATE,
                     :old.RECORD_MODIFIED_COUNT,
                     :old.VCE_RECALC_REQUIRED_IND);
    ELSE
        IF UPDATING
        THEN
            -- this if logic is added to avoid unnecessary inserts to ADDRESS_H table for geocode
            -- Assumption:
            --     ****
            --     ****   VCE_RECALC_REQUIRED_IND is solely used by the ES sub service/batch job for geocoding request purpose
            --     ****   Update issued by other part of ES application will NOT CHANGE the value of VCE_RECALC_REQUIRED_IND
            --     ****
            -- only change of VCE_RECALC_REQUIRED_IND tracked by this trigger is when VCE_RECALC_REQUIRED_IND changes from non 'G' to 'G'

            IF    :old.VCESTATUSTYPE_ID <> :new.VCESTATUSTYPE_ID
               OR (    NVL(:old.VCE_RECALC_REQUIRED_IND,'N') <>
                       NVL(:new.VCE_RECALC_REQUIRED_IND,'N')
                   AND :new.VCE_RECALC_REQUIRED_IND = 'G')
            THEN
                mDML := 'U';
            ELSE
                mDML := 'X';
            END IF;
        ELSE
            mDML := 'I';
        END IF;

        IF mDML <> 'X'
        THEN
            INSERT INTO ADR.VCELIGIBILITY_H (VCELIGIBILITY_H_ID,
                                             TRANSACTION_TYPE_CODE,
                                             VCELIGIBILITY_ID,
                                             PERSON_ID,
                                             VCESTATUSTYPE_ID,
                                             RECORD_CREATED_BY,
                                             RECORD_CREATED_DATE,
                                             RECORD_MODIFIED_BY,
                                             RECORD_MODIFIED_DATE,
                                             RECORD_MODIFIED_COUNT,
                                             VCE_RECALC_REQUIRED_IND)
                 VALUES (VCELIGIBILITY_H_S.NEXTVAL,
                         mDML,
                         :new.VCELIGIBILITY_ID,
                         :new.PERSON_ID,
                         :new.VCESTATUSTYPE_ID,
                         :new.RECORD_CREATED_BY,
                         :new.RECORD_CREATED_DATE,
                         :new.RECORD_MODIFIED_BY,
                         :new.RECORD_MODIFIED_DATE,
                         :new.RECORD_MODIFIED_COUNT,
                         :new.VCE_RECALC_REQUIRED_IND);
        END IF;
    END IF;
END VCELIGIB_AUDIR_TRGR;
/
DROP TRIGGER ADR.WAITTIME_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.WAITTIME_AUDIR_TRGR
   AFTER UPDATE OR INSERT OR DELETE
   ON ADR.WAITTIME
   FOR EACH ROW
DECLARE
   mDML   CHAR (1);
BEGIN
   IF DELETING
   THEN
      mDML := 'D';

      INSERT INTO WAITTIME_H (
      		WAITTIME_H_ID,
  		WAITTIME_ID,
  		PERSON_ID ,
  		WAITTYPE_ID,
  		STD_INSTITUTION_ID,
  		CLINIC_STOPCODE ,
  		CLINIC_STOPCODE_NAME,
  		WAITLIST_START_DATE,
  		DESIRED_APPT_DATE,
  		DAYS_ELAPSED,
  		RECORD_RESOLVED_IND,
  		CLINIC_NAME  ,
  		RECORD_CREATED_BY ,
  		RECORD_CREATED_DATE,
  		RECORD_MODIFIED_BY,
  		RECORD_MODIFIED_DATE,
  		RECORD_MODIFIED_COUNT,
  		VCELIGIBILITY_ID,
  		IS_ACTIVE,
  		TRANSACTION_TYPE_CODE,
  		CDW_STATION_NAME
  )
    VALUES (WAITTIME_H_S.NEXTVAL,
	      :old.WAITTIME_ID,
	      :old.PERSON_ID ,
	      :old.WAITTYPE_ID,
	      :old.STD_INSTITUTION_ID,
	      :old.CLINIC_STOPCODE ,
	      :old.CLINIC_STOPCODE_NAME,
	      :old.WAITLIST_START_DATE,
	      :old.DESIRED_APPT_DATE,
	      :old.DAYS_ELAPSED,
	      :old.RECORD_RESOLVED_IND,
	      :old.CLINIC_NAME  ,
	      :old.RECORD_CREATED_BY ,
	      :old.RECORD_CREATED_DATE,
	      :old.RECORD_MODIFIED_BY,
	      :old.RECORD_MODIFIED_DATE,
	      :old.RECORD_MODIFIED_COUNT,
	      :old.VCELIGIBILITY_ID,
	      :old.IS_ACTIVE,
  		mDML,
  		:old.CDW_STATION_NAME);
   ELSE
      IF UPDATING
      THEN
         mDML := 'U';
      ELSE
         mDML := 'I';
      END IF;

       INSERT INTO WAITTIME_H (
      		  WAITTIME_H_ID,
  		  WAITTIME_ID,
  		  PERSON_ID ,
  		  WAITTYPE_ID,
  		  STD_INSTITUTION_ID,
  		  CLINIC_STOPCODE ,
  		  CLINIC_STOPCODE_NAME,
  		  WAITLIST_START_DATE,
  		  DESIRED_APPT_DATE,
  		  DAYS_ELAPSED,
  		  RECORD_RESOLVED_IND,
  		  CLINIC_NAME  ,
  		  RECORD_CREATED_BY ,
  		  RECORD_CREATED_DATE,
  		  RECORD_MODIFIED_BY,
  		  RECORD_MODIFIED_DATE,
  		  RECORD_MODIFIED_COUNT,
  		  VCELIGIBILITY_ID,
  		  IS_ACTIVE,
  		  TRANSACTION_TYPE_CODE,
  		  CDW_STATION_NAME
  	    )
          VALUES (WAITTIME_H_S.NEXTVAL,
		   :new.WAITTIME_ID,
		   :new.PERSON_ID ,
		   :new.WAITTYPE_ID,
		   :new.STD_INSTITUTION_ID,
		   :new.CLINIC_STOPCODE ,
		   :new.CLINIC_STOPCODE_NAME,
		   :new.WAITLIST_START_DATE,
		   :new.DESIRED_APPT_DATE,
		   :new.DAYS_ELAPSED,
		   :new.RECORD_RESOLVED_IND,
		   :new.CLINIC_NAME  ,
		   :new.RECORD_CREATED_BY ,
		   :new.RECORD_CREATED_DATE,
		   :new.RECORD_MODIFIED_BY,
		   :new.RECORD_MODIFIED_DATE,
		   :new.RECORD_MODIFIED_COUNT,
		   :new.VCELIGIBILITY_ID,
		   :new.IS_ACTIVE,
 		 mDML,
 		 :new.CDW_STATION_NAME);
   END IF;
END WAITTIME_AUDIR_TRGR;
/
DROP TRIGGER ADR.WKF_CASE_ASSGN_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_ASSGN_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE_ASSIGNMENT for each row
declare
   	mDML char(1);
begin

	if DELETING then
	     insert into WKF_CASE_ASSIGNMENT_H
		(
		WKF_CASE_ASSIGNMENT_H_ID,
		WKF_CASE_ASSIGNMENT_ID,
		WKF_CASE_ID,
		WKF_CASE_ASSIGNED_BY,
		WKF_CASE_ASSIGNED_TO,
		WKF_CASE_ASSIGNMENT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_ASSIGNMENT_H_S.nextval  ,
		:old.WKF_CASE_ASSIGNMENT_ID,
		:old.WKF_CASE_ID,
		:old.WKF_CASE_ASSIGNED_BY,
		:old.WKF_CASE_ASSIGNED_TO,
		:old.WKF_CASE_ASSIGNMENT_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

	     insert into WKF_CASE_ASSIGNMENT_H
		(
		WKF_CASE_ASSIGNMENT_H_ID,
		WKF_CASE_ASSIGNMENT_ID,
		WKF_CASE_ID,
		WKF_CASE_ASSIGNED_BY,
		WKF_CASE_ASSIGNED_TO,
		WKF_CASE_ASSIGNMENT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_ASSIGNMENT_H_S.nextval  ,
		:new.WKF_CASE_ASSIGNMENT_ID,
		:new.WKF_CASE_ID,
		:new.WKF_CASE_ASSIGNED_BY,
		:new.WKF_CASE_ASSIGNED_TO,
		:new.WKF_CASE_ASSIGNMENT_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

End WKF_CASE_ASSGN_audir_trgr;
/
DROP TRIGGER ADR.WKF_CASE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE for each row
declare
    mDML char(1);
begin

  if DELETING then
       insert into WKF_CASE_H
    (

    WKF_CASE_H_ID,
    WKF_CASE_ID,
    PERSON_ID,
    WKF_CASE_TYPE_ID,
    WKF_CASE_REQUEST_TYPE_ID,
    WKF_CASE_ISSUE_TYPE_ID,
    REQUEST_RECEIVED_SITE_ID,
    REQUEST_RECEIVED_DATE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE,
    Bf_Processed
    )
    values
    (
    WKF_CASE_H_S.nextval,
    :old.WKF_CASE_ID,
    :old.PERSON_ID,
    :old.WKF_CASE_TYPE_ID,
    :old.WKF_CASE_REQUEST_TYPE_ID,
    :old.WKF_CASE_ISSUE_TYPE_ID,
    :old.REQUEST_RECEIVED_SITE_ID,
    :old.REQUEST_RECEIVED_DATE,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.RECORD_MODIFIED_COUNT,
    'D',
    :old.Bf_Processed
    );
  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

       insert into WKF_CASE_H
    (
    WKF_CASE_H_ID,
    WKF_CASE_ID,
    PERSON_ID,
    WKF_CASE_TYPE_ID,
    WKF_CASE_REQUEST_TYPE_ID,
    WKF_CASE_ISSUE_TYPE_ID,
    REQUEST_RECEIVED_SITE_ID,
    REQUEST_RECEIVED_DATE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE,
    Bf_Processed
    )
    values
    (
    WKF_CASE_H_S.nextval,
    :new.WKF_CASE_ID,
    :new.PERSON_ID,
    :new.WKF_CASE_TYPE_ID,
    :new.WKF_CASE_REQUEST_TYPE_ID,
    :new.WKF_CASE_ISSUE_TYPE_ID,
    :new.REQUEST_RECEIVED_SITE_ID,
    :new.REQUEST_RECEIVED_DATE,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.RECORD_MODIFIED_COUNT,
    mDML,
    :new.Bf_Processed
    );
  end if;

End WKF_CASE_audir_trgr;
/
DROP TRIGGER ADR.WKF_CASE_COMM_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_COMM_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE_COMMENTS for each row
declare
   	mDML char(1);
begin

	if DELETING then
	     insert into WKF_CASE_Comments_H
		(
		WKF_CASE_COMMENT_H_ID,
		WKF_CASE_ID,
		WKF_CASE_COMMENT_ID,
		COMMENT_VALUE ,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_COMMENTS_H_S.nextval  ,
		:old.WKF_CASE_ID,
		:old.WKF_CASE_COMMENT_ID,
		:old.COMMENT_VALUE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

	     insert into WKF_CASE_Comments_H
		(
		WKF_CASE_COMMENT_H_ID,
		WKF_CASE_ID,
		WKF_CASE_COMMENT_ID,
		COMMENT_VALUE ,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_COMMENTS_H_S.nextval  ,
		:new.WKF_CASE_ID,
		:new.WKF_CASE_COMMENT_ID,
		:new.COMMENT_VALUE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

End WKF_CASE_COMM_audir_trgr;
/
DROP TRIGGER ADR.WKF_CASE_STA_DET_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_STA_DET_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE_STATUS_DETAIL for each row
declare
   	mDML char(1);
begin

	if DELETING then
	     insert into WKF_CASE_STATUS_DETAIL_H
		(
		WKF_CASE_STATUS_DETAIL_H_ID,
		WKF_CASE_STATUS_DETAIL_ID,
		WKF_CASE_ID,
		WKF_CASE_REQUEST_TYPE_ID ,
		WKF_CASE_STATUS_TYPE_ID ,
		WKF_CASE_ACTIVITY_TYPE_ID,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_STATUS_DETAIL_H_S.nextval  ,
		:old.WKF_CASE_STATUS_DETAIL_ID,
		:old.WKF_CASE_ID,
		:old.WKF_CASE_REQUEST_TYPE_ID,
		:old.WKF_CASE_STATUS_TYPE_ID ,
		:old.WKF_CASE_ACTIVITY_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

	     insert into WKF_CASE_STATUS_DETAIL_H
		(
		WKF_CASE_STATUS_DETAIL_H_ID,
		WKF_CASE_STATUS_DETAIL_ID,
		WKF_CASE_ID,
		WKF_CASE_REQUEST_TYPE_ID ,
		WKF_CASE_STATUS_TYPE_ID ,
		WKF_CASE_ACTIVITY_TYPE_ID,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_STATUS_DETAIL_H_S.nextval  ,
		:new.WKF_CASE_STATUS_DETAIL_ID,
		:new.WKF_CASE_ID,
		:new.WKF_CASE_REQUEST_TYPE_ID,
		:new.WKF_CASE_STATUS_TYPE_ID ,
		:new.WKF_CASE_ACTIVITY_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

End WKF_CASE_STA_det_audir_trgr;
/
DROP TRIGGER ADR.WKF_MSG_CASE_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER ADR.wkf_msg_case_audir_trgr
after Update or Delete or Insert
ON ADR.WKF_MESSAGING_CASE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into WKF_MESSAGING_CASE_H
		(
		WKF_MESSAGING_CASE_H_ID,
		WKF_MESSAGING_CASE_ID,
		HL7_MESSAGE_ID,
		WKF_CASE_ID,
		MESSAGE_TRANSMISSION_TYPE_ID,
		ACK_TYPE_ID,
		STD_INSTITUTION_ID,
		TRANSMISSION_TYPE_CODE,
		TRANSMISSION_DATE,
		ACK_DATE,
		ERROR_MESSAGE_TEXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_MESSAGING_CASE_H_S.nextval,
		:old.WKF_MESSAGING_CASE_ID,
		:old.HL7_MESSAGE_ID,
		:old.WKF_CASE_ID,
		:old.MESSAGE_TRANSMISSION_TYPE_ID,
		:old.ACK_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.TRANSMISSION_TYPE_CODE,
		:old.TRANSMISSION_DATE,
		:old.ACK_DATE,
		:old.ERROR_MESSAGE_TEXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into WKF_MESSAGING_CASE_H
		(
		WKF_MESSAGING_CASE_H_ID,
		WKF_MESSAGING_CASE_ID,
		HL7_MESSAGE_ID,
		WKF_CASE_ID,
		MESSAGE_TRANSMISSION_TYPE_ID,
		ACK_TYPE_ID,
		STD_INSTITUTION_ID,
		TRANSMISSION_TYPE_CODE,
		TRANSMISSION_DATE,
		ACK_DATE,
		ERROR_MESSAGE_TEXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_MESSAGING_CASE_H_S.nextval,
		:new.WKF_MESSAGING_CASE_ID,
		:new.HL7_MESSAGE_ID,
		:new.WKF_CASE_ID,
		:new.MESSAGE_TRANSMISSION_TYPE_ID,
		:new.ACK_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.TRANSMISSION_TYPE_CODE,
		:new.TRANSMISSION_DATE,
		:new.ACK_DATE,
		:new.ERROR_MESSAGE_TEXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;
end wkf_msg_case_audir_trgr;
/
